/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.scalartable;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.scalartable.ScalarRowObject;
import ghidra.app.plugin.core.scalartable.ScalarSearchPlugin;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Resource;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.SizeLimitedAccumulatorWrapper;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.FunctionNameTableColumn;
import ghidra.util.table.field.PreviewTableColumn;
import ghidra.util.table.field.ProgramLocationTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.math.BigInteger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class ScalarSearchModel
extends AddressBasedTableModel<ScalarRowObject> {
    static final int PREVIEW_COLUMN = 1;
    static final int HEX_COLUMN = 2;
    static final int TEMP_MAX_RESULTS = 1000000;
    private static final int FUNCTION_COL_WIDTH = 150;
    private static final int HEXADECIMAL_COL_WIDTH = 100;
    private static final int DECIMAL_COL_WIDTH = 100;
    private Listing listing;
    private ProgramSelection currentSelection;
    private long minValue;
    private long maxValue;
    private SizeLimitedAccumulatorWrapper<ScalarRowObject> sizedAccumulator;

    ScalarSearchModel(ScalarSearchPlugin plugin, ProgramSelection currentSelection) {
        super("Scalars", (ServiceProvider)plugin.getTool(), null, null);
        this.currentSelection = currentSelection;
    }

    @Override
    protected TableColumnDescriptor<ScalarRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new PreviewTableColumn()));
        descriptor.addVisibleColumn((DynamicTableColumn)new ScalarHexValueTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ScalarSignedDecimalValueTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new ScalarUnsignedDecimalValueTableColumn());
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new ScalarFunctionNameTableColumn()));
        return descriptor;
    }

    protected void doLoad(Accumulator<ScalarRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.listing == null) {
            return;
        }
        this.sizedAccumulator = new SizeLimitedAccumulatorWrapper(accumulator, 1000000);
        if (this.currentSelection != null) {
            this.loadTableFromSelection(monitor);
            return;
        }
        monitor.initialize(this.listing.getNumCodeUnits());
        InstructionIterator instructions = this.listing.getInstructions(true);
        DataIterator dataIterator = this.listing.getDefinedData(true);
        this.iterateOverInstructions(monitor, instructions);
        this.iterateOverData(monitor, dataIterator);
        this.sizedAccumulator = null;
    }

    private boolean tooManyResults() {
        return this.sizedAccumulator.hasReachedSizeLimit();
    }

    void initialize(Program p, long newMinValue, long newMaxValue) {
        this.minValue = newMinValue;
        this.maxValue = newMaxValue;
        this.setProgram(p);
        this.listing = p.getListing();
        this.reload();
    }

    private void loadTableFromSelection(TaskMonitor monitor) throws CancelledException {
        BigInteger max = BigInteger.valueOf(0L);
        AddressRangeIterator ranges = this.currentSelection.getAddressRanges();
        for (AddressRange range : ranges) {
            max = max.add(range.getBigLength());
        }
        monitor.initialize(max.longValue());
        ranges = this.currentSelection.getAddressRanges();
        for (AddressRange range : ranges) {
            AddressSet addressSet = new AddressSet(range.getMinAddress(), range.getMaxAddress());
            InstructionIterator instructions = this.listing.getInstructions((AddressSetView)addressSet, true);
            this.iterateOverInstructions(monitor, instructions);
            DataIterator dataIterator = this.listing.getDefinedData((AddressSetView)addressSet, true);
            this.iterateOverData(monitor, dataIterator);
        }
    }

    private void iterateOverInstructions(TaskMonitor monitor, InstructionIterator instructions) throws CancelledException {
        for (Instruction instruction : instructions) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            if (this.tooManyResults()) {
                return;
            }
            int numOperands = instruction.getNumOperands();
            for (int opIndex = 0; opIndex <= numOperands; ++opIndex) {
                monitor.checkCanceled();
                Object[] opObjs = instruction.getOpObjects(opIndex);
                Reference[] operandReferences = instruction.getOperandReferences(opIndex);
                if (operandReferences.length != 0) continue;
                this.getScalarFromInstruction(instruction, opObjs, monitor);
            }
        }
    }

    private void iterateOverData(TaskMonitor monitor, DataIterator dataIterator) throws CancelledException {
        while (dataIterator.hasNext()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            if (this.tooManyResults()) {
                return;
            }
            Data data = dataIterator.next();
            int numComponents = data.getNumComponents();
            if (numComponents > 0) {
                this.findScalarsInCompositeData(data, numComponents, monitor);
                continue;
            }
            this.addScalarFromData(data);
        }
    }

    private void getScalarFromInstruction(Instruction instruction, Object[] opObjs, TaskMonitor monitor) throws CancelledException {
        Scalar scalar = this.getScalarFromOperand(opObjs, monitor);
        if (scalar != null) {
            this.addMatch(new ScalarRowObject((CodeUnit)instruction, scalar));
        }
    }

    private void addMatch(ScalarRowObject rowObject) {
        if (rowObject == null) {
            return;
        }
        Scalar scalar = rowObject.getScalar();
        long value = scalar.getSignedValue();
        if (value < this.minValue) {
            return;
        }
        if (value > this.maxValue) {
            return;
        }
        this.sizedAccumulator.add((Object)rowObject);
    }

    private void findScalarsInCompositeData(Data data, int numComponents, TaskMonitor monitor) throws CancelledException {
        if (data.getDataType() instanceof Resource) {
            return;
        }
        for (int i = 0; i < numComponents; ++i) {
            monitor.checkCanceled();
            Data component = data.getComponent(i);
            this.getScalarsFromCompositeData(data, component, monitor);
        }
    }

    private void getScalarsFromCompositeData(Data data, Data component, TaskMonitor monitor) throws CancelledException {
        int numSubComponents = component.getNumComponents();
        if (numSubComponents == 0) {
            this.addDataFromComponent(data, component);
            return;
        }
        for (int i = 0; i < numSubComponents; ++i) {
            monitor.checkCanceled();
            Data subComponent = component.getComponent(i);
            this.getScalarsFromCompositeData(data, subComponent, monitor);
        }
    }

    private void addScalarFromData(Data data) {
        Scalar scalar = this.getScalarFromData(data);
        if (scalar == null) {
            return;
        }
        this.addMatch(new ScalarRowObject((CodeUnit)data, scalar));
    }

    private void addDataFromComponent(Data data, Data component) {
        Scalar scalar = this.getScalarFromData(component);
        if (scalar == null) {
            return;
        }
        this.addMatch(new ScalarRowObject((CodeUnit)component, scalar));
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet set = new AddressSet();
        for (int element : rows) {
            ScalarRowObject rowObject = (ScalarRowObject)this.getRowObject(element);
            CodeUnit cu = rowObject.getCodeUnit();
            set.addRange(cu.getMinAddress(), cu.getMaxAddress());
        }
        return new ProgramSelection((AddressSetView)set);
    }

    @Override
    public Address getAddress(int row) {
        ScalarRowObject rowObject = (ScalarRowObject)this.getRowObject(row);
        return rowObject.getAddress();
    }

    private Scalar getScalarFromOperand(Object[] opObjs, TaskMonitor monitor) throws CancelledException {
        if (opObjs == null) {
            return null;
        }
        Object obj = null;
        for (Object opObj : opObjs) {
            monitor.checkCanceled();
            if (opObj instanceof Register) {
                return null;
            }
            if (!(opObj instanceof Scalar)) continue;
            obj = opObj;
        }
        return (Scalar)obj;
    }

    private Scalar getScalarFromData(Data data) {
        if (data == null) {
            return null;
        }
        if (!data.isDefined()) {
            return null;
        }
        Object value = data.getValue();
        if (!(value instanceof Scalar)) {
            return null;
        }
        return (Scalar)value;
    }

    private class ScalarFunctionNameTableColumn
    extends FunctionNameTableColumn {
        private ScalarFunctionNameTableColumn() {
        }

        public int getColumnPreferredWidth() {
            return 150;
        }
    }

    private class ScalarUnsignedDecimalValueTableColumn
    extends AbstractDynamicTableColumn<ScalarRowObject, Long, Program>
    implements ProgramLocationTableColumn<ScalarRowObject, Long> {
        private ScalarUnsignedDecimalValueTableColumn() {
        }

        public String getColumnName() {
            return "Decimal (Unsigned)";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public Long getValue(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            return rowObject.getScalar().getUnsignedValue();
        }

        @Override
        public ProgramLocation getProgramLocation(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) {
            return new ProgramLocation(ScalarSearchModel.this.program, rowObject.getAddress());
        }
    }

    private class ScalarSignedDecimalValueTableColumn
    extends AbstractDynamicTableColumn<ScalarRowObject, Long, Program>
    implements ProgramLocationTableColumn<ScalarRowObject, Long> {
        private ScalarSignedDecimalValueTableColumn() {
        }

        public String getColumnName() {
            return "Decimal (Signed)";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public Long getValue(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            return rowObject.getScalar().getSignedValue();
        }

        @Override
        public ProgramLocation getProgramLocation(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) {
            return new ProgramLocation(ScalarSearchModel.this.program, rowObject.getAddress());
        }
    }

    private class ScalarHexValueTableColumn
    extends AbstractDynamicTableColumn<ScalarRowObject, Scalar, Program>
    implements ProgramLocationTableColumn<ScalarRowObject, Scalar> {
        private GColumnRenderer<Scalar> renderer = new AbstractGColumnRenderer<Scalar>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(data);
                Scalar value = (Scalar)data.getValue();
                String text = this.asString(value);
                label.setText(text);
                label.setOpaque(true);
                this.setHorizontalAlignment(4);
                return label;
            }

            private String asString(Scalar s) {
                if (s == null) {
                    return "";
                }
                return s.toString(16, false, false, "", "");
            }

            protected void configureFont(JTable table, TableModel model, int column) {
                this.setFont(this.getFixedWidthFont());
            }

            public String getFilterString(Scalar t, Settings settings) {
                return this.asString(t);
            }
        };

        private ScalarHexValueTableColumn() {
        }

        public String getColumnName() {
            return "Hex";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public Scalar getValue(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            return rowObject.getScalar();
        }

        @Override
        public ProgramLocation getProgramLocation(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) {
            return new ProgramLocation(ScalarSearchModel.this.program, rowObject.getAddress());
        }

        public GColumnRenderer<Scalar> getColumnRenderer() {
            return this.renderer;
        }
    }
}

