/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.dnd.GenericDataFlavor;
import docking.dnd.StringTransferable;
import docking.widgets.OptionDialog;
import ghidra.app.util.ClipboardType;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.MemoryByteIterator;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class ByteCopier {
    public static DataFlavor BYTE_STRING_FLAVOR = ByteCopier.createByteStringLocalDataTypeFlavor();
    public static DataFlavor BYTE_STRING_NO_SPACES_FLAVOR = ByteCopier.createByteStringNoSpacesLocalDataTypeFlavor();
    protected static final List<ClipboardType> EMPTY_LIST = Collections.emptyList();
    public static final ClipboardType BYTE_STRING_TYPE = new ClipboardType(BYTE_STRING_FLAVOR, "Byte String");
    public static final ClipboardType BYTE_STRING_NO_SPACE_TYPE = new ClipboardType(BYTE_STRING_NO_SPACES_FLAVOR, "Byte String (No Spaces)");
    protected PluginTool tool;
    protected Program currentProgram;
    protected ProgramSelection currentSelection;
    protected ProgramLocation currentLocation;

    private static DataFlavor createByteStringLocalDataTypeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Local flavor--byte string with spaces");
        }
        catch (Exception e) {
            Msg.showError(ByteCopier.class, null, (String)"Could Not Create Data Flavor", (Object)"Unexpected exception creating data flavor for byte string", (Throwable)e);
            return null;
        }
    }

    private static DataFlavor createByteStringNoSpacesLocalDataTypeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Local flavor--byte string with NO spaces");
        }
        catch (Exception e) {
            Msg.showError(ByteCopier.class, null, (String)"Could Not Create Data Flavor", (Object)"Unexpected exception creating data flavor for byte string with no spaces", (Throwable)e);
            return null;
        }
    }

    protected ByteCopier() {
    }

    protected Transferable copyBytes(boolean includeSpaces, TaskMonitor monitor) {
        return this.copyBytes(this.currentSelection, includeSpaces, monitor);
    }

    protected Transferable copyBytes(AddressSetView addresses, boolean includeSpaces, TaskMonitor monitor) {
        return ByteCopier.createStringTransferable(this.copyBytesAsString(addresses, includeSpaces, monitor));
    }

    protected String copyBytesAsString(AddressSetView addresses, boolean includeSpaces, TaskMonitor monitor) {
        Memory memory = this.currentProgram.getMemory();
        String delimiter = includeSpaces ? " " : "";
        ByteIterator bytes = new ByteIterator(addresses, memory);
        return NumericUtilities.convertBytesToString((Iterator)bytes, (String)delimiter);
    }

    protected boolean supportsPasteTransferable(Transferable transferable) {
        return this.isValidBytesTransferable(transferable);
    }

    protected boolean isValidBytesTransferable(Transferable transferable) {
        DataFlavor[] flavors;
        for (DataFlavor element : flavors = transferable.getTransferDataFlavors()) {
            try {
                Object object = transferable.getTransferData(element);
                if (!(object instanceof String)) continue;
                String string = (String)object;
                if (!this.isOnlyAsciiBytes(string)) {
                    this.tool.setStatusInfo("Paste string contains non-text ascii bytes. Only the ascii text will be pasted.", true);
                    string = this.keepOnlyAsciiBytes(string);
                }
                return this.getBytes(string) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private byte[] getBytes(String transferString) {
        byte[] bytes = this.getHexBytes(transferString);
        if (bytes != null) {
            return bytes;
        }
        return this.getAsciiBytes(transferString);
    }

    private byte[] getAsciiBytes(String s) {
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!StringUtilities.isAsciiChar((char)c)) {
                return null;
            }
            bytes[i] = (byte)c;
        }
        return bytes;
    }

    private String keepOnlyAsciiBytes(String s) {
        byte[] bytes = new byte[s.length()];
        int byteIndex = 0;
        for (int stringIndex = 0; stringIndex < s.length(); ++stringIndex) {
            char c = s.charAt(stringIndex);
            if (!StringUtilities.isAsciiChar((char)c)) continue;
            bytes[byteIndex++] = (byte)c;
        }
        return new String(bytes, 0, byteIndex);
    }

    private boolean isOnlyAsciiBytes(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (StringUtilities.isAsciiChar((char)c)) continue;
            return false;
        }
        return true;
    }

    private byte[] getHexBytes(String s) {
        int length = (s = s.trim().replaceAll("\\s", "")).length();
        if (length % 2 != 0) {
            return null;
        }
        try {
            byte[] data = new byte[length / 2];
            int cindex = 0;
            for (int i = 0; i < data.length; ++i) {
                String byteStr = s.substring(cindex, cindex + 2);
                data[i] = (byte)Integer.parseInt(byteStr, 16);
                cindex += 2;
            }
            return data;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean pasteBytes(Transferable pasteData) throws UnsupportedFlavorException, IOException {
        if (!this.supportsPasteTransferable(pasteData)) {
            this.tool.setStatusInfo("Paste failed: No valid data on clipboard", true);
            return false;
        }
        if (pasteData.isDataFlavorSupported(BYTE_STRING_FLAVOR)) {
            String data = (String)pasteData.getTransferData(BYTE_STRING_FLAVOR);
            return this.pasteByteString(data);
        }
        if (pasteData.isDataFlavorSupported(BYTE_STRING_NO_SPACES_FLAVOR)) {
            String data = (String)pasteData.getTransferData(BYTE_STRING_NO_SPACES_FLAVOR);
            return this.pasteByteString(data);
        }
        String string = (String)pasteData.getTransferData(DataFlavor.stringFlavor);
        return this.pasteByteString(string);
    }

    protected boolean pasteByteString(final String string) {
        Command cmd = new Command(){
            private String status = "Pasting";

            public boolean applyTo(DomainObject domainObject) {
                if (domainObject instanceof Program) {
                    int length;
                    byte[] bytes;
                    String validString = string;
                    if (!ByteCopier.this.isOnlyAsciiBytes(string)) {
                        ByteCopier.this.tool.setStatusInfo("Pasted string contained non-text ascii bytes. Only the ascii text was pasted.", true);
                        validString = ByteCopier.this.keepOnlyAsciiBytes(string);
                    }
                    if ((bytes = ByteCopier.this.getBytes(validString)) == null) {
                        this.status = "Improper data format (expected sequence of hex bytes)";
                        ByteCopier.this.tool.beep();
                        return false;
                    }
                    Program curProgram = (Program)domainObject;
                    Listing listing = curProgram.getListing();
                    Address curAddr = ByteCopier.this.currentLocation.getAddress();
                    int byteCount = bytes.length;
                    for (int i = 0; i < byteCount; i += length) {
                        if (curAddr == null) {
                            this.status = "Not enough addresses to paste bytes";
                            ByteCopier.this.tool.beep();
                            return false;
                        }
                        CodeUnit curCodeUnit = listing.getCodeUnitContaining(curAddr);
                        if (!(curCodeUnit instanceof Data) || ((Data)curCodeUnit).isDefined()) {
                            this.status = "Cannot paste on top of defined instructions/data";
                            ByteCopier.this.tool.beep();
                            return false;
                        }
                        length = curCodeUnit.getLength();
                        curAddr = curCodeUnit.getMaxAddress().next();
                    }
                    Object partialText = validString.length() < 40 ? validString : validString.substring(0, 40) + " ...";
                    int result = OptionDialog.showYesNoDialog(null, (String)"Paste String Into Program?", (String)("Are you sure you want to paste the string \"" + (String)partialText + "\"\n into the program's memory?"));
                    if (result == 2) {
                        return true;
                    }
                    curAddr = ByteCopier.this.currentLocation.getAddress();
                    for (byte element : bytes) {
                        try {
                            curProgram.getMemory().setByte(curAddr, element);
                        }
                        catch (MemoryAccessException memoryAccessException) {
                            // empty catch block
                        }
                        curAddr = curAddr.next();
                    }
                    return true;
                }
                return false;
            }

            public String getStatusMsg() {
                return this.status;
            }

            public String getName() {
                return "Paste";
            }
        };
        return this.tool.execute(cmd, (DomainObject)this.currentProgram);
    }

    public static Transferable createStringTransferable(String text) {
        return new StringTransferable(text);
    }

    public static class ByteViewerTransferable
    implements Transferable {
        private final DataFlavor[] flavors = new DataFlavor[]{BYTE_STRING_NO_SPACE_TYPE.getFlavor(), BYTE_STRING_TYPE.getFlavor(), DataFlavor.stringFlavor};
        private final List<DataFlavor> flavorList = Arrays.asList(this.flavors);
        private final String byteString;
        private final String byteViewerRepresentation;

        public ByteViewerTransferable(String byteString) {
            this(byteString, null);
        }

        public ByteViewerTransferable(String byteString, String byteViewerRepresentation) {
            this.byteString = byteString;
            this.byteViewerRepresentation = byteViewerRepresentation;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.stringFlavor)) {
                if (this.byteViewerRepresentation != null) {
                    return this.byteViewerRepresentation;
                }
                return this.byteString;
            }
            if (flavor.equals(BYTE_STRING_TYPE.getFlavor())) {
                return this.byteString;
            }
            if (flavor.equals(BYTE_STRING_NO_SPACE_TYPE.getFlavor())) {
                return this.byteString;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavorList.contains(flavor);
        }
    }

    private static class ByteIterator
    implements Iterator<Byte> {
        private MemoryByteIterator byteIterator;
        private Byte next;

        ByteIterator(AddressSetView addresses, Memory memory) {
            this.byteIterator = new MemoryByteIterator(memory, addresses);
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (!this.byteIterator.hasNext()) {
                return false;
            }
            try {
                this.next = this.byteIterator.next();
            }
            catch (MemoryAccessException e) {
                Msg.error((Object)this, (Object)"Unable to read next byte", (Throwable)e);
                return false;
            }
            return true;
        }

        @Override
        public Byte next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Byte result = this.next;
            this.next = null;
            return result;
        }
    }
}

