/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.cmd.data.CreateStringCmd;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.task.TaskMonitor;
import util.demangler.GenericDemangledObject;
import util.demangler.GenericDemangledString;

public class DemangledString
extends DemangledObject {
    private String string;
    private int length;
    private boolean unicode;

    public DemangledString(String name, String string, int length, boolean unicode) {
        this.setName(name);
        this.string = string;
        this.length = length;
        this.unicode = unicode;
    }

    DemangledString(GenericDemangledString generic) {
        super((GenericDemangledObject)generic);
        this.string = generic.getString();
        this.length = generic.getLength();
        this.unicode = generic.isUnicode();
    }

    @Override
    public String getSignature(boolean format) {
        StringBuffer buffer = new StringBuffer();
        if (this.specialPrefix != null) {
            buffer.append(this.specialPrefix + " for ");
        }
        buffer.append(this.string);
        if (this.specialSuffix != null) {
            buffer.append(" " + this.specialSuffix);
        }
        return buffer.toString();
    }

    private static boolean hasLabel(Program program, Address address, String label) {
        SymbolTable symbolTable = program.getSymbolTable();
        for (Symbol s : symbolTable.getSymbols(address)) {
            if (!label.equals(s.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean applyTo(Program program, Address address, DemanglerOptions options, TaskMonitor monitor) throws Exception {
        String label = SymbolUtilities.replaceInvalidChars((String)this.string, (boolean)false);
        if (DemangledString.hasLabel(program, address, label)) {
            return true;
        }
        if (!super.applyTo(program, address, options, monitor)) {
            return false;
        }
        Symbol s = program.getSymbolTable().getPrimarySymbol(address);
        if (s != null && s.getSymbolType() == SymbolType.FUNCTION) {
            Msg.error((Object)this, (Object)("Failed to demangled string at " + address + " due to existing function"));
            return false;
        }
        CreateStringCmd cmd = new CreateStringCmd(address, -1, this.isUnicode());
        cmd.applyTo((DomainObject)program);
        Symbol demangledSymbol = this.applyDemangledName(this.buildStringLabel(), address, true, false, program);
        return demangledSymbol != null;
    }

    private String buildStringLabel() {
        if (this.specialPrefix != null) {
            return this.getName();
        }
        int len = this.string.length();
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = this.string.charAt(i);
            if (StringUtilities.isDisplayable((int)c) && c != ' ') {
                buf.append(c);
                continue;
            }
            buf.append('_');
        }
        String prefix = this.isUnicode() ? "u_" : "s_";
        return prefix + buf.toString();
    }

    public String getString() {
        return this.string;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isUnicode() {
        return this.unicode;
    }
}

