/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.multilisting;

import docking.widgets.fieldpanel.Layout;
import ghidra.app.util.viewer.field.DummyFieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.format.FormatModelListener;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingModelListener;
import ghidra.app.util.viewer.listingpanel.ProgramBigListingModel;
import ghidra.app.util.viewer.multilisting.AddressTranslator;
import ghidra.app.util.viewer.multilisting.LayoutCache;
import ghidra.app.util.viewer.multilisting.ListingModelConverter;
import ghidra.app.util.viewer.multilisting.MultiLayout;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.task.TaskMonitor;

public class MultiListingLayoutModel
implements ListingModelListener,
FormatModelListener {
    private FormatManager formatMgr;
    private ListingModel[] models;
    private ListingModel[] alignedModels;
    private LayoutCache cache;
    private WeakSet<ListingModelListener> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private DummyFieldFactory emptyFactory;
    private AddressSetView primaryAddrSet;

    public MultiListingLayoutModel(FormatManager formatMgr, Program[] programs, AddressSetView primaryAddrSet) {
        this.formatMgr = formatMgr;
        this.primaryAddrSet = primaryAddrSet;
        this.emptyFactory = new DummyFieldFactory(formatMgr);
        this.cache = new LayoutCache();
        this.models = new ListingModel[programs.length];
        this.alignedModels = new ListingModel[programs.length];
        for (int programIndex = 0; programIndex < programs.length; ++programIndex) {
            this.models[programIndex] = this.createListingModel(programs, programIndex);
            this.alignedModels[programIndex] = new AlignedModel(programIndex);
            this.models[programIndex].addListener(this);
        }
        formatMgr.addFormatModelListener(this);
    }

    private ListingModel createListingModel(Program[] programs, int programIndex) {
        ListingModel model = new ProgramBigListingModel(programs[programIndex], this.formatMgr);
        if (programIndex != 0) {
            model = new ListingModelConverter(this.models[0], model);
        }
        return model;
    }

    public ListingModel getAlignedModel(int index) {
        return this.alignedModels[index];
    }

    private void addLayoutListener(ListingModelListener listener) {
        this.listeners.add((Object)listener);
    }

    private void removeLayoutListener(ListingModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void dataChanged(boolean updateImmediately) {
        this.cache.clear();
        for (ListingModelListener listener : this.listeners) {
            listener.dataChanged(updateImmediately);
        }
    }

    @Override
    public void modelSizeChanged() {
        this.cache.clear();
        for (ListingModelListener listener : this.listeners) {
            listener.modelSizeChanged();
        }
    }

    private MultiLayout getMultiLayout(Address primaryModelAddress, boolean isGap) {
        if (primaryModelAddress == null) {
            return null;
        }
        MultiLayout ml = (MultiLayout)this.cache.get(primaryModelAddress);
        if (ml == null) {
            Layout[] layouts = new Layout[this.models.length];
            boolean hasLayout = false;
            for (int i = 0; i < this.models.length; ++i) {
                layouts[i] = this.models[i].getLayout(primaryModelAddress, isGap);
                hasLayout |= layouts[i] != null;
            }
            ml = hasLayout ? new MultiLayout(layouts, this.formatMgr, this.emptyFactory) : new MultiLayout();
            this.cache.put(primaryModelAddress, ml);
        }
        if (ml.isEmpty()) {
            return null;
        }
        return ml;
    }

    @Override
    public void formatModelAdded(FieldFormatModel model) {
        this.dataChanged(true);
    }

    @Override
    public void formatModelRemoved(FieldFormatModel model) {
        this.dataChanged(true);
    }

    @Override
    public void formatModelChanged(FieldFormatModel model) {
        this.modelSizeChanged();
    }

    public ListingModel getModel(int index) {
        return this.models[index];
    }

    public void setAddressTranslator(AddressTranslator translator) {
        for (int i = 0; i < this.alignedModels.length; ++i) {
            if (!(this.models[i] instanceof ListingModelConverter)) continue;
            ListingModelConverter model = (ListingModelConverter)this.models[i];
            model.setAddressTranslator(translator);
        }
    }

    public void setAddressSet(AddressSetView view) {
        this.primaryAddrSet = view;
        this.modelSizeChanged();
    }

    class AlignedModel
    implements ListingModel {
        private int modelID;

        AlignedModel(int modelID) {
            this.modelID = modelID;
        }

        @Override
        public void dispose() {
        }

        @Override
        public int getMaxWidth() {
            return MultiListingLayoutModel.this.models[this.modelID].getMaxWidth();
        }

        @Override
        public Address getAddressAfter(Address address) {
            return this.getNextAddress(address, true);
        }

        @Override
        public Address getAddressBefore(Address address) {
            return this.getNextAddress(address, false);
        }

        private Address getNextAddress(Address address, boolean after) {
            Program primaryProgram;
            Address primaryModelAddress;
            Address nextAddress = null;
            Program program = this.getProgram();
            Address address2 = primaryModelAddress = program == (primaryProgram = MultiListingLayoutModel.this.models[0].getProgram()) ? address : SimpleDiffUtility.getCompatibleAddress((Program)program, (Address)address, (Program)primaryProgram);
            if (primaryModelAddress == null) {
                return null;
            }
            for (ListingModel tempModel : MultiListingLayoutModel.this.models) {
                boolean isNextAddress;
                Address addressAfter;
                Address tempModelAddressAfter = after ? tempModel.getAddressAfter(primaryModelAddress) : tempModel.getAddressBefore(primaryModelAddress);
                Program tempModelProgram = tempModel.getProgram();
                Address address3 = addressAfter = program == tempModelProgram ? tempModelAddressAfter : SimpleDiffUtility.getCompatibleAddress((Program)tempModelProgram, (Address)tempModelAddressAfter, (Program)program);
                if (addressAfter == null) continue;
                if (nextAddress == null) {
                    nextAddress = addressAfter;
                    continue;
                }
                int result = addressAfter.compareTo((Object)nextAddress);
                boolean bl = after ? result < 0 : (isNextAddress = result > 0);
                if (!isNextAddress) continue;
                nextAddress = addressAfter;
            }
            return nextAddress;
        }

        @Override
        public Layout getLayout(Address thisModelAddress, boolean isGapAddress) {
            Address primaryModelAddress = this.modelID == 0 ? thisModelAddress : SimpleDiffUtility.getCompatibleAddress((Program)this.getProgram(), (Address)thisModelAddress, (Program)MultiListingLayoutModel.this.models[0].getProgram());
            MultiLayout ml = MultiListingLayoutModel.this.getMultiLayout(primaryModelAddress, isGapAddress);
            if (ml != null) {
                return ml.getLayout(this.modelID);
            }
            return null;
        }

        @Override
        public void addListener(ListingModelListener listener) {
            MultiListingLayoutModel.this.addLayoutListener(listener);
        }

        @Override
        public void removeListener(ListingModelListener listener) {
            MultiListingLayoutModel.this.removeLayoutListener(listener);
        }

        @Override
        public Program getProgram() {
            return MultiListingLayoutModel.this.models[this.modelID].getProgram();
        }

        @Override
        public boolean isOpen(Data data) {
            return MultiListingLayoutModel.this.models[this.modelID].isOpen(data);
        }

        @Override
        public void toggleOpen(Data data) {
            MultiListingLayoutModel.this.models[this.modelID].toggleOpen(data);
        }

        @Override
        public void openData(Data data) {
            MultiListingLayoutModel.this.models[this.modelID].openData(data);
        }

        @Override
        public void openAllData(Data data, TaskMonitor monitor) {
            MultiListingLayoutModel.this.models[this.modelID].openAllData(data, null);
        }

        @Override
        public void openAllData(AddressSetView addresses, TaskMonitor monitor) {
            MultiListingLayoutModel.this.models[this.modelID].openAllData(addresses, null);
        }

        @Override
        public void closeAllData(Data data, TaskMonitor monitor) {
            MultiListingLayoutModel.this.models[this.modelID].closeAllData(data, null);
        }

        @Override
        public void closeAllData(AddressSetView addresses, TaskMonitor monitor) {
            MultiListingLayoutModel.this.models[this.modelID].closeAllData(addresses, null);
        }

        @Override
        public void closeData(Data data) {
            MultiListingLayoutModel.this.models[this.modelID].closeData(data);
        }

        @Override
        public AddressSetView getAddressSet() {
            return DiffUtility.getCompatibleAddressSet(MultiListingLayoutModel.this.primaryAddrSet, this.getProgram());
        }

        @Override
        public boolean isClosed() {
            for (ListingModel model : MultiListingLayoutModel.this.models) {
                if (!model.isClosed()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setFormatManager(FormatManager formatManager) {
            for (ListingModel model : MultiListingLayoutModel.this.models) {
                model.setFormatManager(formatManager);
            }
        }

        @Override
        public AddressSet adjustAddressSetToCodeUnitBoundaries(AddressSet addressSet) {
            return MultiListingLayoutModel.this.models[this.modelID].adjustAddressSetToCodeUnitBoundaries(addressSet);
        }
    }
}

