/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.NotFoundException;

public class PIC30_ElfRelocationHandler
extends ElfRelocationHandler {
    public static final int R_PIC30_NONE = 0;
    public static final int R_PIC30_8 = 1;
    public static final int R_PIC30_16 = 2;
    public static final int R_PIC30_32 = 3;
    public static final int R_PIC30_FILE_REG_WORD_WITH_DST = 7;
    public static final int R_PIC30_WORD = 8;
    public static final int R_PIC30_PCREL_BRANCH = 28;

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 118;
    }

    public void relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        int type = relocation.getType();
        if (type == 0) {
            return;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int symbolIndex = relocation.getSymbolIndex();
        long addend = relocation.getAddend();
        if (symbolIndex == 0) {
            return;
        }
        long offset = (int)relocationAddress.getOffset();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        int oldValue = memory.getInt(relocationAddress);
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() == 118) {
            switch (type) {
                case 3: {
                    int newValue = (int)symbolValue + (int)addend + oldValue & 0xFFFFFFFF;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                case 28: {
                    int offsetValue = memory.getShort(relocationAddress) + 1;
                    offsetValue *= 2;
                    int newValue = (int)(symbolValue + (long)((int)addend) - (offset + 4L));
                    memory.setShort(relocationAddress, (short)((newValue >>>= 2) & 0xFFFF));
                    break;
                }
                case 2: {
                    short oldShortValue = memory.getShort(relocationAddress);
                    int newValue = (int)symbolValue + (int)addend + oldShortValue >> 1 & 0xFFFF;
                    memory.setShort(relocationAddress, (short)newValue);
                    break;
                }
                case 7: {
                    int newValue = (int)symbolValue + (int)addend >> 1 & Short.MAX_VALUE;
                    int dst = oldValue >> 4 & Short.MAX_VALUE;
                    newValue = newValue + dst << 4 | oldValue & 0xFFF1000F;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                case 8: {
                    int newValue = (int)symbolValue + (int)addend >> 1 & 0xFFFF;
                    newValue = newValue << 4 | oldValue;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                default: {
                    String symbolName = sym.getNameAsString();
                    PIC30_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
                }
            }
        }
    }
}

