/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.ocsp.CertStatus;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.ocsp.RevokedInfo;
import org.bouncycastle.asn1.ocsp.SingleResponse;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.BasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OCSP;
import org.jruby.ext.openssl.OCSPCertificateId;
import org.jruby.ext.openssl.OCSPRequest;
import org.jruby.ext.openssl.OCSPSingleResponse;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Extension;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.X509StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class OCSPBasicResponse
extends RubyObject {
    private static final long serialVersionUID = 8755480816625884227L;
    private static final String OCSP_NOCERTS = "NOCERTS";
    private static final String OCSP_NOCHAIN = "NOCHAIN";
    private static final String OCSP_NOCHECKS = "NOCHECKS";
    private static final String OCSP_NOTIME = "NOTIME";
    private static final String OCSP_NOSIGS = "NOSIGS";
    private static final String OCSP_NOVERIFY = "NOVERIFY";
    private static final String OCSP_NOINTERN = "NOINTERN";
    private static final String OCSP_RESPID_KEY = "RESPID_KEY";
    private static final String OCSP_TRUSTOTHER = "TRUSTOTHER";
    private static ObjectAllocator BASICRESPONSE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new OCSPBasicResponse(runtime, klass);
        }
    };
    private byte[] nonce;
    private List<OCSPSingleResponse> singleResponses = new ArrayList<OCSPSingleResponse>();
    private BasicOCSPResponse asn1BCBasicOCSPResp;
    private List<Extension> extensions = new ArrayList<Extension>();

    public static void createBasicResponse(Ruby runtime, RubyModule OCSP2) {
        RubyClass BasicResponse = OCSP2.defineClassUnder("BasicResponse", runtime.getObject(), BASICRESPONSE_ALLOCATOR);
        BasicResponse.defineAnnotatedMethods(OCSPBasicResponse.class);
    }

    public OCSPBasicResponse(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public OCSPBasicResponse(Ruby runtime) {
        this(runtime, (RubyClass)OCSP._OCSP(runtime).getConstantAt("BasicResponse"));
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject der) {
        if (der == null || der.isNil()) {
            return this;
        }
        this.asn1BCBasicOCSPResp = BasicOCSPResponse.getInstance((Object)StringHelper.readPossibleDERInput(context2, der).getBytes());
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2) {
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.asn1BCBasicOCSPResp = ((OCSPBasicResponse)obj).getASN1BCOCSPResp();
        return this;
    }

    @JRubyMethod(name={"add_nonce"}, rest=true)
    public OCSPBasicResponse add_nonce(IRubyObject[] args) {
        byte[] tmpNonce;
        Ruby runtime = this.getRuntime();
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)1) == 0) {
            tmpNonce = OCSP.generateNonce(runtime);
        } else {
            RubyString input = (RubyString)args[0];
            tmpNonce = input.getBytes();
        }
        this.extensions.add(new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, tmpNonce));
        this.nonce = tmpNonce;
        return this;
    }

    @JRubyMethod(name={"add_status"}, rest=true)
    public OCSPBasicResponse add_status(ThreadContext context2, IRubyObject[] args) {
        Ruby runtime = context2.getRuntime();
        Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)7, (int)7);
        IRubyObject certificateId = args[0];
        IRubyObject status2 = args[1];
        IRubyObject reason = args[2];
        IRubyObject revocation_time2 = args[3];
        IRubyObject this_update2 = args[4];
        IRubyObject next_update2 = args[5];
        IRubyObject extensions2 = args[6];
        CertStatus certStatus = null;
        switch (RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)status2))) {
            case 0: {
                certStatus = new CertStatus();
                break;
            }
            case 1: {
                ASN1GeneralizedTime revTime = this.rubyIntOrTimeToGenTime(revocation_time2);
                RevokedInfo revokedInfo = new RevokedInfo(revTime, CRLReason.lookup((int)RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)reason))));
                certStatus = new CertStatus(revokedInfo);
                break;
            }
            case 2: {
                certStatus = new CertStatus(2, (ASN1Encodable)DERNull.INSTANCE);
                break;
            }
        }
        ASN1GeneralizedTime thisUpdate = this.rubyIntOrTimeToGenTime(this_update2);
        ASN1GeneralizedTime nextUpdate = this.rubyIntOrTimeToGenTime(next_update2);
        Extensions singleExtensions = this.convertRubyExtensions(extensions2);
        CertID certID = ((OCSPCertificateId)certificateId).getCertID();
        SingleResponse ocspSingleResp = new SingleResponse(certID, certStatus, thisUpdate, nextUpdate, singleExtensions);
        OCSPSingleResponse rubySingleResp = new OCSPSingleResponse(runtime);
        try {
            rubySingleResp.initialize(context2, (IRubyObject)RubyString.newString((Ruby)runtime, (byte[])ocspSingleResp.getEncoded()));
            this.singleResponses.add(rubySingleResp);
        }
        catch (IOException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        return this;
    }

    @JRubyMethod(name={"copy_nonce"})
    public IRubyObject copy_nonce(ThreadContext context2, IRubyObject request) {
        this.add_nonce(new IRubyObject[]{RubyString.newString((Ruby)this.getRuntime(), (byte[])((OCSPRequest)request).getNonce())});
        return RubyFixnum.one((Ruby)context2.getRuntime());
    }

    @JRubyMethod(name={"find_response"})
    public IRubyObject find_response(ThreadContext context2, IRubyObject certId) {
        if (certId.isNil()) {
            return context2.nil;
        }
        OCSPCertificateId rubyCertId = (OCSPCertificateId)certId;
        Object retResp = context2.nil;
        for (OCSPSingleResponse singleResp : this.singleResponses) {
            CertID thatId;
            CertID thisId = rubyCertId.getCertID();
            if (!thisId.equals((Object)(thatId = singleResp.getBCSingleResp().getCertID()))) continue;
            retResp = singleResp;
            break;
        }
        return retResp;
    }

    @JRubyMethod(name={"responses"})
    public IRubyObject responses() {
        return RubyArray.newArray((Ruby)this.getRuntime(), this.singleResponses);
    }

    @JRubyMethod(name={"sign"}, rest=true)
    public IRubyObject sign(ThreadContext context2, IRubyObject[] args) {
        BasicOCSPRespBuilder respBuilder;
        ContentSigner contentSigner;
        Ruby runtime = context2.getRuntime();
        int flag = 0;
        IRubyObject additionalCerts = context2.nil;
        IRubyObject flags = context2.nil;
        IRubyObject digest2 = context2.nil;
        Digest digestInstance = new Digest(runtime, Digest._Digest(runtime));
        ArrayList<X509CertificateHolder> addlCerts = new ArrayList<X509CertificateHolder>();
        switch (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)2, (int)5)) {
            case 3: {
                additionalCerts = args[2];
                break;
            }
            case 4: {
                additionalCerts = args[2];
                flags = args[3];
                break;
            }
            case 5: {
                additionalCerts = args[2];
                flags = args[3];
                digest2 = args[4];
                break;
            }
        }
        if (digest2.isNil()) {
            digest2 = digestInstance.initialize(context2, new IRubyObject[]{RubyString.newString((Ruby)runtime, (String)"SHA1")});
        }
        if (!flags.isNil()) {
            flag = RubyFixnum.fix2int((IRubyObject)flags);
        }
        if (additionalCerts.isNil()) {
            flag |= RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOCERTS)));
        }
        X509Cert signer = (X509Cert)args[0];
        PKey signerKey = (PKey)args[1];
        String keyAlg = signerKey.getAlgorithm();
        String digAlg = ((Digest)digest2).getShortAlgorithm();
        JcaContentSignerBuilder signerBuilder = OCSP.newJcaContentSignerBuilder(digAlg + "with" + keyAlg);
        try {
            contentSigner = signerBuilder.build(signerKey.getPrivateKey());
        }
        catch (OperatorCreationException e) {
            throw OCSP.newOCSPError(runtime, (Exception)((Object)e));
        }
        try {
            if ((flag & RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_RESPID_KEY)))) != 0) {
                DigestCalculatorProvider dcp = OCSP.newJcaDigestCalculatorProviderBuilder().build();
                DigestCalculator calculator = dcp.get(contentSigner.getAlgorithmIdentifier());
                respBuilder = new BasicOCSPRespBuilder(SubjectPublicKeyInfo.getInstance((Object)signerKey.getPublicKey().getEncoded()), calculator);
            } else {
                respBuilder = new BasicOCSPRespBuilder(new RespID(signer.getSubject().getX500Name()));
            }
        }
        catch (Exception e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        X509CertificateHolder[] chain2 = null;
        try {
            if ((flag & RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOCERTS)))) == 0) {
                addlCerts.add(new X509CertificateHolder(signer.getAuxCert().getEncoded()));
                if (!additionalCerts.isNil()) {
                    for (Object cert2 : (RubyArray)additionalCerts) {
                        addlCerts.add(new X509CertificateHolder(((Certificate)cert2).getEncoded()));
                    }
                }
                chain2 = addlCerts.toArray(new X509CertificateHolder[addlCerts.size()]);
            }
        }
        catch (Exception e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        Date producedAt = null;
        if ((flag & RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOTIME)))) == 0) {
            producedAt = new Date();
        }
        for (OCSPSingleResponse resp : this.singleResponses) {
            SingleResp singleResp = new SingleResp(resp.getBCSingleResp());
            respBuilder.addResponse(singleResp.getCertID(), singleResp.getCertStatus(), singleResp.getThisUpdate(), singleResp.getNextUpdate(), resp.getBCSingleResp().getSingleExtensions());
        }
        try {
            Extension[] respExtAry = new Extension[this.extensions.size()];
            Extensions respExtensions = new Extensions(this.extensions.toArray(respExtAry));
            BasicOCSPResp bcBasicOCSPResp = respBuilder.setResponseExtensions(respExtensions).build(contentSigner, chain2, producedAt);
            this.asn1BCBasicOCSPResp = BasicOCSPResponse.getInstance((Object)bcBasicOCSPResp.getEncoded());
        }
        catch (Exception e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        return this;
    }

    @JRubyMethod(name={"verify"}, rest=true)
    public IRubyObject verify(ThreadContext context2, IRubyObject[] args) {
        Ruby runtime = context2.runtime;
        int flags = 0;
        IRubyObject certificates2 = args[0];
        IRubyObject store = args[1];
        boolean ret = false;
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)2, (int)3) == 3) {
            flags = RubyFixnum.fix2int((IRubyObject)args[2]);
        }
        JcaContentVerifierProviderBuilder jcacvpb = OCSP.newJcaContentVerifierProviderBuilder();
        BasicOCSPResp basicOCSPResp = this.getBasicOCSPResp();
        Certificate signer = this.findSignerCert(context2, this.asn1BCBasicOCSPResp, this.convertRubyCerts(certificates2), flags);
        if (signer == null) {
            return RubyBoolean.newBoolean((Ruby)runtime, (boolean)false);
        }
        if ((flags & RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOINTERN)))) == 0 && (flags & RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_TRUSTOTHER)))) != 0) {
            flags |= RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOVERIFY)));
        }
        if ((flags & RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOSIGS)))) == 0) {
            PublicKey sPKey = signer.getPublicKey();
            if (sPKey == null) {
                return RubyBoolean.newBoolean((Ruby)runtime, (boolean)false);
            }
            try {
                ContentVerifierProvider cvp = jcacvpb.build(sPKey);
                ret = basicOCSPResp.isSignatureValid(cvp);
            }
            catch (Exception e) {
                throw OCSP.newOCSPError(runtime, e);
            }
        }
        if ((flags & RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOVERIFY)))) == 0) {
            X509StoreContext ctx;
            List<X509Cert> untrustedCerts;
            if ((flags & RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOCHAIN)))) != 0) {
                untrustedCerts = Collections.EMPTY_LIST;
            } else if (basicOCSPResp.getCerts() != null && certificates2 != null && !((RubyArray)certificates2).isEmpty()) {
                untrustedCerts = this.getCertsFromResp(context2);
                Iterator certIt = ((RubyArray)certificates2).iterator();
                while (certIt.hasNext()) {
                    try {
                        untrustedCerts.add(X509Cert.wrap(context2, ((Certificate)certIt.next()).getEncoded()));
                    }
                    catch (CertificateEncodingException e) {
                        throw OCSP.newOCSPError(runtime, e);
                    }
                }
            } else {
                untrustedCerts = this.getCertsFromResp(context2);
            }
            RubyArray rUntrustedCerts = RubyArray.newArray((Ruby)runtime, (List)untrustedCerts);
            try {
                ctx = X509StoreContext.newStoreContext(context2, (X509Store)store, X509Cert.wrap(runtime, signer), (IRubyObject)rUntrustedCerts);
            }
            catch (CertificateEncodingException e) {
                throw OCSP.newOCSPError(runtime, e);
            }
            ctx.set_purpose(context2, X509._X509(runtime).getConstant("PURPOSE_OCSP_HELPER"));
            ret = ctx.verify(context2).isTrue();
            IRubyObject chain2 = ctx.chain(context2);
            if ((flags & RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOCHECKS)))) > 0) {
                ret = true;
            }
            try {
                if (this.checkIssuer(this.getBasicOCSPResp(), chain2)) {
                    return RubyBoolean.newBoolean((Ruby)runtime, (boolean)true);
                }
            }
            catch (IOException e) {
                throw OCSP.newOCSPError(runtime, e);
            }
            if ((flags & RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOCHAIN)))) != 0) {
                return RubyBoolean.newBoolean((Ruby)runtime, (boolean)ret);
            }
            X509Cert rootCA = (X509Cert)((RubyArray)chain2).last();
            PublicKey rootKey = rootCA.getAuxCert().getPublicKey();
            try {
                rootCA.getAuxCert().verify(rootKey);
                ret = true;
            }
            catch (Exception e) {
                ret = false;
            }
        }
        return RubyBoolean.newBoolean((Ruby)runtime, (boolean)ret);
    }

    @JRubyMethod(name={"status"})
    public IRubyObject status(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        RubyArray ret = RubyArray.newArray((Ruby)runtime, (int)this.singleResponses.size());
        for (OCSPSingleResponse resp : this.singleResponses) {
            RubyArray respAry = RubyArray.newArray((Ruby)runtime, (int)7);
            respAry.append(resp.certid(context2));
            respAry.append(resp.cert_status());
            respAry.append(resp.revocation_reason());
            respAry.append(resp.revocation_time());
            respAry.append(resp.this_update());
            respAry.append(resp.next_update());
            respAry.append(resp.extensions());
            ret.add((Object)respAry);
        }
        return ret;
    }

    @JRubyMethod(name={"to_der"})
    public IRubyObject to_der() {
        RubyString ret;
        Ruby runtime = this.getRuntime();
        try {
            ret = RubyString.newString((Ruby)runtime, (byte[])this.asn1BCBasicOCSPResp.getEncoded());
        }
        catch (IOException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        return ret;
    }

    private boolean checkIssuer(BasicOCSPResp basicOCSPResp, IRubyObject chain2) throws IOException {
        boolean ret = false;
        if (((RubyArray)chain2).size() <= 0) {
            return false;
        }
        List<SingleResp> singleResponses = Arrays.asList(basicOCSPResp.getResponses());
        CertificateID certId = this.checkCertIds(singleResponses);
        X509Cert signer = (X509Cert)((RubyArray)chain2).first();
        if (((RubyArray)chain2).size() > 1) {
            X509Cert signerCA = (X509Cert)((RubyArray)chain2).entry(1);
            if (this.matchIssuerId(signerCA, certId, singleResponses)) {
                return this.checkDelegated(signerCA);
            }
        } else {
            ret = this.matchIssuerId(signer, certId, singleResponses);
        }
        return ret;
    }

    private boolean checkDelegated(X509Cert signerCA) {
        try {
            return (signerCA.getAuxCert().getExFlags() & 4) != 0 && signerCA.getAuxCert().getExtendedKeyUsage().contains("1.3.6.1.5.5.7.3.9");
        }
        catch (CertificateParsingException e) {
            throw OCSP.newOCSPError(this.getRuntime(), e);
        }
        catch (IOException e) {
            throw OCSP.newOCSPError(this.getRuntime(), e);
        }
    }

    private boolean matchIssuerId(X509Cert signerCA, CertificateID certId, List<SingleResp> singleResponses) throws IOException {
        Ruby runtime = this.getRuntime();
        if (certId == null) {
            for (SingleResp resp : singleResponses) {
                CertificateID tempId = resp.getCertID();
                if (this.matchIssuerId(signerCA, tempId, null)) continue;
                return false;
            }
            return true;
        }
        ASN1ObjectIdentifier alg = certId.getHashAlgOID();
        String sym = ASN1.oid2Sym(runtime, alg);
        MessageDigest md = Digest.getDigest(runtime, sym);
        byte[] issuerNameDigest = md.digest(signerCA.getIssuer().getX500Name().getEncoded());
        byte[] issuerKeyDigest = md.digest(signerCA.getAuxCert().getPublicKey().getEncoded());
        if (!issuerNameDigest.equals(certId.getIssuerNameHash())) {
            return false;
        }
        return issuerKeyDigest.equals(certId.getIssuerKeyHash());
    }

    private CertificateID checkCertIds(List<SingleResp> singleResponses) {
        ArrayList<SingleResp> ary = new ArrayList<SingleResp>(singleResponses);
        CertificateID cid = ary.remove(0).getCertID();
        for (SingleResp singleResp : ary) {
            if (cid.equals((Object)singleResp.getCertID())) continue;
            return null;
        }
        return cid;
    }

    public BasicOCSPResponse getASN1BCOCSPResp() {
        return this.asn1BCBasicOCSPResp;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    private ASN1GeneralizedTime rubyIntOrTimeToGenTime(IRubyObject intOrTime) {
        Date retTime;
        if (intOrTime.isNil()) {
            return null;
        }
        if (intOrTime instanceof RubyInteger) {
            retTime = new Date(System.currentTimeMillis() + (long)(RubyFixnum.fix2int((IRubyObject)intOrTime) * 1000));
        } else if (intOrTime instanceof RubyTime) {
            retTime = ((RubyTime)intOrTime).getJavaDate();
        } else {
            throw this.getRuntime().newArgumentError("Unknown Revocation Time class: " + intOrTime.getMetaClass());
        }
        return new ASN1GeneralizedTime(retTime);
    }

    private Extensions convertRubyExtensions(IRubyObject extensions2) {
        if (extensions2.isNil()) {
            return null;
        }
        ArrayList<Extension> retExtensions = new ArrayList<Extension>();
        for (X509Extension rubyExt : (RubyArray)extensions2) {
            Extension ext2 = Extension.getInstance((Object)((RubyString)rubyExt.to_der()).getBytes());
            retExtensions.add(ext2);
        }
        Extension[] exts = new Extension[retExtensions.size()];
        retExtensions.toArray(exts);
        return new Extensions(exts);
    }

    private List<Certificate> convertRubyCerts(IRubyObject certificates2) {
        Iterator it = ((RubyArray)certificates2).iterator();
        ArrayList<Certificate> ret = new ArrayList<Certificate>();
        while (it.hasNext()) {
            ret.add((Certificate)it.next());
        }
        return ret;
    }

    private Certificate findSignerCert(ThreadContext context2, BasicOCSPResponse basicResp, List<Certificate> certificates2, int flags) {
        Ruby runtime = context2.runtime;
        ResponderID respID = basicResp.getTbsResponseData().getResponderID();
        Certificate ret = this.findSignerByRespId(context2, certificates2, respID);
        if (ret == null && (flags & RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOINTERN)))) == 0) {
            ArrayList<X509AuxCertificate> javaCerts = new ArrayList<X509AuxCertificate>();
            for (X509CertificateHolder cert2 : this.getBasicOCSPResp().getCerts()) {
                try {
                    javaCerts.add(X509Cert.wrap(context2, cert2.getEncoded()).getAuxCert());
                }
                catch (IOException e) {
                    throw OCSP.newOCSPError(runtime, e);
                }
            }
            ret = this.findSignerByRespId(context2, javaCerts, respID);
        }
        return ret;
    }

    private Certificate findSignerByRespId(ThreadContext context2, List<? extends Certificate> certificates2, ResponderID respID) {
        if (respID.getName() != null) {
            for (Certificate certificate : certificates2) {
                try {
                    X509Cert rubyCert = X509Cert.wrap(context2, certificate);
                    if (!rubyCert.getSubject().getX500Name().equals((Object)respID.getName())) continue;
                    return certificate;
                }
                catch (CertificateEncodingException e) {
                    throw OCSP.newOCSPError(context2.runtime, e);
                }
            }
        } else {
            if (respID.getKeyHash().length != 20) {
                return null;
            }
            for (Certificate certificate : certificates2) {
                byte[] pubKeyDigest = Digest.digest(context2, (IRubyObject)this, (IRubyObject)RubyString.newString((Ruby)context2.runtime, (String)"SHA1"), (IRubyObject)RubyString.newString((Ruby)context2.runtime, (byte[])certificate.getPublicKey().getEncoded())).getBytes();
                if (!respID.getKeyHash().equals(pubKeyDigest)) continue;
                return certificate;
            }
        }
        return null;
    }

    private List<X509Cert> getCertsFromResp(ThreadContext context2) {
        X509CertificateHolder[] certs = this.getBasicOCSPResp().getCerts();
        ArrayList<X509Cert> retCerts = new ArrayList<X509Cert>(certs.length);
        for (X509CertificateHolder cert2 : certs) {
            try {
                retCerts.add(X509Cert.wrap(context2, cert2.getEncoded()));
            }
            catch (IOException e) {
                throw OCSP.newOCSPError(context2.runtime, e);
            }
        }
        return retCerts;
    }

    private BasicOCSPResp getBasicOCSPResp() {
        return new BasicOCSPResp(this.asn1BCBasicOCSPResp);
    }
}

