"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var specs_1 = require("../../../../specs");
var constants_1 = require("../../../../specs/constants");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var tooltip_1 = require("./tooltip");
exports.isTooltipVisibleSelector = re_reselect_1.default([get_settings_specs_1.getSettingsSpecSelector, tooltip_1.getTooltipInfoSelector], function (settingsSpec, tooltipInfo) {
    if (specs_1.getTooltipType(settingsSpec) === constants_1.TooltipType.None) {
        return false;
    }
    return tooltipInfo.values.length > 0;
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=is_tooltip_visible.js.map