"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var group_by_rollup_1 = require("../utils/group_by_rollup");
function getHierarchyOfArrays(rawFacts, valueAccessor, groupByRollupAccessors) {
    var aggregator = group_by_rollup_1.aggregators.sum;
    var facts = rawFacts.filter(function (n) {
        var value = valueAccessor(n);
        return Number.isFinite(value) && value > 0;
    });
    if (facts.reduce(function (p, n) { return aggregator.reducer(p, valueAccessor(n)); }, aggregator.identity()) <= 0) {
        return [];
    }
    return group_by_rollup_1.mapsToArrays(group_by_rollup_1.groupByRollup(groupByRollupAccessors, valueAccessor, aggregator, facts), group_by_rollup_1.aggregateComparator(group_by_rollup_1.mapEntryValue, group_by_rollup_1.childOrders.descending));
}
exports.getHierarchyOfArrays = getHierarchyOfArrays;
//# sourceMappingURL=hierarchy_of_arrays.js.map