/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.LLVMOptRemarkStringRef;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOptRemarkDebugLoc
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SOURCEFILE;
    public static final int SOURCELINENUMBER;
    public static final int SOURCECOLUMNNUMBER;

    public LLVMOptRemarkDebugLoc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOptRemarkDebugLoc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public LLVMOptRemarkStringRef SourceFile() {
        return LLVMOptRemarkDebugLoc.nSourceFile(this.address());
    }

    @NativeType(value="uint32_t")
    public int SourceLineNumber() {
        return LLVMOptRemarkDebugLoc.nSourceLineNumber(this.address());
    }

    @NativeType(value="uint32_t")
    public int SourceColumnNumber() {
        return LLVMOptRemarkDebugLoc.nSourceColumnNumber(this.address());
    }

    public static LLVMOptRemarkDebugLoc create(long address) {
        return (LLVMOptRemarkDebugLoc)LLVMOptRemarkDebugLoc.wrap(LLVMOptRemarkDebugLoc.class, (long)address);
    }

    @Nullable
    public static LLVMOptRemarkDebugLoc createSafe(long address) {
        return address == 0L ? null : (LLVMOptRemarkDebugLoc)LLVMOptRemarkDebugLoc.wrap(LLVMOptRemarkDebugLoc.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LLVMOptRemarkDebugLoc.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LLVMOptRemarkDebugLoc.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static LLVMOptRemarkStringRef nSourceFile(long struct) {
        return LLVMOptRemarkStringRef.create(struct + (long)SOURCEFILE);
    }

    public static int nSourceLineNumber(long struct) {
        return UNSAFE.getInt(null, struct + (long)SOURCELINENUMBER);
    }

    public static int nSourceColumnNumber(long struct) {
        return UNSAFE.getInt(null, struct + (long)SOURCECOLUMNNUMBER);
    }

    static {
        Struct.Layout layout = LLVMOptRemarkDebugLoc.__struct((Struct.Member[])new Struct.Member[]{LLVMOptRemarkDebugLoc.__member((int)LLVMOptRemarkStringRef.SIZEOF, (int)LLVMOptRemarkStringRef.ALIGNOF), LLVMOptRemarkDebugLoc.__member((int)4), LLVMOptRemarkDebugLoc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SOURCEFILE = layout.offsetof(0);
        SOURCELINENUMBER = layout.offsetof(1);
        SOURCECOLUMNNUMBER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<LLVMOptRemarkDebugLoc, Buffer> {
        private static final LLVMOptRemarkDebugLoc ELEMENT_FACTORY = LLVMOptRemarkDebugLoc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LLVMOptRemarkDebugLoc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public LLVMOptRemarkStringRef SourceFile() {
            return LLVMOptRemarkDebugLoc.nSourceFile(this.address());
        }

        @NativeType(value="uint32_t")
        public int SourceLineNumber() {
            return LLVMOptRemarkDebugLoc.nSourceLineNumber(this.address());
        }

        @NativeType(value="uint32_t")
        public int SourceColumnNumber() {
            return LLVMOptRemarkDebugLoc.nSourceColumnNumber(this.address());
        }
    }
}

