/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceGroupSubmitInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int WAITSEMAPHORECOUNT;
    public static final int PWAITSEMAPHOREDEVICEINDICES;
    public static final int COMMANDBUFFERCOUNT;
    public static final int PCOMMANDBUFFERDEVICEMASKS;
    public static final int SIGNALSEMAPHORECOUNT;
    public static final int PSIGNALSEMAPHOREDEVICEINDICES;

    public VkDeviceGroupSubmitInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceGroupSubmitInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceGroupSubmitInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceGroupSubmitInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int waitSemaphoreCount() {
        return VkDeviceGroupSubmitInfo.nwaitSemaphoreCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pWaitSemaphoreDeviceIndices() {
        return VkDeviceGroupSubmitInfo.npWaitSemaphoreDeviceIndices(this.address());
    }

    @NativeType(value="uint32_t")
    public int commandBufferCount() {
        return VkDeviceGroupSubmitInfo.ncommandBufferCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pCommandBufferDeviceMasks() {
        return VkDeviceGroupSubmitInfo.npCommandBufferDeviceMasks(this.address());
    }

    @NativeType(value="uint32_t")
    public int signalSemaphoreCount() {
        return VkDeviceGroupSubmitInfo.nsignalSemaphoreCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pSignalSemaphoreDeviceIndices() {
        return VkDeviceGroupSubmitInfo.npSignalSemaphoreDeviceIndices(this.address());
    }

    public VkDeviceGroupSubmitInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupSubmitInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceGroupSubmitInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupSubmitInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceGroupSubmitInfo pWaitSemaphoreDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkDeviceGroupSubmitInfo.npWaitSemaphoreDeviceIndices(this.address(), value);
        return this;
    }

    public VkDeviceGroupSubmitInfo pCommandBufferDeviceMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkDeviceGroupSubmitInfo.npCommandBufferDeviceMasks(this.address(), value);
        return this;
    }

    public VkDeviceGroupSubmitInfo pSignalSemaphoreDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkDeviceGroupSubmitInfo.npSignalSemaphoreDeviceIndices(this.address(), value);
        return this;
    }

    public VkDeviceGroupSubmitInfo set(int sType, long pNext, @Nullable IntBuffer pWaitSemaphoreDeviceIndices, @Nullable IntBuffer pCommandBufferDeviceMasks, @Nullable IntBuffer pSignalSemaphoreDeviceIndices) {
        this.sType(sType);
        this.pNext(pNext);
        this.pWaitSemaphoreDeviceIndices(pWaitSemaphoreDeviceIndices);
        this.pCommandBufferDeviceMasks(pCommandBufferDeviceMasks);
        this.pSignalSemaphoreDeviceIndices(pSignalSemaphoreDeviceIndices);
        return this;
    }

    public VkDeviceGroupSubmitInfo set(VkDeviceGroupSubmitInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceGroupSubmitInfo malloc() {
        return (VkDeviceGroupSubmitInfo)VkDeviceGroupSubmitInfo.wrap(VkDeviceGroupSubmitInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDeviceGroupSubmitInfo calloc() {
        return (VkDeviceGroupSubmitInfo)VkDeviceGroupSubmitInfo.wrap(VkDeviceGroupSubmitInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDeviceGroupSubmitInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDeviceGroupSubmitInfo)VkDeviceGroupSubmitInfo.wrap(VkDeviceGroupSubmitInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDeviceGroupSubmitInfo create(long address) {
        return (VkDeviceGroupSubmitInfo)VkDeviceGroupSubmitInfo.wrap(VkDeviceGroupSubmitInfo.class, (long)address);
    }

    @Nullable
    public static VkDeviceGroupSubmitInfo createSafe(long address) {
        return address == 0L ? null : (VkDeviceGroupSubmitInfo)VkDeviceGroupSubmitInfo.wrap(VkDeviceGroupSubmitInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDeviceGroupSubmitInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDeviceGroupSubmitInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDeviceGroupSubmitInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceGroupSubmitInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDeviceGroupSubmitInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDeviceGroupSubmitInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDeviceGroupSubmitInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDeviceGroupSubmitInfo mallocStack() {
        return VkDeviceGroupSubmitInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupSubmitInfo callocStack() {
        return VkDeviceGroupSubmitInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupSubmitInfo mallocStack(MemoryStack stack) {
        return (VkDeviceGroupSubmitInfo)VkDeviceGroupSubmitInfo.wrap(VkDeviceGroupSubmitInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupSubmitInfo callocStack(MemoryStack stack) {
        return (VkDeviceGroupSubmitInfo)VkDeviceGroupSubmitInfo.wrap(VkDeviceGroupSubmitInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupSubmitInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupSubmitInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceGroupSubmitInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceGroupSubmitInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nwaitSemaphoreCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)WAITSEMAPHORECOUNT);
    }

    @Nullable
    public static IntBuffer npWaitSemaphoreDeviceIndices(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PWAITSEMAPHOREDEVICEINDICES)), (int)VkDeviceGroupSubmitInfo.nwaitSemaphoreCount(struct));
    }

    public static int ncommandBufferCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMMANDBUFFERCOUNT);
    }

    @Nullable
    public static IntBuffer npCommandBufferDeviceMasks(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PCOMMANDBUFFERDEVICEMASKS)), (int)VkDeviceGroupSubmitInfo.ncommandBufferCount(struct));
    }

    public static int nsignalSemaphoreCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIGNALSEMAPHORECOUNT);
    }

    @Nullable
    public static IntBuffer npSignalSemaphoreDeviceIndices(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PSIGNALSEMAPHOREDEVICEINDICES)), (int)VkDeviceGroupSubmitInfo.nsignalSemaphoreCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nwaitSemaphoreCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WAITSEMAPHORECOUNT, value);
    }

    public static void npWaitSemaphoreDeviceIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PWAITSEMAPHOREDEVICEINDICES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkDeviceGroupSubmitInfo.nwaitSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncommandBufferCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMMANDBUFFERCOUNT, value);
    }

    public static void npCommandBufferDeviceMasks(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCOMMANDBUFFERDEVICEMASKS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkDeviceGroupSubmitInfo.ncommandBufferCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsignalSemaphoreCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIGNALSEMAPHORECOUNT, value);
    }

    public static void npSignalSemaphoreDeviceIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSIGNALSEMAPHOREDEVICEINDICES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkDeviceGroupSubmitInfo.nsignalSemaphoreCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDeviceGroupSubmitInfo.nwaitSemaphoreCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PWAITSEMAPHOREDEVICEINDICES)));
        }
        if (VkDeviceGroupSubmitInfo.ncommandBufferCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCOMMANDBUFFERDEVICEMASKS)));
        }
        if (VkDeviceGroupSubmitInfo.nsignalSemaphoreCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSIGNALSEMAPHOREDEVICEINDICES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkDeviceGroupSubmitInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkDeviceGroupSubmitInfo.__struct((Struct.Member[])new Struct.Member[]{VkDeviceGroupSubmitInfo.__member((int)4), VkDeviceGroupSubmitInfo.__member((int)POINTER_SIZE), VkDeviceGroupSubmitInfo.__member((int)4), VkDeviceGroupSubmitInfo.__member((int)POINTER_SIZE), VkDeviceGroupSubmitInfo.__member((int)4), VkDeviceGroupSubmitInfo.__member((int)POINTER_SIZE), VkDeviceGroupSubmitInfo.__member((int)4), VkDeviceGroupSubmitInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        WAITSEMAPHORECOUNT = layout.offsetof(2);
        PWAITSEMAPHOREDEVICEINDICES = layout.offsetof(3);
        COMMANDBUFFERCOUNT = layout.offsetof(4);
        PCOMMANDBUFFERDEVICEMASKS = layout.offsetof(5);
        SIGNALSEMAPHORECOUNT = layout.offsetof(6);
        PSIGNALSEMAPHOREDEVICEINDICES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceGroupSubmitInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceGroupSubmitInfo ELEMENT_FACTORY = VkDeviceGroupSubmitInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDeviceGroupSubmitInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceGroupSubmitInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceGroupSubmitInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int waitSemaphoreCount() {
            return VkDeviceGroupSubmitInfo.nwaitSemaphoreCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pWaitSemaphoreDeviceIndices() {
            return VkDeviceGroupSubmitInfo.npWaitSemaphoreDeviceIndices(this.address());
        }

        @NativeType(value="uint32_t")
        public int commandBufferCount() {
            return VkDeviceGroupSubmitInfo.ncommandBufferCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pCommandBufferDeviceMasks() {
            return VkDeviceGroupSubmitInfo.npCommandBufferDeviceMasks(this.address());
        }

        @NativeType(value="uint32_t")
        public int signalSemaphoreCount() {
            return VkDeviceGroupSubmitInfo.nsignalSemaphoreCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pSignalSemaphoreDeviceIndices() {
            return VkDeviceGroupSubmitInfo.npSignalSemaphoreDeviceIndices(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupSubmitInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupSubmitInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pWaitSemaphoreDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkDeviceGroupSubmitInfo.npWaitSemaphoreDeviceIndices(this.address(), value);
            return this;
        }

        public Buffer pCommandBufferDeviceMasks(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkDeviceGroupSubmitInfo.npCommandBufferDeviceMasks(this.address(), value);
            return this;
        }

        public Buffer pSignalSemaphoreDeviceIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkDeviceGroupSubmitInfo.npSignalSemaphoreDeviceIndices(this.address(), value);
            return this;
        }
    }
}

