/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 | abs(~ ivec4(-64, 72, 88, -76))) => ivec4(63, 77, 93, 79)
 * (12 | abs(~ ivec4(64, 72, 88, 76))) => ivec4(77, 77, 93, 77)
 * (12 | abs(~ ivec4(-24, 40, -23, 64))) => ivec4(31, 45, 30, 77)
 * (12 | abs(~ ivec4(24, 40, 23, 64))) => ivec4(29, 45, 28, 77)
 * (-6 | abs(~ ivec4(-64, 72, 88, -76))) => ivec4(-1, -5, -5, -5)
 * (-6 | abs(~ ivec4(64, 72, 88, 76))) => ivec4(-5, -5, -5, -1)
 * (-6 | abs(~ ivec4(-24, 40, -23, 64))) => ivec4(-1, -5, -2, -5)
 * (-6 | abs(~ ivec4(24, 40, 23, 64))) => ivec4(-5, -5, -6, -5)
 * (76 | abs(~ ivec4(-64, 72, 88, -76))) => ivec4(127, 77, 93, 79)
 * (76 | abs(~ ivec4(64, 72, 88, 76))) => ivec4(77, 77, 93, 77)
 * (76 | abs(~ ivec4(-24, 40, -23, 64))) => ivec4(95, 109, 94, 77)
 * (76 | abs(~ ivec4(24, 40, 23, 64))) => ivec4(93, 109, 92, 77)
 * (-32 | abs(~ ivec4(-64, 72, 88, -76))) => ivec4(-1, -23, -7, -21)
 * (-32 | abs(~ ivec4(64, 72, 88, 76))) => ivec4(-31, -23, -7, -19)
 * (-32 | abs(~ ivec4(-24, 40, -23, 64))) => ivec4(-9, -23, -10, -31)
 * (-32 | abs(~ ivec4(24, 40, 23, 64))) => ivec4(-7, -23, -8, -31)
 * (0 | abs(~ ivec4(-64, 72, 88, -76))) => ivec4(63, 73, 89, 75)
 * (0 | abs(~ ivec4(64, 72, 88, 76))) => ivec4(65, 73, 89, 77)
 * (0 | abs(~ ivec4(-24, 40, -23, 64))) => ivec4(23, 41, 22, 65)
 * (0 | abs(~ ivec4(24, 40, 23, 64))) => ivec4(25, 41, 24, 65)
 */
#version 130

void main()
{
  float[all(equal((12 | abs(~ ivec4(-64, 72, 88, -76))), ivec4(63, 77, 93, 79))) ? 1 : -1] array0;
  float[all(equal((12 | abs(~ ivec4(64, 72, 88, 76))), ivec4(77, 77, 93, 77))) ? 1 : -1] array1;
  float[all(equal((12 | abs(~ ivec4(-24, 40, -23, 64))), ivec4(31, 45, 30, 77))) ? 1 : -1] array2;
  float[all(equal((12 | abs(~ ivec4(24, 40, 23, 64))), ivec4(29, 45, 28, 77))) ? 1 : -1] array3;
  float[all(equal((-6 | abs(~ ivec4(-64, 72, 88, -76))), ivec4(-1, -5, -5, -5))) ? 1 : -1] array4;
  float[all(equal((-6 | abs(~ ivec4(64, 72, 88, 76))), ivec4(-5, -5, -5, -1))) ? 1 : -1] array5;
  float[all(equal((-6 | abs(~ ivec4(-24, 40, -23, 64))), ivec4(-1, -5, -2, -5))) ? 1 : -1] array6;
  float[all(equal((-6 | abs(~ ivec4(24, 40, 23, 64))), ivec4(-5, -5, -6, -5))) ? 1 : -1] array7;
  float[all(equal((76 | abs(~ ivec4(-64, 72, 88, -76))), ivec4(127, 77, 93, 79))) ? 1 : -1] array8;
  float[all(equal((76 | abs(~ ivec4(64, 72, 88, 76))), ivec4(77, 77, 93, 77))) ? 1 : -1] array9;
  float[all(equal((76 | abs(~ ivec4(-24, 40, -23, 64))), ivec4(95, 109, 94, 77))) ? 1 : -1] array10;
  float[all(equal((76 | abs(~ ivec4(24, 40, 23, 64))), ivec4(93, 109, 92, 77))) ? 1 : -1] array11;
  float[all(equal((-32 | abs(~ ivec4(-64, 72, 88, -76))), ivec4(-1, -23, -7, -21))) ? 1 : -1] array12;
  float[all(equal((-32 | abs(~ ivec4(64, 72, 88, 76))), ivec4(-31, -23, -7, -19))) ? 1 : -1] array13;
  float[all(equal((-32 | abs(~ ivec4(-24, 40, -23, 64))), ivec4(-9, -23, -10, -31))) ? 1 : -1] array14;
  float[all(equal((-32 | abs(~ ivec4(24, 40, 23, 64))), ivec4(-7, -23, -8, -31))) ? 1 : -1] array15;
  float[all(equal((0 | abs(~ ivec4(-64, 72, 88, -76))), ivec4(63, 73, 89, 75))) ? 1 : -1] array16;
  float[all(equal((0 | abs(~ ivec4(64, 72, 88, 76))), ivec4(65, 73, 89, 77))) ? 1 : -1] array17;
  float[all(equal((0 | abs(~ ivec4(-24, 40, -23, 64))), ivec4(23, 41, 22, 65))) ? 1 : -1] array18;
  float[all(equal((0 | abs(~ ivec4(24, 40, 23, 64))), ivec4(25, 41, 24, 65))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
