/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * inversesqrt(0.1lf) => 3.162277660168379lf
 * inversesqrt(0.7333333333333333lf) => 1.1677484162422846lf
 * inversesqrt(1.3666666666666667lf) => 0.8553989227683015lf
 * inversesqrt(2.0lf) => 0.7071067811865475lf
 */
#version 400

void main()
{
  double[distance(inversesqrt(0.1lf), 3.162277660168379lf) <= 3.1622776601683795e-05lf ? 1 : -1] array0;
  double[distance(inversesqrt(0.7333333333333333lf), 1.1677484162422846lf) <= 1.1677484162422848e-05lf ? 1 : -1] array1;
  double[distance(inversesqrt(1.3666666666666667lf), 0.8553989227683015lf) <= 8.553989227683017e-06lf ? 1 : -1] array2;
  double[distance(inversesqrt(2.0lf), 0.7071067811865475lf) <= 7.0710678118654756e-06lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
