/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.swing.TreeNodeData;
import ca.odell.glazedlists.swing.TreeTableCellPanel;
import ca.odell.glazedlists.swing.TreeTableNodeDataEditor;
import ca.odell.glazedlists.swing.TreeTableUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class TreeTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final TreeTableCellPanel component = new TreeTableCellPanel();
    private TreeList treeList;
    private TableCellEditor delegate;
    private boolean showExpanderForEmptyParent;
    private final CellEditorListener delegateListener = new DelegateTableCellEditorListener();
    private final TreeNodeData treeNodeData = new TreeNodeData();

    public TreeTableCellEditor(TableCellEditor delegate, TreeList treeList) {
        this.delegate = delegate == null ? this.createDelegateEditor() : delegate;
        this.delegate.addCellEditorListener(this.delegateListener);
        this.treeList = treeList;
    }

    protected TableCellEditor createDelegateEditor() {
        JTextField textField = new JTextField();
        textField.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        return new DefaultCellEditor(textField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.treeList.getReadWriteLock().readLock().lock();
        try {
            this.treeNodeData.setDepth(this.treeList.depth(row));
            this.treeNodeData.setExpanded(this.treeList.isExpanded(row));
            this.treeNodeData.setHasChildren(this.treeList.hasChildren(row));
            this.treeNodeData.setAllowsChildren(this.treeList.getAllowsChildren(row));
        }
        finally {
            this.treeList.getReadWriteLock().readLock().unlock();
        }
        if (this.delegate instanceof TreeTableNodeDataEditor) {
            ((TreeTableNodeDataEditor)this.delegate).setTreeNodeData(this.treeNodeData);
        }
        Component c = this.delegate.getTableCellEditorComponent(table, value, isSelected, row, column);
        int indent = this.getIndent(this.treeNodeData, this.showExpanderForEmptyParent);
        int spacer = this.getSpacer(this.treeNodeData, this.showExpanderForEmptyParent);
        this.component.configure(this.treeNodeData, this.showExpanderForEmptyParent, c, false, indent, spacer);
        return this.component;
    }

    protected int getIndent(TreeNodeData treeNodeData, boolean showExpanderForEmptyParent) {
        return UIManager.getIcon("Tree.expandedIcon").getIconWidth() * treeNodeData.getDepth();
    }

    protected int getSpacer(TreeNodeData treeNodeData, boolean showExpanderForEmptyParent) {
        return 2;
    }

    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)event;
            JTable table = (JTable)me.getSource();
            Point clickPoint = me.getPoint();
            int row = table.rowAtPoint(clickPoint);
            int column = table.columnAtPoint(clickPoint);
            Rectangle cellRect = table.getCellRect(row, column, true);
            clickPoint.translate(-cellRect.x, -cellRect.y);
            TreeTableCellPanel renderedPanel = TreeTableUtilities.prepareRenderer(me);
            if (renderedPanel != null && renderedPanel.isPointOverNodeComponent(clickPoint)) {
                Rectangle delegateRendererBounds = renderedPanel.getNodeComponent().getBounds();
                MouseEvent translatedMouseEvent = new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX() - delegateRendererBounds.x, me.getY() - delegateRendererBounds.y, me.getClickCount(), me.isPopupTrigger(), me.getButton());
                return this.delegate.isCellEditable(translatedMouseEvent);
            }
            return false;
        }
        return super.isCellEditable(event);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return this.delegate.shouldSelectCell(anEvent);
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    void setShowExpanderForEmptyParent(boolean b) {
        this.showExpanderForEmptyParent = b;
    }

    void setDelegate(TableCellEditor delegate) {
        this.delegate = delegate;
    }

    public TableCellEditor getDelegate() {
        return this.delegate;
    }

    public void dispose() {
        this.delegate.removeCellEditorListener(this.delegateListener);
        this.delegate = null;
        this.treeList = null;
    }

    private class DelegateTableCellEditorListener
    implements CellEditorListener {
        private DelegateTableCellEditorListener() {
        }

        public void editingCanceled(ChangeEvent e) {
            TreeTableCellEditor.this.cancelCellEditing();
        }

        public void editingStopped(ChangeEvent e) {
            TreeTableCellEditor.this.stopCellEditing();
        }
    }
}

