/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.awt.Frame;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tr.data.FileFilterImpl;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.IDGenerator;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.context.Context;
import tr.model.criteria.Criterion;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.project.Sequencing;
import tr.model.topic.Topic;
import tr.view.projects.ExportTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportTemplate {
    private static final Logger LOG = Logger.getLogger("tr.view.projects.ImportTemplate");
    private static final String EXTN = "trpt";
    private static final String EXTN_NAME = NbBundle.getMessage(ExportTemplate.class, (String)"template.file.extension.name");
    private Map<String, Value> mapTime;
    private Map<String, Value> mapEnergy;
    private Map<String, Value> mapPriority;

    public void process() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            LOG.severe("Data was not available.");
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(ExportTemplate.class, (String)"import.template.title"));
        chooser.setFileSelectionMode(0);
        FileFilterImpl filter = new FileFilterImpl(EXTN_NAME, new String[]{EXTN}, true);
        chooser.setFileFilter((FileFilter)filter);
        Frame p = WindowManager.getDefault().getMainWindow();
        int returnVal = chooser.showDialog(p, NbBundle.getMessage(ExportTemplate.class, (String)"import.template.button"));
        if (returnVal != 0) {
            return;
        }
        String path = chooser.getSelectedFile().getPath();
        File file = new File(path);
        if (!file.isFile() || !file.canRead()) {
            String t = NbBundle.getMessage(ImportTemplate.class, (String)"import.template.title");
            String m = NbBundle.getMessage(ImportTemplate.class, (String)"import.template.read.error");
            JOptionPane.showMessageDialog(p, m, t, 0);
            return;
        }
        this.mapTime = this.initialiseMap(data.getTimeCriterion());
        this.mapEnergy = this.initialiseMap(data.getEnergyCriterion());
        this.mapPriority = this.initialiseMap(data.getPriorityCriterion());
        Document dom = this.parse(file);
        if (dom == null) {
            String t = NbBundle.getMessage(ImportTemplate.class, (String)"import.template.title");
            String m = NbBundle.getMessage(ImportTemplate.class, (String)"import.template.parse.error");
            JOptionPane.showMessageDialog(p, m, t, 0);
            return;
        }
        this.process(dom, data);
    }

    private Map<String, Value> initialiseMap(Criterion criterion) {
        HashMap<String, Value> map = new HashMap<String, Value>();
        for (Value value : criterion.values.list()) {
            map.put(value.getName(), value);
        }
        return map;
    }

    private Document parse(File file) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(file);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void process(Document dom, Data data) {
        Element templateElement = dom.getDocumentElement();
        if (templateElement == null) {
            LOG.severe("Element root \"template\" was not found.");
            return;
        }
        Element projectElement = this.getChildElementByName(templateElement, "project");
        if (projectElement == null) {
            LOG.severe("Element top level \"project\" was not found.");
            return;
        }
        Project root = this.processProjectElement(projectElement, data);
        if (root == null) {
            return;
        }
        data.getRootTemplates().add((Item)root);
    }

    private Project processProjectElement(Element projectElement, Data data) {
        Value value;
        String topicName;
        Topic topic;
        Project project = new Project((IDGenerator)data);
        Element element = this.getChildElementByName(projectElement, "descr");
        if (element != null) {
            project.setDescription(element.getTextContent());
        }
        if ((element = this.getChildElementByName(projectElement, "topic")) != null && (topic = this.getTopic(data, topicName = element.getTextContent())) != null) {
            project.setTopic(topic);
        }
        if ((element = this.getChildElementByName(projectElement, "purpose")) != null) {
            project.setPurpose(element.getTextContent());
        }
        if ((element = this.getChildElementByName(projectElement, "success")) != null) {
            project.setVision(element.getTextContent());
        }
        if ((element = this.getChildElementByName(projectElement, "brainstorming")) != null) {
            project.setBrainstorming(element.getTextContent());
        }
        if ((element = this.getChildElementByName(projectElement, "organising")) != null) {
            project.setOrganising(element.getTextContent());
        }
        if ((element = this.getChildElementByName(projectElement, "notes")) != null) {
            project.setNotes(element.getTextContent());
        }
        if ((element = this.getChildElementByName(projectElement, "sequence")) != null) {
            project.setSequencing(Boolean.parseBoolean(element.getTextContent()));
        }
        if (project.isSequencing() && (element = this.getChildElementByName(projectElement, "sequence-into")) != null) {
            if (Boolean.parseBoolean(element.getTextContent())) {
                project.setSequenceType(Sequencing.INTO_SUBPROJECTS);
            } else {
                project.setSequenceType(Sequencing.OVER_SUBPROJECTS);
            }
        }
        if ((element = this.getChildElementByName(projectElement, "priority")) != null && (value = this.mapPriority.get(element.getTextContent())) != null) {
            project.setPriority(value);
        }
        for (Element childElement : this.getChildElementsByName(projectElement, "child")) {
            Project subproject;
            String type = childElement.getAttribute("type");
            if (type.equals("action")) {
                Action action = this.processActionElement(childElement, data);
                if (action == null) continue;
                project.add((Item)action);
                continue;
            }
            if (!type.equals("project") || (subproject = this.processProjectElement(childElement, data)) == null) continue;
            project.add((Item)subproject);
        }
        return project;
    }

    private Action processActionElement(Element elemAction, Data data) {
        Value value;
        String contextName;
        Context context;
        String topicName;
        Topic topic;
        Action action = new Action((IDGenerator)data);
        Element element = this.getChildElementByName(elemAction, "descr");
        if (element != null) {
            action.setDescription(element.getTextContent());
        }
        if ((element = this.getChildElementByName(elemAction, "topic")) != null && (topic = this.getTopic(data, topicName = element.getTextContent())) != null) {
            action.setTopic(topic);
        }
        if ((element = this.getChildElementByName(elemAction, "context")) != null && (context = this.getContext(data, contextName = element.getTextContent())) != null) {
            action.setContext(context);
        }
        if ((element = this.getChildElementByName(elemAction, "success")) != null) {
            action.setSuccess(element.getTextContent());
        }
        if ((element = this.getChildElementByName(elemAction, "notes")) != null) {
            action.setNotes(element.getTextContent());
        }
        if ((element = this.getChildElementByName(elemAction, "time")) != null && (value = this.mapTime.get(element.getTextContent())) != null) {
            action.setTime(value);
        }
        if ((element = this.getChildElementByName(elemAction, "energy")) != null && (value = this.mapEnergy.get(element.getTextContent())) != null) {
            action.setEnergy(value);
        }
        if ((element = this.getChildElementByName(elemAction, "priority")) != null && (value = this.mapPriority.get(element.getTextContent())) != null) {
            action.setPriority(value);
        }
        if ((element = this.getChildElementByName(elemAction, "state")) != null) {
            ActionStateDelegated state;
            String type = element.getAttribute("type");
            if (type.equals("DELEGATED")) {
                state = new ActionStateDelegated();
                element = this.getChildElementByName(elemAction, "delegate");
                if (element != null) {
                    state.setTo(element.getTextContent());
                }
                action.setState((ActionState)state);
            } else if (type.equals("SCHEDULED")) {
                state = new ActionStateScheduled();
                action.setState((ActionState)state);
            } else if (type.equals("DOASAP")) {
                state = new ActionStateASAP();
                action.setState((ActionState)state);
            } else if (type.equals("INACTIVE")) {
                state = new ActionStateInactive();
                action.setState((ActionState)state);
            }
        }
        return action;
    }

    private Element getChildElementByName(Element element, String name) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                if (!(nodeList.item(i) instanceof Element) || !(childElement = (Element)nodeList.item(i)).getTagName().equals(name)) continue;
                return childElement;
            }
        }
        return null;
    }

    private List<Element> getChildElementsByName(Element element, String name) {
        Vector<Element> childElements = new Vector<Element>();
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                if (!(nodeList.item(i) instanceof Element) || !(childElement = (Element)nodeList.item(i)).getTagName().equals(name)) continue;
                childElements.add(childElement);
            }
        }
        return childElements;
    }

    private Topic getTopic(Data data, String topicName) {
        for (Topic topic : data.getTopicManager().list()) {
            if (!topic.getName().equals(topicName)) continue;
            return topic;
        }
        return null;
    }

    private Context getContext(Data data, String contextName) {
        for (Context context : data.getContextManager().list()) {
            if (!context.getName().equals(contextName)) continue;
            return context;
        }
        return null;
    }
}

