/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.calendar.ical4j.impl;

import au.com.trgtd.tr.appl.Constants;
import au.com.trgtd.tr.calendar.ical4j.ICal4JWrapper;
import au.com.trgtd.tr.calendar.ical4j.impl.prefs.Options;
import au.com.trgtd.tr.calendar.ical4j.impl.prefs.OptionsPanel;
import au.com.trgtd.tr.calendar.prefs.CalendarPrefs;
import au.com.trgtd.tr.calendar.spi.CalendarSynchronizer;
import au.com.trgtd.tr.calendar.spi.CalendarSynchronizerOptions;
import java.io.File;
import java.util.Date;
import org.openide.util.NbBundle;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.project.Project;
import tr.model.thought.Thought;
import tr.util.DateUtils;

public class ICalendarSynchronizer
implements CalendarSynchronizer {
    private static final String UID_SUFFIX = "@trgtd.com.au";
    private static final String DELEGATED_TO = NbBundle.getMessage(ICalendarSynchronizer.class, (String)"Delegated_to");
    private static ICal4JWrapper ical;
    private static File outfile;
    private static CalendarSynchronizerOptions options;

    public String getID() {
        return "au.com.trgtd.tr.calendar.synchronizer.default";
    }

    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"synchronizer.name");
    }

    public void syncToCalendar() {
        this.syncToCalendar(null);
    }

    public void syncToCalendar(String filename) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        String path = Options.getICalendarPath();
        File file = new File(path);
        if (file.isFile()) {
            path = file.getPath();
        } else if (file.isDirectory()) {
            if (filename == null) {
                filename = "ThinkingRock.ics";
            }
            path = path.endsWith(File.separator) ? path + filename : path + File.separator + filename;
        }
        ICalendarSynchronizer.process(data, path, Options.getTimeZoneID());
    }

    public void syncFromCalendar() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CalendarSynchronizerOptions getOptions() {
        if (options == null) {
            options = new OptionsPanel();
        }
        return options;
    }

    private static void process(Data data, String path, String tzid) {
        ical = new ICal4JWrapper(tzid);
        try {
            System.out.print("Generating ICalendar file ... ");
            ICalendarSynchronizer.initialise(path);
            ICalendarSynchronizer.process(data);
            ICalendarSynchronizer.finalise();
            System.out.println("done");
        }
        catch (Exception ex) {
            System.out.println();
            ex.printStackTrace(System.err);
        }
    }

    private static void initialise(String filename) throws Exception {
        outfile = new File(filename);
    }

    private static void finalise() throws Exception {
        ical.write(outfile);
    }

    private static void process(Data data) {
        for (Project project : data.getRootProjects().getChildren(Project.class)) {
            ICalendarSynchronizer.process(project);
        }
        for (Action action : data.getRootActions().getChildren(Action.class)) {
            ICalendarSynchronizer.process(action);
        }
    }

    private static void process(Project project) {
        for (Item child : project.getChildren()) {
            if (child instanceof Action) {
                ICalendarSynchronizer.process((Action)child);
                continue;
            }
            if (!(child instanceof Project)) continue;
            ICalendarSynchronizer.process((Project)child);
        }
    }

    private static void process(Action action) {
        if (action.isDone()) {
            return;
        }
        switch (action.getState().getType()) {
            case INACTIVE: {
                ICalendarSynchronizer.processInactive(action);
                break;
            }
            case DOASAP: {
                ICalendarSynchronizer.processDoASAP(action);
                break;
            }
            case DELEGATED: {
                ICalendarSynchronizer.processDelegated(action);
                break;
            }
            case SCHEDULED: {
                ICalendarSynchronizer.processScheduled(action);
            }
        }
    }

    private static void processInactive(Action action) {
        if (!CalendarPrefs.isSyncInactive()) {
            return;
        }
        Date actionDate = DateUtils.clearTime((Date)action.getActionDate());
        if (actionDate == null) {
            return;
        }
        String uid = ICalendarSynchronizer.getUID(action.getID());
        String descr = action.getDescription();
        String context = ICalendarSynchronizer.getContext(action);
        Integer priority = ICalendarSynchronizer.getPriority(action);
        Date startDate = DateUtils.clearTime((Date)action.getStartDate());
        Date dueDate = DateUtils.clearTime((Date)action.getDueDate());
        if (CalendarPrefs.isInactiveAsTodo()) {
            ical.createToDo(uid, startDate, dueDate, descr, ICalendarSynchronizer.getNotes(action), context, priority);
        } else {
            StringBuffer sb = new StringBuffer();
            if (startDate != null) {
                sb.append("Start: " + Constants.DATE_FORMAT_FIXED.format(startDate) + "\r\n");
            }
            if (dueDate != null) {
                sb.append("Due: " + Constants.DATE_FORMAT_FIXED.format(dueDate) + "\r\n");
            }
            String notes = sb.toString() + ICalendarSynchronizer.getNotes(action);
            ical.createAllDayEvent(uid, actionDate, descr, notes, context, priority);
        }
    }

    private static void processDoASAP(Action action) {
        String uid = ICalendarSynchronizer.getUID(action.getID());
        String descr = action.getDescription();
        String context = ICalendarSynchronizer.getContext(action);
        Integer priority = ICalendarSynchronizer.getPriority(action);
        String notes = ICalendarSynchronizer.getNotes(action);
        Date start = DateUtils.clearTime((Date)action.getStartDate());
        Date due = DateUtils.clearTime((Date)action.getDueDate());
        if (due == null) {
            if (CalendarPrefs.isSyncDoasapNoDueDate()) {
                ical.createToDo(uid, start, due, descr, notes, context, priority);
            }
        } else if (CalendarPrefs.isSyncDoasapDueDate()) {
            if (CalendarPrefs.isDoasapDueAsTodo()) {
                ical.createToDo(uid, start, due, descr, notes, context, priority);
            } else {
                ical.createAllDayEvent(uid, due, descr, notes, context, priority);
            }
        }
    }

    private static void processDelegated(Action action) {
        Date actionDate = action.getActionDate();
        if (actionDate == null) {
            if (!CalendarPrefs.isSyncDelegatedNoDate()) {
                return;
            }
            ActionStateDelegated state = (ActionStateDelegated)action.getState();
            String uid = ICalendarSynchronizer.getUID(action.getID());
            String descr = action.getDescription() + "  " + DELEGATED_TO + ": " + state.getTo();
            String context = ICalendarSynchronizer.getContext(action);
            Integer priority = ICalendarSynchronizer.getPriority(action);
            String notes = ICalendarSynchronizer.getNotes(action);
            ical.createToDo(uid, null, null, descr, notes, context, priority);
        } else {
            if (!CalendarPrefs.isSyncDelegated()) {
                return;
            }
            ActionStateDelegated state = (ActionStateDelegated)action.getState();
            String uid = ICalendarSynchronizer.getUID(action.getID());
            String descr = action.getDescription() + "  " + DELEGATED_TO + ": " + state.getTo();
            String context = ICalendarSynchronizer.getContext(action);
            Integer priority = ICalendarSynchronizer.getPriority(action);
            String notes = ICalendarSynchronizer.getNotes(action);
            if (CalendarPrefs.isDelegatedAsTodo()) {
                ical.createToDo(uid, actionDate, actionDate, descr, notes, context, priority);
            } else {
                ical.createAllDayEvent(uid, actionDate, descr, notes, context, priority);
            }
        }
    }

    private static void processScheduled(Action action) {
        if (!CalendarPrefs.isSyncScheduled()) {
            return;
        }
        ActionStateScheduled state = (ActionStateScheduled)action.getState();
        Date scheduled = state.getDate();
        if (scheduled == null) {
            return;
        }
        int hours = state.getDurationHours();
        int mins = state.getDurationMinutes();
        if (hours < 1 && mins < 1) {
            hours = 0;
            mins = 15;
        }
        String uid = ICalendarSynchronizer.getUID(action.getID());
        String descr = action.getDescription();
        String context = ICalendarSynchronizer.getContext(action);
        Integer priority = ICalendarSynchronizer.getPriority(action);
        String notes = ICalendarSynchronizer.getNotes(action);
        if (DateUtils.hasTime((Date)scheduled)) {
            ical.createSpecificTimeEvent(uid, scheduled, descr, notes, context, hours, mins, priority);
        } else {
            ical.createAllDayEvent(uid, scheduled, descr, notes, context, priority);
        }
    }

    private static String getUID(int id) {
        return id + UID_SUFFIX;
    }

    private static String getContext(Action action) {
        return action.getContext().getName();
    }

    private static Integer getPriority(Action action) {
        return action.getPriority() == null ? null : action.getPriority().getMappedValue();
    }

    private static String getNotes(Action action) {
        StringBuffer notes = new StringBuffer();
        notes.append(ICalendarSynchronizer.getContext(action));
        if (action.isSingleAction()) {
            Thought thought = action.getThought();
            if (thought != null) {
                notes.append(" {" + thought.getDescription() + "}");
            }
        } else {
            Project project = (Project)action.getParent();
            if (project != null) {
                notes.append(" [" + project.getDescription() + "]");
            }
        }
        notes.append("\r\n");
        notes.append(action.getNotes());
        return notes.toString();
    }
}

