/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.netbeans.swing.tabcontrol.SlidingButton;
import org.netbeans.swing.tabcontrol.SlidingButtonUI;
import org.netbeans.swing.tabcontrol.plaf.WinClassicEditorTabCellRenderer;

public class WindowsSlidingButtonUI
extends SlidingButtonUI {
    private static final SlidingButtonUI INSTANCE = new WindowsSlidingButtonUI();
    private boolean defaults_initialized = false;
    protected Color focusColor;
    protected static int dashedRectGapX;
    protected static int dashedRectGapY;
    protected static int dashedRectGapWidth;
    protected static int dashedRectGapHeight;

    protected WindowsSlidingButtonUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return INSTANCE;
    }

    protected void installBorder(AbstractButton abstractButton) {
        abstractButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            try {
                Integer n = (Integer)UIManager.get("Button.dashedRectGapX");
                dashedRectGapX = n == null ? 3 : n;
                n = (Integer)UIManager.get("Button.dashedRectGapY");
                dashedRectGapY = n == null ? 3 : n;
                n = (Integer)UIManager.get("Button.dashedRectGapWidth");
                dashedRectGapWidth = n == null ? 3 : n;
                n = (Integer)UIManager.get("Button.dashedRectGapHeight");
                dashedRectGapHeight = n == null ? 3 : n;
                this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
                this.defaults_initialized = true;
            }
            catch (NullPointerException nullPointerException) {
                dashedRectGapX = 2;
                dashedRectGapY = 2;
                dashedRectGapWidth = 2;
                dashedRectGapHeight = 2;
            }
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected void paintBackground(Graphics2D graphics2D, AbstractButton abstractButton) {
        if (((SlidingButton)abstractButton).isBlinkState()) {
            graphics2D.setColor(WinClassicEditorTabCellRenderer.ATTENTION_COLOR);
            graphics2D.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
        } else {
            super.paintBackground(graphics2D, abstractButton);
        }
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        Color color = graphics.getColor();
        if (((SlidingButton)abstractButton).isBlinkState()) {
            graphics.setColor(WinClassicEditorTabCellRenderer.ATTENTION_COLOR);
            graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        if (abstractButton.getModel().isRollover() && !abstractButton.getModel().isPressed() && !abstractButton.getModel().isSelected()) {
            graphics.setColor(uIDefaults.getColor("ToggleButton.highlight"));
            graphics.drawRect(0, 0, n - 1, n2 - 1);
            graphics.drawRect(0, 0, 0, n2 - 1);
            Color color2 = uIDefaults.getColor("ToggleButton.shadow");
            Container container = abstractButton.getParent();
            if (container != null && container.getBackground().equals(color2)) {
                color2 = uIDefaults.getColor("ToggleButton.darkShadow");
            }
            graphics.setColor(color2);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        } else {
            Color color3 = uIDefaults.getColor("ToggleButton.shadow");
            Container container = abstractButton.getParent();
            if (container != null && container.getBackground().equals(color3)) {
                color3 = uIDefaults.getColor("ToggleButton.darkShadow");
            }
            graphics.setColor(color3);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
            graphics.setColor(uIDefaults.getColor("ToggleButton.highlight"));
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        }
        graphics.setColor(color);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, dashedRectGapX, dashedRectGapY, n - dashedRectGapWidth, n2 - dashedRectGapHeight);
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton.isFocusPainted()) {
            if (dimension.width % 2 == 0) {
                ++dimension.width;
            }
            if (dimension.height % 2 == 0) {
                ++dimension.height;
            }
        }
        return dimension;
    }
}

