/*
 * Decompiled with CFR 0.152.
 */
package tr.data.files;

import java.util.Vector;
import java.util.logging.Logger;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.actions.SystemAction;
import tr.data.files.Prefs;
import tr.data.files.RecentDataFilesAction;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.model.Data;
import tr.model.DataLookup;

public class Installer
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger("tr.data.files");
    private static final int N_MOST_RECENT = 10;
    private Lookup.Result result;
    private RecentDataFilesAction action;

    public void restored() {
        this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                Installer.this.storeDataFilePath();
                Installer.this.refreshRecentFilesMenu();
            }
        });
    }

    private synchronized void storeDataFilePath() {
        LOG.info("Change of data file.");
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds == null) {
            LOG.info("Datastore was not found.");
            return;
        }
        if (!ds.isLoaded()) {
            LOG.info("No data file loaded.");
            return;
        }
        String path = ds.getPath();
        if (path == null || path.trim().length() == 0) {
            LOG.info("Data file path was null or an empty string.");
            return;
        }
        Vector<String> paths = Prefs.getPaths();
        if (paths.contains(path)) {
            paths.remove(path);
        }
        paths.add(0, path);
        Prefs.setPaths(paths, 10);
    }

    private synchronized void refreshRecentFilesMenu() {
        if (this.action == null) {
            this.action = (RecentDataFilesAction)SystemAction.get(RecentDataFilesAction.class);
        }
        this.action.refreshMenu();
    }
}

