/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ConvolveWidget
extends Widget {
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private ConvolveOp convolveOp;
    private BufferedImage image;
    private Graphics2D imageGraphics;

    public ConvolveWidget(Scene scene, ConvolveOp convolveOp) {
        super(scene);
        this.convolveOp = convolveOp;
        Kernel kernel = convolveOp.getKernel();
        this.setBorder(BorderFactory.createEmptyBorder(kernel.getWidth(), kernel.getHeight()));
    }

    public ConvolveOp getConvolveOp() {
        return this.convolveOp;
    }

    public void setConvolveOp(ConvolveOp convolveOp) {
        this.convolveOp = convolveOp;
        this.repaint();
    }

    public void clearCache() {
        if (this.imageGraphics != null) {
            this.imageGraphics.dispose();
        }
        this.image = null;
    }

    protected void paintChildren() {
        Rectangle rectangle = this.getBounds();
        if (this.image == null || this.image.getWidth() < rectangle.width || this.image.getHeight() < rectangle.height) {
            this.clearCache();
            this.image = new BufferedImage(rectangle.width, rectangle.height, 2);
            this.imageGraphics = this.image.createGraphics();
        }
        Graphics2D graphics2D = this.getScene().getGraphics();
        this.imageGraphics.translate(-rectangle.x, -rectangle.y);
        this.imageGraphics.setBackground(TRANSPARENT);
        this.imageGraphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.getScene().setGraphics(this.imageGraphics);
        super.paintChildren();
        this.getScene().setGraphics(graphics2D);
        this.imageGraphics.translate(rectangle.x, rectangle.y);
        this.getGraphics().drawImage(this.image, this.convolveOp, rectangle.x, rectangle.y);
    }
}

