/*
 * Decompiled with CFR 0.152.
 */
package tr.archive;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.Frame;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;
import tr.archive.ArchiveDialog;
import tr.archive.ArchivePrefs;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.datastore.xstream.XStreamWrapper;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.RecurrenceRemover;
import tr.model.project.Project;
import tr.model.project.ProjectSingleActions;
import tr.model.thought.Thought;
import tr.model.util.Manager;
import tr.util.DateUtils;
import tr.util.Observable;
import tr.util.UtilsFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArchiveAction
extends CallableSystemAction
implements LookupListener {
    private static final Logger LOG = Logger.getLogger("tr.archive");
    private static final DateFormat DATESTAMP = new SimpleDateFormat("yyyyMMdd");
    private static final DateFormat TIMESTAMP = new SimpleDateFormat("HHmmssSSS");
    private Date archiveDate;
    private Vector<Project> archiveProjects;
    private Vector<Action> archiveActions;
    private Vector<Action> archiveSingleActions;

    public ArchiveAction() {
        this.setIcon(Icons.Archive);
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener((LookupListener)this);
        r.allInstances();
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ArchiveAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.archive");
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction() {
        Project dataParent;
        File archiveFolder;
        Date date = ArchivePrefs.getDate();
        String path = ArchivePrefs.getPath();
        boolean doneProjectsOnly = ArchivePrefs.isDoneProjectsOnly();
        Frame frame = WindowManager.getDefault().getMainWindow();
        ArchiveDialog dialog = new ArchiveDialog(frame, true, date, path, doneProjectsOnly);
        dialog.setVisible(true);
        if (!dialog.archive) {
            LOG.fine("User did not select archive");
            return;
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ArchiveAction.class, (String)"archiving"));
        this.archiveDate = DateUtils.getEnd((Date)dialog.getArchiveDate());
        String archivePath = dialog.getArchivePath();
        doneProjectsOnly = dialog.isDoneProjectsOnly();
        DataStore datastore = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (datastore == null) {
            LOG.severe("Data store could not be obtained.");
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        File dataFile = new File(datastore.getPath());
        if (!dataFile.isFile()) {
            LOG.severe("Data file path error.");
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        File file = archiveFolder = archivePath == null || archivePath.equals("") ? dataFile.getParentFile() : new File(archivePath);
        if (!archiveFolder.isDirectory()) {
            LOG.severe("Archive directory error.");
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        String filename = UtilsFile.removeExtension((String)dataFile.getName());
        String extension = UtilsFile.getExtension((String)dataFile.getName());
        Date currentDate = Calendar.getInstance().getTime();
        String currentDateStamp = DATESTAMP.format(currentDate);
        String currentTimeStamp = TIMESTAMP.format(currentDate);
        File backupFile = new File(archiveFolder, filename + "-" + currentDateStamp + "-" + currentTimeStamp + ".backup." + extension);
        try {
            UtilsFile.copyFile((File)dataFile, (File)backupFile);
        }
        catch (Exception ex) {
            LOG.severe("Error creating archive backup of datafile. " + ex.getMessage());
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        String archiveDateStamp = DATESTAMP.format(this.archiveDate);
        File archiveFile = new File(archiveFolder, filename + "-" + archiveDateStamp + "-" + currentTimeStamp + ".archive." + extension);
        try {
            UtilsFile.copyFile((File)dataFile, (File)archiveFile);
        }
        catch (Exception ex) {
            LOG.severe("Error creating archive copy of datafile. " + ex.getMessage());
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        this.archiveSingleActions = new Vector();
        this.archiveActions = new Vector();
        this.archiveProjects = new Vector();
        Data archiveData = null;
        try {
            archiveData = XStreamWrapper.instance().load(archiveFile);
        }
        catch (Exception ex) {
            LOG.severe("Error loading data from archive file. " + ex.getMessage());
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        for (Action action : archiveData.getRootActions().getChildren(Action.class)) {
            if (action.isDone() && action.getDoneDate().before(this.archiveDate)) {
                this.archiveSingleActions.add(action);
                continue;
            }
            LOG.fine("Removing from archive - action: " + action.getDescription());
            action.removeFromParent();
        }
        if (doneProjectsOnly) {
            for (Project project : archiveData.getRootProjects().getChildren(Project.class)) {
                if (project.isDone() && project.getDoneDate().before(this.archiveDate)) {
                    this.archiveProjects.add(project);
                    continue;
                }
                LOG.fine("Removing from archive - project: " + project.getDescription());
                project.removeFromParent();
            }
        } else {
            for (Project project : archiveData.getRootProjects().getChildren(Project.class)) {
                this.keepArchived(project);
            }
        }
        Manager archiveThoughtManager = archiveData.getThoughtManager();
        for (Thought thought : archiveThoughtManager.list()) {
            if (thought.isProcessed()) continue;
            archiveThoughtManager.remove((Observable)thought);
        }
        Iterator i = archiveData.getRootFutures().iterator(Project.class);
        while (i.hasNext()) {
            ((Project)i.next()).removeFromParent();
        }
        i = archiveData.getRootTemplates().iterator(Project.class);
        while (i.hasNext()) {
            ((Project)i.next()).removeFromParent();
        }
        archiveData.getFutureManager().removeAll();
        archiveData.getInformationManager().removeAll();
        RecurrenceRemover.removeAll((Data)archiveData);
        try {
            XStreamWrapper.instance().store(archiveData, archiveFile);
        }
        catch (Exception ex) {
            LOG.severe("Error storing archive. " + ex.getMessage());
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            LOG.severe("Data could not be obtained.");
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        ProjectSingleActions singleActions = data.getRootActions();
        for (Action a : this.archiveSingleActions) {
            LOG.fine("Removing from data - single action: " + a.getDescription());
            singleActions.remove((Item)a);
        }
        Map<Integer, Project> dataProjectsMap = this.createProjectsMap(data);
        for (Action archiveAction : this.archiveActions) {
            LOG.fine("Removing from data file - archived action: " + archiveAction.getDescription());
            dataParent = dataProjectsMap.get(archiveAction.getParent().getID());
            if (dataParent != null) {
                if (dataParent.remove((Item)archiveAction)) continue;
                LOG.severe("Archived action could not be removed from data file.");
                continue;
            }
            LOG.severe("Could not find parent project in data file for archived action.");
        }
        for (Project archiveProject : this.archiveProjects) {
            LOG.fine("Removing from data file - archived project: " + archiveProject.getDescription());
            dataParent = dataProjectsMap.get(archiveProject.getParent().getID());
            if (dataParent != null) {
                if (dataParent.remove((Item)archiveProject)) continue;
                LOG.severe("Archived project could not be removed from data file.");
                continue;
            }
            LOG.severe("Could not find parent project in data file for archived project.");
        }
        this.saveData(datastore);
        ArchivePrefs.setDate(this.archiveDate);
        ArchivePrefs.setPath(archivePath);
        ArchivePrefs.setDoneProjectsOnly(doneProjectsOnly);
        StatusDisplayer.getDefault().setStatusText("");
        String t = "ThinkingRock " + NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ArchiveAction");
        String COMPLETED = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"archive.completed");
        String ARCHIVE_DATE = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"archive.date");
        String BACKUP_FILE = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"backup.file");
        String ARCHIVE_FILE = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"archive.file");
        String SINGLE_ACTIONS = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"single.actions");
        String PROJECTS = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"projects");
        String PROJECT_ACTIONS = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"project.actions");
        String m = COMPLETED + ". \n\n" + ARCHIVE_DATE + ": " + this.archiveDate + "\n\n" + BACKUP_FILE + ": " + backupFile.getPath() + "\n" + ARCHIVE_FILE + ": " + archiveFile.getPath() + "\n\n";
        JOptionPane.showMessageDialog(frame, m, t, 1);
    }

    private boolean keepArchived(Project project) {
        if (project == null) {
            return false;
        }
        if (project.isDone() && project.getDoneDate().before(this.archiveDate)) {
            this.archiveProjects.add(project);
            return true;
        }
        boolean isAnyKept = false;
        for (Project subproject : project.getChildren(Project.class)) {
            if (!this.keepArchived(subproject)) continue;
            isAnyKept = true;
        }
        for (Action action : project.getChildren(Action.class)) {
            if (action.isDone() && action.getDoneDate().before(this.archiveDate)) {
                this.archiveActions.add(action);
                isAnyKept = true;
                continue;
            }
            action.removeFromParent();
        }
        if (!isAnyKept) {
            project.removeFromParent();
        }
        return isAnyKept;
    }

    private Map<Integer, Project> createProjectsMap(Data data) {
        HashMap<Integer, Project> map = new HashMap<Integer, Project>();
        this.mapProjects(data.getRootProjects(), map);
        return map;
    }

    private void mapProjects(Project project, Map<Integer, Project> map) {
        map.put(project.getID(), project);
        for (Project subproject : project.getChildren(Project.class)) {
            this.mapProjects(subproject, map);
        }
    }

    private void saveData(DataStore ds) {
        try {
            ds.store();
        }
        catch (Exception ex) {
            LOG.severe("Could not save data. " + ex.getMessage());
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }
}

