/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.view.action.prefs.ActionOptionsPanelController;
import tr.view.action.prefs.ActionPrefs;

final class ActionPrefsPanel
extends JPanel {
    private final ActionOptionsPanelController controller;
    private JCheckBox successCheckBox;
    private JCheckBox dueDateCheckBox;
    private JCheckBox startDateCheckBox;
    private JCheckBox editCreateDateCheckBox;
    private JCheckBox noteEmailCheckBox;
    private JComboBox encodingCombo;
    private JLabel encodingLabel;

    ActionPrefsPanel(ActionOptionsPanelController controller) {
        this.controller = controller;
        this.initForm();
    }

    void load() {
        this.noteEmailCheckBox.setSelected(ActionPrefs.isNoteDelegateEmail());
        this.successCheckBox.setSelected(ActionPrefs.isShowSuccess());
        this.startDateCheckBox.setSelected(ActionPrefs.isShowStartDate());
        this.dueDateCheckBox.setSelected(ActionPrefs.isShowDueDate());
        this.editCreateDateCheckBox.setSelected(ActionPrefs.isEditCreateDate());
        this.encodingCombo.setSelectedItem(ActionPrefs.getEmailEncoding());
    }

    void store() {
        ActionPrefs.setNoteDelegateEmail(this.noteEmailCheckBox.isSelected());
        ActionPrefs.setShowSuccess(this.successCheckBox.isSelected());
        ActionPrefs.setShowStartDate(this.startDateCheckBox.isSelected());
        ActionPrefs.setShowDueDate(this.dueDateCheckBox.isSelected());
        ActionPrefs.setEditCreateDate(this.editCreateDateCheckBox.isSelected());
        if (this.isValidEncoding()) {
            ActionPrefs.setEmailEncoding(this.getEncoding());
        }
    }

    boolean valid() {
        return this.isValidEncoding();
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(ActionPrefsPanel.class, (String)key);
    }

    private void initForm() {
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.noteEmailCheckBox = new JCheckBox(this.getMsg("CTL_NoteEmail"));
        this.noteEmailCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPrefsPanel.this.controller.changed();
            }
        });
        this.successCheckBox = new JCheckBox(this.getMsg("CTL_IncludeSuccess"));
        this.successCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPrefsPanel.this.controller.changed();
            }
        });
        this.startDateCheckBox = new JCheckBox(this.getMsg("CTL_IncludeStartDate"));
        this.startDateCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPrefsPanel.this.controller.changed();
            }
        });
        this.dueDateCheckBox = new JCheckBox(this.getMsg("CTL_IncludeDueDate"));
        this.dueDateCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPrefsPanel.this.controller.changed();
            }
        });
        this.editCreateDateCheckBox = new JCheckBox(this.getMsg("CTL_EditCreateDate"));
        this.editCreateDateCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPrefsPanel.this.controller.changed();
            }
        });
        this.encodingLabel = new JLabel(this.getMsg("CTL_EmailEncoding"));
        this.encodingCombo = new JComboBox(this.getEncodingModel());
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]0", "0[]2[]2[]2[]2[]2[]0"));
        panel.add((Component)this.successCheckBox, "align left, wrap");
        panel.add((Component)this.dueDateCheckBox, "align left, wrap");
        panel.add((Component)this.startDateCheckBox, "align left, wrap");
        panel.add((Component)this.editCreateDateCheckBox, "align left, wrap");
        panel.add((Component)this.noteEmailCheckBox, "align left, wrap");
        panel.add((Component)this.encodingLabel, "span, split 2, gapleft 6, align left");
        panel.add((Component)this.encodingCombo, "align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private ComboBoxModel getEncodingModel() {
        Vector<String> encodings = new Vector<String>();
        encodings.add("");
        encodings.addAll(Charset.availableCharsets().keySet());
        return new DefaultComboBoxModel(encodings);
    }

    private boolean isValidEncoding() {
        String encoding = this.getEncoding();
        return encoding.length() == 0 || Charset.isSupported(encoding);
    }

    private String getEncoding() {
        String encoding = (String)this.encodingCombo.getSelectedItem();
        return encoding == null ? "" : encoding;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

