/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import au.com.trgtd.tr.appl.Constants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import tr.extract.Extract;
import tr.extract.ExtractAction;
import tr.extract.ExtractUtils;
import tr.extract.criteria.ValueIDsProviderEnergy;
import tr.extract.criteria.ValueIDsProviderPriority;
import tr.extract.criteria.ValueIDsProviderTime;
import tr.model.Data;
import tr.model.Item.ItemList;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.thought.Thought;

public class ExtractActions {
    private static final Logger LOG = Logger.getLogger("tr.extract");
    private static final String TEXT_NONE = NbBundle.getMessage(ExtractAction.class, (String)"none");
    private static final String TEXT_NOBODY = NbBundle.getMessage(ExtractAction.class, (String)"nobody");
    private static final DateFormat DFN = Constants.DATE_FORMAT_FIXED;
    private static final DateFormat DFT = Constants.DATE_TIME_FORMAT_FIXED;
    private static List<Integer> timeIDs;
    private static List<Integer> energyIDs;
    private static List<Integer> priorityIDs;
    private static boolean topicAll;
    private static String topicValue;
    private static boolean contextAll;
    private static String contextValue;

    public static void process(Data data, File xmlfile, String topic, String context) {
        topicAll = topic.equals("all");
        topicValue = topic;
        contextAll = context.equals("all");
        contextValue = context;
        timeIDs = ValueIDsProviderTime.instance.getIDs();
        energyIDs = ValueIDsProviderEnergy.instance.getIDs();
        priorityIDs = ValueIDsProviderPriority.instance.getIDs();
        try {
            Writer out = ExtractActions.initialise(xmlfile);
            ExtractActions.process(data, out);
            ExtractActions.finalise(out);
        }
        catch (Exception ex) {
            LOG.severe("Extracting data failed: " + ex.getMessage());
        }
    }

    public static void process(Data data, File xmlfile) {
        topicAll = true;
        contextAll = true;
        timeIDs = ValueIDsProviderTime.instance.getIDs();
        energyIDs = ValueIDsProviderEnergy.instance.getIDs();
        priorityIDs = ValueIDsProviderPriority.instance.getIDs();
        try {
            Writer out = ExtractActions.initialise(xmlfile);
            ExtractActions.process(data, out);
            ExtractActions.finalise(out);
        }
        catch (Exception ex) {
            LOG.severe("Extracting data failed: " + ex.getMessage());
        }
    }

    private static Writer initialise(File xmlfile) throws Exception {
        if (xmlfile.exists()) {
            xmlfile.delete();
        }
        FileOutputStream fout = new FileOutputStream(xmlfile);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        out.write("<data>\r\n");
        return out;
    }

    private static void finalise(Writer out) throws Exception {
        out.write("</data>\r\n");
        out.flush();
        out.close();
    }

    public static void process(Data data, Writer out) {
        try {
            LOG.info("Extracting actions ... ");
            ExtractActions.processData(data, out);
            LOG.info("Extracting actions ... done");
        }
        catch (Exception ex) {
            LOG.severe("Extracting actions failed: " + ex.getMessage());
        }
    }

    private static void processData(Data data, Writer out) throws Exception {
        out.write("<actions>\r\n");
        ExtractActions.processProjects(data, out);
        ExtractActions.processSingleActions(data, out);
        out.write("</actions>\r\n");
    }

    private static void processProjects(Data data, Writer out) throws Exception {
        for (Project project : data.getRootProjects().getChildren(Project.class)) {
            ExtractActions.processProject(project, data, out);
        }
    }

    private static void processSingleActions(Data data, Writer out) throws Exception {
        ExtractActions.processProject((Project)data.getRootActions(), data, out);
    }

    private static void processProject(Project project, Data data, Writer out) throws Exception {
        for (Project subproject : project.getChildren(Project.class)) {
            ExtractActions.processProject(subproject, data, out);
        }
        for (Action action : project.getChildren(Action.class)) {
            ExtractActions.extractAction(action, out);
        }
    }

    public static void extractAction(Action action, Writer out) throws Exception {
        Project parent;
        if (ExtractActions.filtered(action)) {
            return;
        }
        out.write("<action>\r\n");
        switch (action.getState().getType()) {
            case DOASAP: {
                out.write("<symbol>\u2605</symbol>\r\n");
                break;
            }
            case DELEGATED: {
                out.write("<symbol>\u261e</symbol>\r\n");
                break;
            }
            case SCHEDULED: {
                if (action.getRecurrence() == null) {
                    out.write("<symbol>\u2637</symbol>\r\n");
                    break;
                }
                out.write("<symbol>\u27f3</symbol>\r\n");
                break;
            }
            case INACTIVE: {
                out.write("<symbol>\u2606</symbol>\r\n");
            }
        }
        out.write("<created>" + DFN.format(action.getCreated()) + "</created>\r\n");
        Thought thought = action.getThought();
        if (thought != null) {
            out.write("<thought>" + ExtractActions.escape(action.getThought().getDescription()) + "</thought>\r\n");
        }
        if ((parent = (Project)action.getParent()) == null || parent.isRoot()) {
            out.write("<project></project>\r\n");
            out.write("<project-path></project-path>\r\n");
        } else {
            out.write("<project>" + ExtractActions.escape(parent.getDescription()) + "</project>\r\n");
            out.write("<project-path>" + ExtractActions.escape(ExtractActions.getProjectPath(parent, "")) + "</project-path>\r\n");
        }
        out.write("<descr>" + ExtractActions.escape(action.getDescription()) + "</descr>\r\n");
        out.write("<success>" + ExtractActions.escape(action.getSuccess()) + "</success>\r\n");
        out.write("<topic>" + ExtractActions.escape(action.getTopic().getName()) + "</topic>\r\n");
        String contextName = action.getContext().getName().trim();
        if (!contextName.startsWith("@")) {
            contextName = "@" + contextName;
        }
        out.write("<context>" + ExtractActions.escape(contextName) + "</context>\r\n");
        Value time = action.getTime();
        if (time == null) {
            out.write("<time>" + TEXT_NONE + "</time>\r\n");
            out.write("<time-idx>2147483647</time-idx>\r\n");
        } else {
            out.write("<time>" + ExtractActions.escape(time.getName()) + "</time>\r\n");
            out.write("<time-idx>" + ValueIDsProviderTime.instance.getIDs().indexOf(time.getID()) + "</time-idx>\r\n");
        }
        Value energy = action.getEnergy();
        if (energy == null) {
            out.write("<energy>" + TEXT_NONE + "</energy>\r\n");
            out.write("<energy-idx>2147483647</energy-idx>\r\n");
        } else {
            out.write("<energy>" + ExtractActions.escape(energy.getName()) + "</energy>\r\n");
            out.write("<energy-idx>" + ValueIDsProviderEnergy.instance.getIDs().indexOf(energy.getID()) + "</energy-idx>\r\n");
        }
        Value priority = action.getPriority();
        if (priority == null) {
            out.write("<priority>" + TEXT_NONE + "</priority>\r\n");
            out.write("<priority-idx>2147483647</priority-idx>\r\n");
        } else {
            out.write("<priority>" + ExtractActions.escape(priority.getName()) + "</priority>\r\n");
            out.write("<priority-idx>" + ValueIDsProviderPriority.instance.getIDs().indexOf(priority.getID()) + "</priority-idx>\r\n");
        }
        Date actionDate = action.getActionDate();
        out.write("<action-date-idx>" + (actionDate == null ? Long.MAX_VALUE : actionDate.getTime()) + "</action-date-idx>\r\n");
        if (action.isStateScheduled()) {
            out.write("<action-date>" + (actionDate == null ? "" : DFT.format(actionDate)) + "</action-date>\r\n");
        } else {
            out.write("<action-date>" + (actionDate == null ? "" : DFN.format(actionDate)) + "</action-date>\r\n");
        }
        Date dueDate = action.getDueDate();
        out.write("<due-date-idx>" + (dueDate == null ? Long.MAX_VALUE : dueDate.getTime()) + "</due-date-idx>\r\n");
        out.write("<due-date>" + (dueDate == null ? "" : DFN.format(dueDate)) + "</due-date>\r\n");
        ExtractActions.extractActionState(action, out);
        out.write("<notes>" + ExtractActions.escape(action.getNotes().trim()) + "</notes>\r\n");
        out.write("<done>" + action.isDone() + "</done>\r\n");
        Date doneDate = action.getDoneDate();
        if (doneDate != null) {
            out.write("<done_date>" + DFN.format(doneDate) + "</done_date>\r\n");
            out.write("<done-date-idx>" + (doneDate == null ? Long.MAX_VALUE : doneDate.getTime()) + "</done-date-idx>\r\n");
        }
        out.write("<criteria-display>" + ExtractUtils.getCriteria(action) + "</criteria-display>\r\n");
        out.write("<state-display>" + ExtractUtils.getState(action) + "</state-display>\r\n");
        out.write("</action>\r\n");
    }

    private static void extractActionState(Action action, Writer out) throws Exception {
        ActionState state = action.getState();
        if (state instanceof ActionStateScheduled) {
            ActionStateScheduled s = (ActionStateScheduled)state;
            out.write("<state>");
            out.write("<type>SCHEDULED</type>");
            out.write("<created>" + DFN.format(s.getCreated()) + "</created>");
            if (ExtractActions.hasTime(s.getDate())) {
                out.write("<schd-date>" + (s.getDate() == null ? "" : DFT.format(s.getDate())) + "</schd-date>");
            } else {
                out.write("<schd-date>" + (s.getDate() == null ? "" : DFN.format(s.getDate())) + "</schd-date>");
            }
            out.write("<schd-date-idx>" + (s.getDate() == null ? Long.MAX_VALUE : s.getDate().getTime()) + "</schd-date-idx>");
            if (s.getDurationHours() > 0 || s.getDurationMinutes() > 0) {
                StringBuffer sb = new StringBuffer();
                if (s.getDurationHours() > 0) {
                    sb.append(s.getDurationHours() + "h");
                }
                if (s.getDurationMinutes() > 0) {
                    sb.append(s.getDurationMinutes() + "m");
                }
                out.write("<duration>" + sb.toString() + "</duration>\r\n");
            }
            out.write("</state>\r\n");
        } else {
            ActionStateASAP s;
            if (state instanceof ActionStateASAP) {
                s = (ActionStateASAP)state;
                out.write("<state>");
                out.write("<type>DOASAP</type>");
                out.write("<created>" + DFN.format(s.getCreated()) + "</created>");
                out.write("</state>\r\n");
            } else if (state instanceof ActionStateDelegated) {
                s = (ActionStateDelegated)state;
                out.write("<state>");
                out.write("<type>DELEGATED</type>");
                out.write("<created>" + DFN.format(s.getCreated()) + "</created>");
                String to = s.getTo() == null || s.getTo().trim().length() == 0 ? TEXT_NOBODY : s.getTo();
                out.write("<to>" + ExtractActions.escape(to) + "</to>");
                out.write("<followup-date>" + (s.getDate() == null ? "" : DFN.format(s.getDate())) + "</followup-date>");
                out.write("<followup-date-idx>" + (s.getDate() == null ? Long.MAX_VALUE : s.getDate().getTime()) + "</followup-date-idx>");
                out.write("</state>\r\n");
            } else if (state instanceof ActionStateInactive) {
                s = (ActionStateInactive)state;
                out.write("<state>");
                out.write("<type>INACTIVE</type>");
                out.write("<created>" + DFN.format(s.getCreated()) + "</created>");
                out.write("</state>\r\n");
            }
            Date startDate = action.getStartDate();
            out.write("<start-date>" + (startDate == null ? "" : DFN.format(startDate)) + "</start-date>\r\n");
            out.write("<start-date-idx>" + (startDate == null ? Long.MAX_VALUE : startDate.getTime()) + "</start-date-idx>");
            Date dueDate = action.getDueDate();
            out.write("<due-date>" + (dueDate == null ? "" : DFN.format(dueDate)) + "</due-date>\r\n");
        }
    }

    private static boolean hasTime(Date date) {
        if (date == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(10) > 0 || calendar.get(12) > 0 || calendar.get(13) > 0;
    }

    private static String getProjectPath(Project project, String path) {
        Project parent;
        path = path.length() > 0 ? project.getDescription() + "/" + path : project.getDescription();
        ItemList object = project.getParent();
        if (object instanceof Project && !(parent = (Project)object).isRoot()) {
            return ExtractActions.getProjectPath(parent, path);
        }
        return path;
    }

    private static String escape(String string) {
        return Extract.FormatType.XML.escape(string);
    }

    private static boolean filtered(Action action) {
        if (!topicAll && !topicValue.equals(action.getTopic().getName())) {
            return true;
        }
        return !contextAll && !contextValue.equals(ExtractUtils.getContext(action));
    }
}

