"""Generated message classes for gkebackup version v1alpha1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'gkebackup'


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Backup(_messages.Message):
  r"""Backup resource Next id: 28

  Enums:
    StateValueValuesEnum: Current state of the Backup

  Messages:
    LabelsValue: A set of custom labels supplied by user.

  Fields:
    allNamespaces: Output only. If set to true, all namespaces backup
    clusterConfigSizeBytes: Output only. cluster config backup size in bytes.
    clusterMetadata: cluster metadata
    completeTime: Output only. Completion time of the Backup
    containsSecrets: Output only. A boolean flag specifies whether secrets has
      been backed up
    containsVolumeData: Output only. A boolean flag specifies whether volume
      data has been backed up
    createTime: Output only. [Output Only] The timestamp when this Backup
      resource was created which can be converted to and from
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
    deleteLockDays: delete_lock_days specifies the number of days from the
      create_time of this Backup before which deletion will be blocked. For
      automatically created Backup from schedule, this field will be set to
      the BackupPlan.RetentionPolicy.backup_delete_block_days. Manual creation
      of a Backup with this field unspecified causes the service to use the
      value of BackupPlan.RetentionPolicy.backup_delete_block_days. Creation
      of a Backup with this field set to a value SMALLER than
      BackupPlan.RetentionPolicy.backup_delete_block_days results in an
      invalid response from the service. This field MUST be an int value
      between 0-90(inclusive). This field may only be INCREASED in an Update
      request, or an invalid response will be returned by the service. Note
      that this field ONLY applies to Backups with a SUCCEEDED state. Default
      to 0.
    deleteLockExpireTime: Output only. delete_lock_expire_time suggest the
      timestamp after which the deletion lock will expire. It's an output only
      field calculated from create_time + delete_lock_days, and will be
      updated accordingly when a Backup's delete_lock_days field has been
      updated. Note that this field ONLY applies to Backups with a SUCCEEDED
      state.
    description: User specified descriptive string for this Backup.
    encryptionKey: Output only. encryption key, immutable.
    etag: Output only. `etag` is used for optimistic concurrency control as a
      way to help prevent simultaneous updates of a backup from overwriting
      each other. It is strongly suggested that systems make use of the `etag`
      in the read-modify-write cycle to perform backup updates in order to
      avoid race conditions: An `etag` is returned in the response to
      `GetBackup`, and systems are expected to put that etag in the request to
      `UpdateBackup` to ensure that their change will be applied to the same
      version.
    labels: A set of custom labels supplied by user.
    manual: Output only. manual, a boolean flag suggests whether this Backup
      resource has been created manually. "True" suggests this backup has been
      created manually, "False" suggests this backup has been created
      automatically from the BackupPlan's schedule.
    name: Output only. The fully qualified name of the Backup.
      projects/*/locations/*/backupPlans/*/backups/*
    podCount: Output only. total number of pods backed up.
    resourceCount: Output only. total number of resources backed up
    retainDays: retain_days specifies the desired number of days from the
      create_time of this Backup after which it will be automatically deleted.
      If not specified or set to 0, it means the Backup will NOT be
      automatically deleted. For automatically created Backup from schedule,
      this field will be set to the
      BackupPlan.RetentionPolicy.backup_retain_days. Manual creation of a
      Backup with this field unspecified causes the service to use the value
      of BackupPlan.RetentionPolicy.backup_retain_days. Creation of a Backup
      with this field set to a value SMALLER than delete_lock_days results in
      an invalid response from the service. This field may ONLY be increased
      in an Update request, or an invalid response will be returned by the
      service immediately. Default to 0.
    retainExpireTime: Output only. retain_expire_time suggest the timestamp
      after which the Backup will be automatically deleted. It's an output
      only field calculated from create_time + retain_days, and will be
      updated accordingly when a Backup's retain_days field has been updated.
    selectedApplications: Output only. If set, the list of applications backed
      up
    selectedNamespaces: Output only. If set, the list of namespaces backed up
    sizeBytes: Output only. total size in bytes
    state: Current state of the Backup
    stateReason: Human-readable description of why the backup is in the
      current 'state'.
    uid: Output only. [Output Only] Server generated global unique identifier
      of [UUID4](https://en.wikipedia.org/wiki/Universally_unique_identifier)
    updateTime: Output only. [Output Only] The timestamp when this BackupPlan
      resource was last updated which can be converted to and from
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
    volumeCount: total number of volumes backed up
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Current state of the Backup

    Values:
      BACKUP_STATE_UNSPECIFIED: BACKUP_STATE_UNSPECIFIED
      CREATING: CREATING
      IN_PROGRESS: IN_PROGRESS
      SUCCEEDED: SUCCEEDED
      FAILED: FAILED
      DELETING: Backup
    """
    BACKUP_STATE_UNSPECIFIED = 0
    CREATING = 1
    IN_PROGRESS = 2
    SUCCEEDED = 3
    FAILED = 4
    DELETING = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""A set of custom labels supplied by user.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allNamespaces = _messages.BooleanField(1)
  clusterConfigSizeBytes = _messages.IntegerField(2)
  clusterMetadata = _messages.MessageField('ClusterMetadata', 3)
  completeTime = _messages.StringField(4)
  containsSecrets = _messages.BooleanField(5)
  containsVolumeData = _messages.BooleanField(6)
  createTime = _messages.StringField(7)
  deleteLockDays = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  deleteLockExpireTime = _messages.StringField(9)
  description = _messages.StringField(10)
  encryptionKey = _messages.MessageField('EncryptionKey', 11)
  etag = _messages.StringField(12)
  labels = _messages.MessageField('LabelsValue', 13)
  manual = _messages.BooleanField(14)
  name = _messages.StringField(15)
  podCount = _messages.IntegerField(16, variant=_messages.Variant.INT32)
  resourceCount = _messages.IntegerField(17, variant=_messages.Variant.INT32)
  retainDays = _messages.IntegerField(18, variant=_messages.Variant.INT32)
  retainExpireTime = _messages.StringField(19)
  selectedApplications = _messages.MessageField('NamespacedNames', 20)
  selectedNamespaces = _messages.MessageField('Namespaces', 21)
  sizeBytes = _messages.IntegerField(22)
  state = _messages.EnumField('StateValueValuesEnum', 23)
  stateReason = _messages.StringField(24)
  uid = _messages.StringField(25)
  updateTime = _messages.StringField(26)
  volumeCount = _messages.IntegerField(27, variant=_messages.Variant.INT32)


class BackupConfig(_messages.Message):
  r"""BackupConfig, an inner message type defines the configuration of
  creating a backup from this BackupPlan

  Fields:
    allNamespaces: If set to true, backup whole cluster
    encryptionKey: Custom encryption key. For preview, support GCP KMS only.
    includeSecrets: A boolean flag specifies whether secrets should be backed
      up If unset, the default is false
    includeVolumeData: A boolean flag specifies whether volume data should be
      backed up If unset, the default is false
    selectedApplications: If set, backup the list of applications
    selectedNamespaces: If set, backup the list of namespaces
  """

  allNamespaces = _messages.BooleanField(1)
  encryptionKey = _messages.MessageField('EncryptionKey', 2)
  includeSecrets = _messages.BooleanField(3)
  includeVolumeData = _messages.BooleanField(4)
  selectedApplications = _messages.MessageField('NamespacedNames', 5)
  selectedNamespaces = _messages.MessageField('Namespaces', 6)


class BackupPlan(_messages.Message):
  r"""BackupPlan resource type Next id: 13

  Messages:
    LabelsValue: A set of custom labels supplied by user.

  Fields:
    backupConfig: Defines backup configuration of this BackupPlan.
    backupSchedule: Defines scheduled Backup creation under this BackupPlan.
    cluster: Required. Immutable. GCP resource name of the source cluster for
      this BackupPlan Possible formats: 1. projects/*/locations/*/clusters/*
      2. projects/*/zones/*/clusters/*
    createTime: Output only. [Output Only] The timestamp when this BackupPlan
      resource was created which can be converted to and from
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
    deactivated: A flag indicates whether the plan has been deactivated.
      Setting this field to 'True' locks the plan such that no further updates
      will be allowed, including the deactivated field. It also prevents new
      Backups from being created under this plan, both manually or scheduled.
      Default to 'False'.
    description: User specified descriptive string for this BackupPlan.
    etag: Output only. `etag` is used for optimistic concurrency control as a
      way to help prevent simultaneous updates of a backup plan from
      overwriting each other. It is strongly suggested that systems make use
      of the `etag` in the read-modify-write cycle to perform backup plan
      updates in order to avoid race conditions: An `etag` is returned in the
      response to `GetBackupPlan`, and systems are expected to put that etag
      in the request to `UpdateBackupPlan` to ensure that their change will be
      applied to the same version.
    labels: A set of custom labels supplied by user.
    name: Output only. The full name of the BackupPlan resource. Format:
      projects/*/locations/*/backupPlans/*
    retentionPolicy: RetentionPolicy governs lifecycle of Backups created
      under this plan.
    uid: Output only. [Output Only] Server generated global unique identifier
      of [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier)
      format.
    updateTime: Output only. [Output Only] The timestamp when this BackupPlan
      resource was last updated which can be converted to and from
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""A set of custom labels supplied by user.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  backupConfig = _messages.MessageField('BackupConfig', 1)
  backupSchedule = _messages.MessageField('Schedule', 2)
  cluster = _messages.StringField(3)
  createTime = _messages.StringField(4)
  deactivated = _messages.BooleanField(5)
  description = _messages.StringField(6)
  etag = _messages.StringField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  name = _messages.StringField(9)
  retentionPolicy = _messages.MessageField('RetentionPolicy', 10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class ClusterMetadata(_messages.Message):
  r"""ClusterMetadata

  Messages:
    BackupCrdVersionsValue: gke/anthos backup crd versions

  Fields:
    anthosVersion: anthos version
    backupCrdVersions: gke/anthos backup crd versions
    cluster: Output only. source cluster from where the Backup has been
      created from Possible formats: 1. projects/*/locations/*/clusters/* 2.
      projects/*/zones/*/clusters/*
    gkeVersion: gke version
    k8sVersion: kubernetes server version
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BackupCrdVersionsValue(_messages.Message):
    r"""gke/anthos backup crd versions

    Messages:
      AdditionalProperty: An additional property for a BackupCrdVersionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        BackupCrdVersionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BackupCrdVersionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  anthosVersion = _messages.StringField(1)
  backupCrdVersions = _messages.MessageField('BackupCrdVersionsValue', 2)
  cluster = _messages.StringField(3)
  gkeVersion = _messages.StringField(4)
  k8sVersion = _messages.StringField(5)


class ClusterResourceRestoreScope(_messages.Message):
  r"""ClusterResourceRestoreScope specifies the selection of non-namespaced
  resources for restoration.

  Fields:
    selectedGroupKinds: A list of GroupKinds, a non-namespaces resource MUST
      be one of the GroupKind specified in the list to be restored. An empty
      list suggests NO cluster resources will be restored. NOTE:
      PersistentVolume resources, though are non-namespaced, will be handled
      separately. See VolumeDataRestorePolicy for details. Specifying
      PersistentVolume GroupKind in this list does NOT affect whether or not a
      PersistentVolume and its data will be restored.
  """

  selectedGroupKinds = _messages.MessageField('GroupKind', 1, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class EncryptionKey(_messages.Message):
  r"""Encryption key. For preview, support GCP KMS only.

  Fields:
    gcpKmsEncryptionKey: Google KMS encryption key in the format:
      projects//locations//keyRings//cryptoKeys/
  """

  gcpKmsEncryptionKey = _messages.StringField(1)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GetClusterConfigDownloadUrlResponse(_messages.Message):
  r"""Response which contains a source location of the backup's cluster
  configuration.

  Fields:
    signedUrl: Required. signed_url which will be used by the agent to
      download cluster config.
  """

  signedUrl = _messages.StringField(1)


class GetClusterConfigUploadUrlResponse(_messages.Message):
  r"""Response which contains a target location for the backup's cluster
  configuration.

  Fields:
    signedUrl: Required. signed_url which will be used by the agent to upload
      cluster config.
  """

  signedUrl = _messages.StringField(1)


class GkebackupProjectsLocationsBackupPlansBackupsCreateRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsCreateRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    backupId: The client provided name when a Backup resource is created. The
      name MUST satisfy ALL requirements listed below: a. be unique within the
      BackupPlan to which the Backup is created. b. be 1-63 characters long c.
      comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) . d. matches
      the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`
    parent: Required. Parent BackupPlan container to create Backup in. Format:
      projects/{project}/locations/{location}/backupPlans/{backup_plan}
  """

  backup = _messages.MessageField('Backup', 1)
  backupId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class GkebackupProjectsLocationsBackupPlansBackupsDeleteRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsDeleteRequest object.

  Fields:
    etag: etag, if provided, it must match the server's etag for the delete to
      happen.
    force: If set to true, any volumeBackups from this backup will also be
      deleted. Otherwise, the request will only succeed if the backup has no
      volumeBackup. (Per API guideline https://google.aip.dev/135#cascading-
      delete)
    name: Required. Name of the Backup resource. Format: projects/{project}/lo
      cations/{location}/backupPlans/{backup_plan}/backups/{backup} The
      {backup} field can either be the user specified Backup name or the
      server generated UID for this backup.
  """

  etag = _messages.StringField(1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)


class GkebackupProjectsLocationsBackupPlansBackupsGetClusterConfigDownloadUrlRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsGetClusterConfigDownloadUr
  lRequest object.

  Fields:
    backup: Required. Full name of the Backup resource. Format: projects/{proj
      ect}/locations/{location}/backupPlans/{backup_plan}/backups/{backup} The
      {backup} field can either be the user specified Backup name or the
      server generated UID for this backup.
  """

  backup = _messages.StringField(1, required=True)


class GkebackupProjectsLocationsBackupPlansBackupsGetClusterConfigUploadUrlRequest(_messages.Message):
  r"""A
  GkebackupProjectsLocationsBackupPlansBackupsGetClusterConfigUploadUrlRequest
  object.

  Fields:
    backup: Required. Full name of the Backup resource. Format: projects/{proj
      ect}/locations/{location}/backupPlans/{backup_plan}/backups/{backup} The
      {backup} field can either be the user specified Backup name or the
      server generated UID for this backup.
  """

  backup = _messages.StringField(1, required=True)


class GkebackupProjectsLocationsBackupPlansBackupsGetIamPolicyRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkebackupProjectsLocationsBackupPlansBackupsGetRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsGetRequest object.

  Fields:
    name: Required. Full name of the Backup resource. Format: projects/{projec
      t}/locations/{location}/backupPlans/{backup_plan}/backups/{backup} The
      {backup} field can either be the user specified Backup name or the
      server generated UID for this backup.
  """

  name = _messages.StringField(1, required=True)


class GkebackupProjectsLocationsBackupPlansBackupsListRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results.
    pageSize: If not specified, a default value will be chosen by the service.
      Regardless of the page_size value, the response may include a partial
      list and a caller should only rely on response's next_page_token to
      determine if there are more instances left to be queried.
    pageToken: Token returned by previous call to `ListBackupsRequest` which
      specifies the position in the list from where to continue listing the
      resources.
    parent: Required. Parent BackupPlan container. Format:
      projects/{project}/locations/{location}/backupPlans/{backup_plan}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GkebackupProjectsLocationsBackupPlansBackupsPatchRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsPatchRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    etag: etag, if provided, it must match the server's etag for the update to
      happen.
    name: Output only. The fully qualified name of the Backup.
      projects/*/locations/*/backupPlans/*/backups/*
    updateMask: Fields to be updated.
  """

  backup = _messages.MessageField('Backup', 1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class GkebackupProjectsLocationsBackupPlansBackupsSetIamPolicyRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkebackupProjectsLocationsBackupPlansBackupsSubmitClusterConfigRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsSubmitClusterConfigRequest
  object.

  Fields:
    backup: Required. Full name of the Backup resource. Format: projects/{proj
      ect}/locations/{location}/backupPlans/{backup_plan}/backups/{backup} The
      {backup} field can either be the user specified Backup name or the
      server generated UID for this backup.
    submitClusterConfigRequest: A SubmitClusterConfigRequest resource to be
      passed as the request body.
  """

  backup = _messages.StringField(1, required=True)
  submitClusterConfigRequest = _messages.MessageField('SubmitClusterConfigRequest', 2)


class GkebackupProjectsLocationsBackupPlansBackupsTestIamPermissionsRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsCreateRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsCreateRequest
  object.

  Fields:
    parent: Required. The Backup to create VolumeBackup in. Format: projects/{
      project}/locations/{location}/backupPlans/{backup_plan}/backups/{backup}
      The {backup} field can either be the user specified Backup name or the
      server generated UID for this backup.
    volumeBackup: A VolumeBackup resource to be passed as the request body.
    volumeBackupId: Required. The client provided name when a VolumeBackup
      resource is created. The name MUST satisfy ALL requirements listed
      below: a. be unique within the Backup to which the VolumeBackup is
      created. b. be 1-63 characters long c. comply with
      [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) . d. matches the regular
      expression `[a-z]([-a-z0-9]*[a-z0-9])?`
  """

  parent = _messages.StringField(1, required=True)
  volumeBackup = _messages.MessageField('VolumeBackup', 2)
  volumeBackupId = _messages.StringField(3)


class GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyRequest(_messages.Message):
  r"""A
  GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsGetRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsGetRequest
  object.

  Fields:
    name: Required. Full name of the VolumeBackup resource. Format: projects/{
      project}/locations/{location}/backupPlans/{backup_plan}/backups/{backup}
      /volumeBackups/{volume_backup} The {volume_backup} field can either be
      the user specified Backup name or the server generated UID for this
      volume backup.
  """

  name = _messages.StringField(1, required=True)


class GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsListRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsListRequest
  object.

  Fields:
    filter: List filter.
    orderBy: Sort results.
    pageSize: If not specified, a default value will be chosen by the service.
      Regardless of the page_size value, the response may include a partial
      list and a caller should only rely on response's next_page_token to
      determine if there are more instances left to be queried.
    pageToken: Token returned by previous call to
      ListVolumeBackupsRequest`which specifies the position in the list from
      where to continue listing the resources.
    parent: Required. Format: projects/{project}/locations/{location}/backupPl
      ans/{backup_plan}/backups/{backup} The {backup} field can either be the
      user specified Backup name or the server generated UID for this backup.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsPatchRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsPatchRequest
  object.

  Fields:
    etag: etag, if provided, it must match the server's etag for the update to
      happen.
    name: Output only. Full name of the volume backup which should be unique
      within the Backup. The name will have a format:
      projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/* The last
      segment of the name will have a format: 'pvc-'.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the volume backup resource by this update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten. Fields to
      be updated.
    volumeBackup: A VolumeBackup resource to be passed as the request body.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  volumeBackup = _messages.MessageField('VolumeBackup', 4)


class GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyRequest(_messages.Message):
  r"""A
  GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermissionsRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansBackupsVolumeBackupsTestIamPermis
  sionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GkebackupProjectsLocationsBackupPlansCreateRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansCreateRequest object.

  Fields:
    backupPlan: A BackupPlan resource to be passed as the request body.
    backupPlanId: Required. The client provided name when a BackupPlan
      resource is created. The name MUST satisfy ALL requirements listed
      below: a. be unique within the location to which the BackupPlan is
      created. b. be 1-63 characters long c. comply with
      [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) . d. matches the regular
      expression `[a-z]([-a-z0-9]*[a-z0-9])?`
    parent: Required. Parent resource container. Format:
      projects/{project}/locations/{location}
  """

  backupPlan = _messages.MessageField('BackupPlan', 1)
  backupPlanId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class GkebackupProjectsLocationsBackupPlansDeleteRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansDeleteRequest object.

  Fields:
    etag: etag, if provided, it must match the server's etag for the delete to
      happen.
    name: Required. Fully qualified BackupPlan name. Format:
      projects/{project}/locations/{location}/backupPlans/{backup_plan} The
      {backup_plan} can either be the user specified backup plan name or the
      server generated UID for this BackupPlan
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class GkebackupProjectsLocationsBackupPlansGetIamPolicyRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkebackupProjectsLocationsBackupPlansGetRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansGetRequest object.

  Fields:
    name: Required. Fully qualified BackupPlan name. Format:
      projects/{project}/locations/{location}/backupPlans/{backup_plan} The
      {backup_plan} can either be the user specified backup plan name or the
      server generated UID for this BackupPlan
  """

  name = _messages.StringField(1, required=True)


class GkebackupProjectsLocationsBackupPlansListRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results.
    pageSize: If not specified, a default value will be chosen by the service.
      Regardless of the page_size value, the response may include a partial
      list and a caller should only rely on response's next_page_token to
      determine if there are more instances left to be queried.
    pageToken: A page token, received from a previous `ListBackupPlans` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListBackupPlan` must match the call that
      provided the page token.
    parent: Required. The parent resource name Format:
      projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GkebackupProjectsLocationsBackupPlansPatchRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansPatchRequest object.

  Fields:
    backupPlan: A BackupPlan resource to be passed as the request body.
    etag: etag, if provided, it must match the server's etag for the update to
      happen.
    name: Output only. The full name of the BackupPlan resource. Format:
      projects/*/locations/*/backupPlans/*
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the backupPlan resource by this update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  backupPlan = _messages.MessageField('BackupPlan', 1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class GkebackupProjectsLocationsBackupPlansSetIamPolicyRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkebackupProjectsLocationsBackupPlansTestIamPermissionsRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsBackupPlansTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GkebackupProjectsLocationsGetRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class GkebackupProjectsLocationsListRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkebackupProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class GkebackupProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class GkebackupProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GkebackupProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkebackupProjectsLocationsRestoresCreateRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresCreateRequest object.

  Fields:
    parent: Required. Parent resource container. Format:
      projects/{project}/locations/{location}
    restore: A Restore resource to be passed as the request body.
    restoreId: Required. The client provided name when a Restore resource is
      created. The name MUST satisfy ALL requirements listed below: a. be
      unique within the project to which the restore is created. b. be 1-63
      characters long c. comply with
      [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) . d. matches the regular
      expression `[a-z]([-a-z0-9]*[a-z0-9])?`
  """

  parent = _messages.StringField(1, required=True)
  restore = _messages.MessageField('Restore', 2)
  restoreId = _messages.StringField(3)


class GkebackupProjectsLocationsRestoresDeleteRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresDeleteRequest object.

  Fields:
    etag: etag, if provided, it must match the server's etag for delete to
      happen.
    force: If set to true, any volumeRestores from this restore will also be
      deleted. Otherwise, the request will only succeed if the restore has no
      volumeRestore. (Per API guideline https://google.aip.dev/135#cascading-
      delete)
    name: Full name of the Restore Format:
      projects/{project}/locations/{location}/restores/{restore} The {restore}
      can either be the user specified restore name or the server generated
      UID for this restore
  """

  etag = _messages.StringField(1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)


class GkebackupProjectsLocationsRestoresGetIamPolicyRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkebackupProjectsLocationsRestoresGetRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresGetRequest object.

  Fields:
    name: Required. Name of the restore resource. Format:
      projects/{project}/locations/{location}/restores/{restore} The {restore}
      can either be the user specified restore name or the server generated
      UID for this restore
  """

  name = _messages.StringField(1, required=True)


class GkebackupProjectsLocationsRestoresListRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results.
    pageSize: If not specified, a default value will be chosen by the service.
      Regardless of the page_size value, the response may include a partial
      list and a caller should only rely on response's next_page_token to
      determine if there are more instances left to be queried.
    pageToken: Token returned by previous call to `ListRestoresRequest` which
      specifies the position in the list from where to continue listing the
      resources.
    parent: Required. Parent owns the collection of Restore resources. Format:
      projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GkebackupProjectsLocationsRestoresPatchRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresPatchRequest object.

  Fields:
    etag: etag, if provided, it must match the server's etag for the update to
      happen.
    name: Output only. The full name of the Restore resource. Format:
      projects/{project}/locations/{location}/restores/{restore}
    restore: A Restore resource to be passed as the request body.
    updateMask: Field mask is used to specify the fields to be overwritten in
      the Restore resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then all fields will be overwritten.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  restore = _messages.MessageField('Restore', 3)
  updateMask = _messages.StringField(4)


class GkebackupProjectsLocationsRestoresSetIamPolicyRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkebackupProjectsLocationsRestoresTestIamPermissionsRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GkebackupProjectsLocationsRestoresVolumeRestoresCreateRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresVolumeRestoresCreateRequest object.

  Fields:
    parent: Required. The Restore to create VolumeRestore in. Format:
      projects/{project}/locations/{location}/restores/{restore} The {restore}
      field can either be the user specified Restore name or the server
      generated UID for this restore.
    volumeRestore: A VolumeRestore resource to be passed as the request body.
    volumeRestoreId: Required. The client provided name when a VolumeRestore
      resource is created. The name MUST satisfy ALL requirements listed
      below: a. be unique within the Restore to which the VolumeRestore is
      created. b. be 1-63 characters long c. comply with
      [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) . d. matches the regular
      expression `[a-z]([-a-z0-9]*[a-z0-9])?`
  """

  parent = _messages.StringField(1, required=True)
  volumeRestore = _messages.MessageField('VolumeRestore', 2)
  volumeRestoreId = _messages.StringField(3)


class GkebackupProjectsLocationsRestoresVolumeRestoresGetIamPolicyRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresVolumeRestoresGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkebackupProjectsLocationsRestoresVolumeRestoresGetRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresVolumeRestoresGetRequest object.

  Fields:
    name: Required. Full name of the VolumeRestore resource. Format: projects/
      {project}/locations/{location}/restores/{restore}/volumeRestores/{volume
      _restore} The {volume_restore} field can either be the user specified
      VolumeRestore name or the server generated UID for this volume restore.
  """

  name = _messages.StringField(1, required=True)


class GkebackupProjectsLocationsRestoresVolumeRestoresListRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresVolumeRestoresListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results.
    pageSize: If not specified, a default value will be chosen by the service.
      Regardless of the page_size value, the response may include a partial
      list and a caller should only rely on response's next_page_token to
      determine if there are more instances left to be queried.
    pageToken: Token returned by previous call to
      ListVolumeRestoresRequest`which specifies the position in the list from
      where to continue listing the resources.
    parent: Required. Format:
      projects/{project}/locations/{location}/restores/{restore} The {restore}
      field can either be the user specified Restore name or the server
      generated UID for this restore.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class GkebackupProjectsLocationsRestoresVolumeRestoresPatchRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresVolumeRestoresPatchRequest object.

  Fields:
    etag: etag, if provided, it must match the server's etag for the update to
      happen.
    name: Output only. Full name of the volume restore which should be unique
      within the Restore. The name will have a format:
      projects/*/locations/*/restores/*/volumeRestores/* The last segment of
      the name will have a format: 'pvc-'.
    updateMask: Fields to be updated.
    volumeRestore: A VolumeRestore resource to be passed as the request body.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  volumeRestore = _messages.MessageField('VolumeRestore', 4)


class GkebackupProjectsLocationsRestoresVolumeRestoresSetIamPolicyRequest(_messages.Message):
  r"""A GkebackupProjectsLocationsRestoresVolumeRestoresSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkebackupProjectsLocationsRestoresVolumeRestoresTestIamPermissionsRequest(_messages.Message):
  r"""A
  GkebackupProjectsLocationsRestoresVolumeRestoresTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GroupKind(_messages.Message):
  r"""GroupKind, a direct map to Kubernetes [GroupKind](https://godoc.org/k8s.
  io/apimachinery/pkg/runtime/schema#GroupKind)

  Fields:
    resourceGroup: API group string of a Kubernetes resource for example:
      "apps", "apiextensions.k8s.io", "storage.k8s.io" Note: use empty string
      for core API group
    resourceKind: Kind of a Kubernetes resource for example:
      "PersistentVolumeClaim", "StatefulSet", "Deployment"
  """

  resourceGroup = _messages.StringField(1)
  resourceKind = _messages.StringField(2)


class ListBackupPlansResponse(_messages.Message):
  r"""Response for listing BackupPlans.

  Fields:
    backupPlans: The list of backupPlans.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, it means there is no subsequent
      page.
    unreachable: Locations that could not be reached.
  """

  backupPlans = _messages.MessageField('BackupPlan', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListBackupsResponse(_messages.Message):
  r"""Response of ListBackupsRequest.

  Fields:
    backups: The list of restore resources within the parent.
    nextPageToken: A token to request the next page of resources from the
      `ListBackupsResponse` method. The value of an empty string means that
      there are no more resources to return.
  """

  backups = _messages.MessageField('Backup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListRestoresResponse(_messages.Message):
  r"""Response of ListingRestoresRequest.

  Fields:
    nextPageToken: A token to request the next page of resources from the
      `ListRestoresRequest` method. The value of an empty string means that
      there are no more resources to return.
    restores: The list of restore resources within the parent.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  restores = _messages.MessageField('Restore', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListVolumeBackupsResponse(_messages.Message):
  r"""Response of ListVolumeBackupRequest.

  Fields:
    nextPageToken: A token to request the next page of resources from the
      `ListVolumeBackupsResponse` method. The value of an empty string means
      that there are no more resources to return.
    volumeBackups: The list of VolumeBackups resources within the parent.
  """

  nextPageToken = _messages.StringField(1)
  volumeBackups = _messages.MessageField('VolumeBackup', 2, repeated=True)


class ListVolumeRestoresResponse(_messages.Message):
  r"""Response of ListVolumeRestoresRequest.

  Fields:
    nextPageToken: A token to request the next page of resources from the
      `ListVolumeRestoresResponse` method. The value of an empty string means
      that there are no more resources to return.
    volumeRestores: The list of VolumeRestores resources within the parent.
  """

  nextPageToken = _messages.StringField(1)
  volumeRestores = _messages.MessageField('VolumeRestore', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class NamespacedName(_messages.Message):
  r"""NamespacedName Next id: 3

  Fields:
    name: the name of the resource in Kubernetes
    namespace: the namespace of the resource in Kubernetes
  """

  name = _messages.StringField(1)
  namespace = _messages.StringField(2)


class NamespacedNames(_messages.Message):
  r"""NamespacedNames Next id: 2

  Fields:
    namespacedNames: a list of namespaced names in Kubernetes
  """

  namespacedNames = _messages.MessageField('NamespacedName', 1, repeated=True)


class Namespaces(_messages.Message):
  r"""Namespaces, list of namespaces

  Fields:
    namespaces: namespaces
  """

  namespaces = _messages.StringField(1, repeated=True)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Restore(_messages.Message):
  r"""Restore presents the user's intention and action to perform a restore
  from a backup. Next id: 18

  Enums:
    StateValueValuesEnum: The current state of the restore.

  Messages:
    LabelsValue: GCP Labels.

  Fields:
    backup: Required. Immutable. Full name of the Backup resource this Restore
      resource used to restore from. Format:
      projects/*/locations/*/backupPlans/*/backups/*.
    cluster: Required. Immutable. Name of the cluster this restore targets at.
      Possible formats: 1. projects/*/locations/*/clusters/* 2.
      projects/*/zones/*/clusters/*
    completeTime: Output only. End time of the restore process.
    createTime: Output only. [Output Only] The timestamp when this Restore
      resource was created which can be converted to and from
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
    description: User specified descriptive string for this Restore.
    etag: Output only. `etag` is used for optimistic concurrency control as a
      way to help prevent simultaneous updates of a restore from overwriting
      each other. It is strongly suggested that systems make use of the `etag`
      in the read-modify-write cycle to perform restore updates in order to
      avoid race conditions: An `etag` is returned in the response to
      `GetRestore`, and systems are expected to put that etag in the request
      to `UpdateRestore` to ensure that their change will be applied to the
      same version.
    labels: GCP Labels.
    name: Output only. The full name of the Restore resource. Format:
      projects/{project}/locations/{location}/restores/{restore}
    resourcesExcludedCount: Number of resources excluded in this restore
      action.
    resourcesFailedCount: Number of resources failed to be restored in this
      restore action.
    resourcesRestoredCount: Number of resources restored in this restore
      action.
    restoreConfig: Required. Immutable. Configuration of the restore.
    restoredVolumesCount: Number of volumes restored in this restore action.
    state: The current state of the restore.
    stateReason: Human-readable description of why the restore is in the
      'State'.
    uid: Output only. [Output Only] Server generated global unique identifier
      of [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier)
      format.
    updateTime: Output only. [Output Only] The timestamp when this Restore
      resource was last updated which can be converted to and from
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the restore.

    Values:
      RESTORE_STATE_UNSPECIFIED: Unspecified, default value
      CREATING: Restore resource has been created
      IN_PROGRESS: Restore is in progress
      SUCCEEDED: Restore succeeded
      FAILED: Restore failed
      DELETING: Restore is being deleted
    """
    RESTORE_STATE_UNSPECIFIED = 0
    CREATING = 1
    IN_PROGRESS = 2
    SUCCEEDED = 3
    FAILED = 4
    DELETING = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""GCP Labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  backup = _messages.StringField(1)
  cluster = _messages.StringField(2)
  completeTime = _messages.StringField(3)
  createTime = _messages.StringField(4)
  description = _messages.StringField(5)
  etag = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  resourcesExcludedCount = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  resourcesFailedCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  resourcesRestoredCount = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  restoreConfig = _messages.MessageField('RestoreConfig', 12)
  restoredVolumesCount = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  state = _messages.EnumField('StateValueValuesEnum', 14)
  stateReason = _messages.StringField(15)
  uid = _messages.StringField(16)
  updateTime = _messages.StringField(17)


class RestoreConfig(_messages.Message):
  r"""Configuration of a restore. Next id: 9

  Enums:
    ClusterResourceConflictPolicyValueValuesEnum:
      cluster_resource_conflict_policy specifies the policy to resolve
      conflicts when restore cluster-scoped resources. Not specifying this
      field or specifying it to CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED
      but with cluster_resource_restore_scope specified invalidates the
      request immediately.
    NamespacedResourceRestoreModeValueValuesEnum:
      namespaced_resource_restore_mode specifies the restoration mode for
      namespaced resources. Not specifying this field or specifying it to
      NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED with
      namespaced_resource_restore_scope specified immediately invalidates this
      request.
    VolumeDataRestorePolicyValueValuesEnum: volume_data_restore_policy
      specifies the policy to use for volume data restoration. Default to
      "NO_VOLUME_DATA_RESTORATION" if not specified.

  Fields:
    allNamespaces: Restore all namespaced resources in the backup if set to
      "True". Specifying this field to "False" invalidates this request.
    clusterResourceConflictPolicy: cluster_resource_conflict_policy specifies
      the policy to resolve conflicts when restore cluster-scoped resources.
      Not specifying this field or specifying it to
      CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED but with
      cluster_resource_restore_scope specified invalidates the request
      immediately.
    clusterResourceRestoreScope: cluster_resource_restore_scope specifies the
      non-namespaced resources to be restored. Not specifying it means NO
      cluster resource will be restored.
    namespacedResourceRestoreMode: namespaced_resource_restore_mode specifies
      the restoration mode for namespaced resources. Not specifying this field
      or specifying it to NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED with
      namespaced_resource_restore_scope specified immediately invalidates this
      request.
    selectedApplications: A list of selected applications to restore. Only
      thoes namespaced resources which belong to one of the listed application
      will be restored.
    selectedNamespaces: A list of selected namespaces to restore. Only thoes
      resources with original namespace as one of the specified in the list
      will be restored. Note that specifying an empty string(i.e., "") in this
      list does NOT mean to restore cluster(non-namespaced) resources. To
      restore cluster resources, see "cluster_resource_restore_scope".
    substitutionRules: Rules to substitute values in the backed-up K8s
      resources during restore. An empty list means no substitution will
      happen. Substitution rules are applied sequentially in the order
      defined. This order matters, as changes made by a rule may impact the
      matching logic of the subsequent rule.
    volumeDataRestorePolicy: volume_data_restore_policy specifies the policy
      to use for volume data restoration. Default to
      "NO_VOLUME_DATA_RESTORATION" if not specified.
  """

  class ClusterResourceConflictPolicyValueValuesEnum(_messages.Enum):
    r"""cluster_resource_conflict_policy specifies the policy to resolve
    conflicts when restore cluster-scoped resources. Not specifying this field
    or specifying it to CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED but with
    cluster_resource_restore_scope specified invalidates the request
    immediately.

    Values:
      CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED: Unspecified.
      USE_EXISTING_VERSION: USE_EXISTING_VERSION means to use the existing
        version in target cluster. No conflict will be reported and the final
        state of the Restore will not be affected.
      USE_BACKUP_VERSION: UseBackupVersion will cause the controller to delete
        the existing version in the target cluster and recreate it from the
        one in Backup. This is a dangerous option which could cause
        unintentional data loss if used in-appropriately.(For example,
        deletion of a CRD causes K8s to delete all CRs of that CRD type).
    """
    CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED = 0
    USE_EXISTING_VERSION = 1
    USE_BACKUP_VERSION = 2

  class NamespacedResourceRestoreModeValueValuesEnum(_messages.Enum):
    r"""namespaced_resource_restore_mode specifies the restoration mode for
    namespaced resources. Not specifying this field or specifying it to
    NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED with
    namespaced_resource_restore_scope specified immediately invalidates this
    request.

    Values:
      NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED: mode unspecified
      DELETE_AND_RESTORE: DELETE_AND_RESTORE means existing top level
        resources specified to restore(Top level resources are either
        Namespaces or ProtectedApplications) AND resources underneath them
        will be deleted before restoration. Note that this mode could cause
        data loss as it deletes existing resources from the target cluster. A
        typical scenario to use this mode in Restore would be rollback a
        problematic upgrade to the previously saved state.
      FAIL_ON_CONFLICT: FAIL_ON_CONFLICT means the restoration will fail when
        it encounters a conflict. Existence checks at Namespace or
        ProtectedApplication level will happen before restoration. If ANY to-
        be-restored application or namespace exists in the target target
        cluster, the Restore fails immediately. If conflict happened AFTER
        successful existence checks, i.e., a to-be-restored resource of a
        workload/namespace gets created by another process or manually, a
        conflict will be reported.
    """
    NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED = 0
    DELETE_AND_RESTORE = 1
    FAIL_ON_CONFLICT = 2

  class VolumeDataRestorePolicyValueValuesEnum(_messages.Enum):
    r"""volume_data_restore_policy specifies the policy to use for volume data
    restoration. Default to "NO_VOLUME_DATA_RESTORATION" if not specified.

    Values:
      VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED: unspecified, default value
      RESTORE_VOLUME_DATA_FROM_BACKUP: RESTORE_VOLUME_DATA_FROM_BACKUP means a
        new PV will be restored using the corresponding volume backup data in
        the Backup.
      REUSE_VOLUME_HANDLE_FROM_BACKUP: REUSE_VOLUME_HANDLE_FROM_BACKUP means a
        PV will be pre-provisioned using the volume handle of the original PV
        in the Backup.
      NO_VOLUME_DATA_RESTORATION: NO_VOLUME_DATA_RESTORATION means PV will not
        be restored. The restoration will ONLY restore selected PVCs and
        expects corresponding Kubernetes controllers to either dynamically
        provision blank PVs or bind them to pre-provisioned PVs created out-
        of-band.
    """
    VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED = 0
    RESTORE_VOLUME_DATA_FROM_BACKUP = 1
    REUSE_VOLUME_HANDLE_FROM_BACKUP = 2
    NO_VOLUME_DATA_RESTORATION = 3

  allNamespaces = _messages.BooleanField(1)
  clusterResourceConflictPolicy = _messages.EnumField('ClusterResourceConflictPolicyValueValuesEnum', 2)
  clusterResourceRestoreScope = _messages.MessageField('ClusterResourceRestoreScope', 3)
  namespacedResourceRestoreMode = _messages.EnumField('NamespacedResourceRestoreModeValueValuesEnum', 4)
  selectedApplications = _messages.MessageField('NamespacedNames', 5)
  selectedNamespaces = _messages.MessageField('Namespaces', 6)
  substitutionRules = _messages.MessageField('SubstitutionRule', 7, repeated=True)
  volumeDataRestorePolicy = _messages.EnumField('VolumeDataRestorePolicyValueValuesEnum', 8)


class RetentionPolicy(_messages.Message):
  r"""RentionPolicy is an inner message type to define: 1. When to
  automatically delete Backups created under this BackupPlan 2. A plan level
  minimum Backup retain days which blocks deletion 3. Lock to disallow any
  policy updates

  Fields:
    backupDeleteLockDays: Number of days during which deletion of a Backup
      created under this BackupPlan will be blocked. Default to 0. This field
      MUST be an int value between 0-90(inclusive). A Backup created under
      this BackupPlan will NOT be deletable until it reaches Backup's
      create_time + backup_delete_lock_days. Updating this field of a
      BackupPlan does NOT affect existing Backups under it. Backups created
      AFTER a successful update will automatically pick up the new value.
    backupRetainDays: Number of days after which the service will delete a
      Backup. If specified, a Backup created under this BackupPlan will be
      automatically deleted after its age reaches create_time +
      backup_retain_days. If not specified, Backups created under this
      BackupPlan will NOT be subject to automatic deletion. Updating this
      field does NOT affect existing Backups under it. Backups created AFTER a
      successful update will automatically pick up the new value. NOTE:
      Specifying a backup_retain_days smaller than backup_delete_lock_days at
      creation/updating time will be considered as invalid, and the request
      will be rejected immediately.
    locked: A flag denotes that the retention policy of this BackupPlan is
      locked. If set to True, no further update is allowed on this policy,
      including the 'locked' field itself. Default to False.
  """

  backupDeleteLockDays = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  backupRetainDays = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  locked = _messages.BooleanField(3)


class Schedule(_messages.Message):
  r"""Schedule, an inner message type defines a cron schedule.

  Fields:
    cronSchedule: A cron style string schedule on which an operation will be
      executed.
    paused: A flag to toggle scheduled operation. If set to True, the
      scheduled operation will be inactive. Default to True.
  """

  cronSchedule = _messages.StringField(1)
  paused = _messages.BooleanField(2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class SubmitClusterConfigRequest(_messages.Message):
  r"""Request for submitting cluster configuration once an agent is done with
  uploading.

  Fields:
    podCount: Total number of pods backed up.
    resourceCount: Required. Total number of resources backed up.
  """

  podCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resourceCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class SubstitutionRule(_messages.Message):
  r"""substitution rule

  Fields:
    newValue: new_value specifies the desired value in string to substitute
      to. If unspecified, it is treated as empty string "". Empty string is a
      valid use case for removing existing value.
    originalValuePattern: original_value_pattern is a regex pattern string
      which will be used to match the JSON field value found from supplied
      "target_json_path". If the found field's value matches the regex
      pattern, the original value will be substituted with the specified
      "new_value". Otherwise, substitution will not happen. If this field is
      not specified, any fields found in this resources using
      "target_json_path" will be substituted with the specified "new_value".
      NOTE: empty string is a legit regex pattern, and will be treated the
      same as any other strings.
    targetGroupKinds: target_group_kinds, specifies a list of GroupKinds this
      substitution rule targets at. A to-be-restored resource MUST be one of
      the listed GroupKinds to be considered as a substitution candidate. If
      empty, all resources will be considered. Note that a resource MUST
      satisfy both the target_namespaces requirement AND the
      target_group_kinds requirement to be considered as a substitution
      candidate.
    targetJsonPath: Required. target_json_path is the string representation of
      a JSON Path which leads to the field(s) in the resource's JSON format
      for substitution. For example: "{..namespace}", "{$.metadata.name}". An
      invalid target_json_path will cause the system to ignore this
      substitution rule.
    targetNamespaces: target_namespaces, specifies a list of namespaces this
      substitution rule targets at. A to-be-restored resource MUST be in one
      of the listed namespaces originally to be considered as a substitution
      candidate. For non-namespaced resources, an empty string("") MUST be
      specified. If empty, all resources in any namespace(including non-
      namespaced) will be considered.
  """

  newValue = _messages.StringField(1)
  originalValuePattern = _messages.StringField(2)
  targetGroupKinds = _messages.MessageField('GroupKind', 3, repeated=True)
  targetJsonPath = _messages.StringField(4)
  targetNamespaces = _messages.StringField(5, repeated=True)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class VolumeBackup(_messages.Message):
  r"""Represent a VolumeBackup Resource as a part of a Backup. Next id: 14

  Enums:
    FormatValueValuesEnum: Required. Immutable. A volume backup format, like
      PD, Portable, etc.
    StateValueValuesEnum: Current state of the volume backup.

  Fields:
    completeTime: Output only. [Output Only] The timestamp when this
      VolumeBackup resource was completed in the text format of
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
    createTime: Output only. [Output Only] The timestamp when this
      VolumeBackup resource was created which can be converted to and from
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
    diskSizeBytes: The minimum size of the disk to which this volume backup
      can be restored.
    etag: Output only. `etag` is used for optimistic concurrency control as a
      way to help prevent simultaneous updates of a volume backup from
      overwriting each other. It is strongly suggested that systems make use
      of the `etag` in the read-modify-write cycle to perform volume backup
      updates in order to avoid race conditions: An `etag` is returned in the
      response to `GetVolumeBackup', and systems are expected to put that etag
      in the request to `UpdateVolumeBackup` to ensure that their change will
      be applied to the same version.
    format: Required. Immutable. A volume backup format, like PD, Portable,
      etc.
    name: Output only. Full name of the volume backup which should be unique
      within the Backup. The name will have a format:
      projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/* The last
      segment of the name will have a format: 'pvc-'.
    sourcePvc: Required. Immutable. The reference of the source PVC that the
      volume backup is taken from.
    state: Current state of the volume backup.
    stateMessage: A human readable message explaining why the VolumeBackup is
      in current state
    storageBytes: The size of the volume backup in the backup storage. For
      incremental backups this value may dynamically change if one of the
      previous volume backups was deleted.
    uid: Output only. [Output Only] Server generated global unique identifier
      of [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier)
      format.
    updateTime: Output only. [Output Only] The timestamp when this
      VolumeBackup resource was last updated which can be converted to and
      from [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
    volumeBackupHandle: An underlying volume backup handle, which uniquely
      identifies volume backup inside a volume backup repository. This handle
      doesn't have a unified format and is treated as an opaque string.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. A volume backup format, like PD, Portable, etc.

    Values:
      VOLUME_BACKUP_FORMAT_NOT_SPECIFIED: Default value, not specified.
      GCE_PERSISTENT_DISK: GCP persistent disk snapshot based volume backup.
    """
    VOLUME_BACKUP_FORMAT_NOT_SPECIFIED = 0
    GCE_PERSISTENT_DISK = 1

  class StateValueValuesEnum(_messages.Enum):
    r"""Current state of the volume backup.

    Values:
      VOLUME_BACKUP_STATE_NOT_SPECIFIED: Default value, not specified
      CREATING: A volume for the backup was identified and backup process is
        about to start.
      SNAPSHOTTING: A volume is being snapshotted.
      UPLOADING: A volume snapshot is being uploaded.
      SUCCEEDED: A volume backup ready.
      FAILED: A volume backup failed.
      DELETING: A volume backup is being deleted.
    """
    VOLUME_BACKUP_STATE_NOT_SPECIFIED = 0
    CREATING = 1
    SNAPSHOTTING = 2
    UPLOADING = 3
    SUCCEEDED = 4
    FAILED = 5
    DELETING = 6

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  diskSizeBytes = _messages.IntegerField(3)
  etag = _messages.StringField(4)
  format = _messages.EnumField('FormatValueValuesEnum', 5)
  name = _messages.StringField(6)
  sourcePvc = _messages.MessageField('NamespacedName', 7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  stateMessage = _messages.StringField(9)
  storageBytes = _messages.IntegerField(10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)
  volumeBackupHandle = _messages.StringField(13)


class VolumeRestore(_messages.Message):
  r"""Represents a state of a volume restoration from a backup. Next id: 11

  Enums:
    StateValueValuesEnum: Current state of the volume restoration.

  Fields:
    completeTime: Output only. [Output Only] The timestamp when this volume
      restore was completed in the text format of
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
    createTime: Output only. [Output Only] The timestamp when this volume
      restore was started in the text format of
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
    etag: Output only. `etag` is used for optimistic concurrency control as a
      way to help prevent simultaneous updates of a volume restore from
      overwriting each other. It is strongly suggested that systems make use
      of the `etag` in the read-modify-write cycle to perform volume restore
      updates in order to avoid race conditions: An `etag` is returned in the
      response to `GetVolumeRestore', and systems are expected to put that
      etag in the request to `UpdateVolumeRestore` to ensure that their change
      will be applied to the same version.
    name: Output only. Full name of the volume restore which should be unique
      within the Restore. The name will have a format:
      projects/*/locations/*/restores/*/volumeRestores/* The last segment of
      the name will have a format: 'pvc-'.
    state: Current state of the volume restoration.
    stateMessage: A human readable description of the current state.
    targetPvc: Immutable. The reference of the target PVC to be restored.
    uid: Output only. [Output Only] Server generated global unique identifier
      of [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier)
      format.
    updateTime: Output only. [Output Only] The timestamp when this volume
      restore was last updated in the text format of
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
    volumeBackup: Immutable. The full name of the volume backup from which the
      volume is being restored. Format:
      projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/*
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Current state of the volume restoration.

    Values:
      VOLUME_RESTORE_STATE_NOT_SPECIFIED: Default value, not specified
      CREATING: A volume for the restore was identified and restore process is
        about to start.
      RESTORING: A volume is being restored.
      SUCCEEDED: A volume has been restored.
      FAILED: A volume restoration failed.
      DELETING: A volume restoration is being deleted
    """
    VOLUME_RESTORE_STATE_NOT_SPECIFIED = 0
    CREATING = 1
    RESTORING = 2
    SUCCEEDED = 3
    FAILED = 4
    DELETING = 5

  completeTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  etag = _messages.StringField(3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  stateMessage = _messages.StringField(6)
  targetPvc = _messages.MessageField('NamespacedName', 7)
  uid = _messages.StringField(8)
  updateTime = _messages.StringField(9)
  volumeBackup = _messages.StringField(10)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
