/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Binding;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Return;
import org.armedbear.lisp.SpecialBinding;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.SpecialOperator;
import org.armedbear.lisp.Symbol;

public final class dolist
extends SpecialOperator {
    private static final dolist DOLIST = new dolist();

    private dolist() {
        super(Symbol.DOLIST);
    }

    @Override
    public LispObject execute(LispObject args, Environment env) {
        LispObject bodyForm = args.cdr();
        args = args.car();
        Symbol var = Lisp.checkSymbol(args.car());
        LispObject listForm = args.cadr();
        LispThread thread = LispThread.currentThread();
        LispObject resultForm = args.cdr().cdr().car();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        LispObject bodyAndDecls = Lisp.parseBody(bodyForm, false);
        LispObject specials = Lisp.parseSpecials(bodyAndDecls.NTH(1));
        bodyForm = bodyAndDecls.car();
        LispObject blockId = new LispObject();
        Environment ext = new Environment(env);
        try {
            LispObject result;
            Object binding;
            ext.addBlock(Lisp.NIL, blockId);
            LispObject list = Lisp.checkList(Lisp.eval(listForm, ext, thread));
            LispObject remaining = bodyForm;
            LispObject localTags = Lisp.preprocessTagBody(bodyForm, ext);
            if (specials != Lisp.NIL && Lisp.memq(var, specials)) {
                thread.bindSpecial(var, null);
                binding = thread.getSpecialBinding(var);
                ext.declareSpecial(var);
            } else if (var.isSpecialVariable()) {
                thread.bindSpecial(var, null);
                binding = thread.getSpecialBinding(var);
            } else {
                ext.bind(var, null);
                binding = ext.getBinding(var);
            }
            while (specials != Lisp.NIL) {
                ext.declareSpecial(Lisp.checkSymbol(specials.car()));
                specials = specials.cdr();
            }
            while (list != Lisp.NIL) {
                if (binding instanceof SpecialBinding) {
                    ((SpecialBinding)binding).value = list.car();
                } else {
                    ((Binding)binding).value = list.car();
                }
                Lisp.processTagBody(bodyForm, localTags, ext);
                list = list.cdr();
                if (!Lisp.interrupted) continue;
                Lisp.handleInterrupt();
            }
            if (binding instanceof SpecialBinding) {
                ((SpecialBinding)binding).value = Lisp.NIL;
            } else {
                ((Binding)binding).value = Lisp.NIL;
            }
            LispObject lispObject = result = Lisp.eval(resultForm, ext, thread);
            return lispObject;
        }
        catch (Return ret) {
            if (ret.getBlock() == blockId) {
                LispObject lispObject = ret.getResult();
                return lispObject;
            }
            throw ret;
        }
        finally {
            thread.resetSpecialBindings(mark);
            ext.inactive = true;
        }
    }
}

