/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.actions;

import com.almworks.tracker.eapi.alpha.TrackerConnector;
import com.almworks.tracklink.IssueLink;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.popup.ArtifactInfoDialogWrapper;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

public class ShowArtifactInfoAction
extends AnAction {
    public void update(AnActionEvent e) {
        int required;
        int modifiers;
        DataContext dataContext = e.getDataContext();
        TrackerConnector connector = null;
        IssueLink issueLink = null;
        connector = Utils.getConnector(dataContext);
        boolean lookAtDashboard = false;
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof KeyEvent && ((modifiers = inputEvent.getModifiersEx()) & (required = 704)) == required) {
            lookAtDashboard = true;
        }
        issueLink = Utils.getIssueLink(dataContext, lookAtDashboard);
        e.getPresentation().setEnabled(issueLink != null && connector != null);
        e.getPresentation().setVisible(issueLink != null && connector != null);
    }

    public void actionPerformed(AnActionEvent e) {
        String filter;
        DataContext dataContext = e.getDataContext();
        Project project = (Project)DataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        boolean lookAtDashboard = e.getInputEvent() instanceof KeyEvent;
        IssueLink issueLink = Utils.getIssueLink(dataContext, lookAtDashboard);
        ArtifactInfoCache cache = Utils.getArtifactInfoCache();
        Component component = (Component)DataKeys.CONTEXT_COMPONENT.getData(dataContext);
        Editor editor = (Editor)DataKeys.EDITOR.getData(dataContext);
        Object filterObject = dataContext.getData("FiltrationString");
        String string = filter = filterObject != null ? (String)filterObject : "";
        if (component != null && cache != null && issueLink != null) {
            Point point = editor != null ? Utils.getCaretScreenPoint(editor) : null;
            String url = issueLink.getURL();
            ArtifactInfoDialogWrapper artifactInfoDialogWrapper = new ArtifactInfoDialogWrapper(component, cache, url, project, filter);
            if (point != null) {
                artifactInfoDialogWrapper.setLocation(point);
            }
            artifactInfoDialogWrapper.show();
        }
    }
}

