/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;

public class NewUnitPanel
extends FreeColPanel {
    private final JLabel question;
    private final List<JButton> buttons = new ArrayList<JButton>();
    private final List<UnitType> units = new ArrayList<UnitType>();
    private final Comparator<UnitType> priceComparator;
    private boolean shouldEnable = false;

    public NewUnitPanel(FreeColClient freeColClient, LayoutManager layout, String label, List<UnitType> units) {
        super(freeColClient, layout);
        this.question = new JLabel(label);
        this.units.addAll(units);
        Europe europe = this.getMyPlayer().getEurope();
        this.priceComparator = Comparator.comparingInt(ut -> europe.getUnitPrice((UnitType)ut));
        this.okButton.setText(Messages.message("close"));
        this.update();
    }

    public final void update() {
        this.removeAll();
        Player player = this.getMyPlayer();
        Europe europe = player.getEurope();
        this.add((Component)this.question, "span, wrap 20");
        Collections.sort(this.units, this.priceComparator);
        this.buttons.clear();
        for (UnitType ut : this.units) {
            int price = europe.getUnitPrice(ut);
            boolean enable = player.checkGold(price);
            JButton newButton = new JButton();
            newButton.setLayout(new MigLayout("wrap 2", "[60]", "[30][30]"));
            ImageIcon icon = new ImageIcon(this.getImageLibrary().getSmallUnitImage(ut, !enable));
            JLabel name = Utility.localizedLabel(ut);
            name.setEnabled(enable);
            JLabel gold = Utility.localizedLabel(StringTemplate.template("goldAmount").addAmount("%amount%", price));
            gold.setEnabled(enable);
            newButton.setEnabled(enable);
            newButton.add((Component)new JLabel(icon), "span 1 2");
            newButton.add(name);
            newButton.add(gold);
            newButton.setActionCommand(ut.getId());
            newButton.addActionListener(this);
            this.buttons.add(newButton);
            this.add((Component)newButton, "grow");
        }
        this.add((Component)this.okButton, "newline 20, span, tag ok");
        this.setSize(this.getPreferredSize());
        this.revalidate();
        this.shouldEnable = player.checkGold(europe.getUnitPrice(this.units.get(0)));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if ("OK".equals(command)) {
            super.actionPerformed(ae);
        } else {
            UnitType unitType = this.getSpecification().getUnitType(command);
            this.igc().trainUnitInEurope(unitType);
            this.getGUI().updateEuropeanSubpanels();
            if (!this.shouldEnable) {
                this.getGUI().removeFromCanvas(this);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        for (JButton jb : this.buttons) {
            if (jb == null) continue;
            jb.setLayout(null);
        }
        this.buttons.clear();
    }
}

