/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericForLoopHeader$WhenMappings;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContextInterface;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0014\u0010\u001f\u001a\u00020\u0015*\u00020\u00062\u0006\u0010 \u001a\u00020\u0015H\u0002R\u0014\u0010\n\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\fR\u0016\u0010\u0014\u001a\u00020\u00158DX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/NumericForLoopHeader;", "T", "Lorg/jetbrains/kotlin/backend/common/lower/loops/NumericHeaderInfo;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "headerInfo", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "isLastInclusive", "", "(Lorg/jetbrains/kotlin/backend/common/lower/loops/NumericHeaderInfo;Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;Z)V", "consumesLoopVariableComponents", "getConsumesLoopVariableComponents", "()Z", "getHeaderInfo", "()Lorg/jetbrains/kotlin/backend/common/lower/loops/NumericHeaderInfo;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/NumericHeaderInfo;", "inductionVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getInductionVariable", "()Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "lastExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getLastExpression", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "lastVariableIfCanCacheLast", "getLastVariableIfCanCacheLast", "stepVariable", "getStepVariable", "buildLoopCondition", "incrementInductionVariable", "Lorg/jetbrains/kotlin/ir/IrStatement;", "ensureNotNullable", "expression", "ir.backend.common"})
public abstract class NumericForLoopHeader<T extends NumericHeaderInfo>
implements ForLoopHeader {
    private final boolean consumesLoopVariableComponents = false;
    @NotNull
    private final IrVariable inductionVariable;
    @NotNull
    private final IrVariable stepVariable;
    @Nullable
    private final IrVariable lastVariableIfCanCacheLast;
    @NotNull
    private final IrExpression lastExpression;
    @NotNull
    private final T headerInfo;
    private final boolean isLastInclusive;

    @Override
    public boolean getConsumesLoopVariableComponents() {
        return this.consumesLoopVariableComponents;
    }

    @NotNull
    public final IrVariable getInductionVariable() {
        return this.inductionVariable;
    }

    @NotNull
    public final IrVariable getStepVariable() {
        return this.stepVariable;
    }

    @Nullable
    protected final IrVariable getLastVariableIfCanCacheLast() {
        return this.lastVariableIfCanCacheLast;
    }

    @NotNull
    protected final IrExpression getLastExpression() {
        IrElement $this$deepCopyWithSymbols$iv = this.lastExpression;
        IrDeclarationParent initialParent$iv = null;
        boolean $i$f$deepCopyWithSymbols = false;
        DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
        IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols$iv, symbolRemapper$iv);
        DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
        IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents($this$deepCopyWithSymbols$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv, typeRemapper$iv, null, 4, null), null), initialParent$iv);
        if (irElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        }
        return (IrExpression)((IrElement)((IrExpression)irElement));
    }

    private final IrExpression ensureNotNullable(@NotNull DeclarationIrBuilder $this$ensureNotNullable, IrExpression expression2) {
        return expression2.getType() instanceof IrSimpleType && IrTypeUtilsKt.isNullable(expression2.getType()) ? (IrExpression)ExpressionHelpersKt.irImplicitCast($this$ensureNotNullable, expression2, IrTypesKt.makeNotNull(expression2.getType())) : expression2;
    }

    @NotNull
    protected final IrStatement incrementInductionVariable(@NotNull DeclarationIrBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$with = builder;
        boolean bl3 = false;
        IrClass irClass = IrTypesKt.getClass(this.inductionVariable.getType());
        if (irClass == null) {
            Intrinsics.throwNpe();
        }
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl4 = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.PLUS) && it.getValueParameters().size() == 1 && Intrinsics.areEqual((Object)it.getValueParameters().get(0).getType(), (Object)this.stepVariable.getType()))) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction plusFun = single$iv;
        return ExpressionHelpersKt.irSetVar($this$with, (IrVariableSymbol)this.inductionVariable.getSymbol(), ExpressionHelpersKt.irCallOp($this$with, plusFun.getSymbol(), plusFun.getReturnType(), ExpressionHelpersKt.irGet($this$with, this.inductionVariable), ExpressionHelpersKt.irGet($this$with, this.stepVariable)));
    }

    @NotNull
    protected final IrExpression buildLoopCondition(@NotNull DeclarationIrBuilder builder) {
        IrExpression irExpression;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$with = builder;
        boolean bl3 = false;
        IrBuiltIns builtIns = $this$with.getContext().getIrBuiltIns();
        ProgressionType progressionType = ((NumericHeaderInfo)this.headerInfo).getProgressionType();
        IrType progressionElementType = progressionType.elementType(builtIns);
        if (this.isLastInclusive) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = builtIns.getLessOrEqualFunByOperandType().get(IrTypesKt.getClassifierOrFail(progressionElementType));
            if (irSimpleFunctionSymbol2 == null) {
                Intrinsics.throwNpe();
            }
            irSimpleFunctionSymbol = irSimpleFunctionSymbol2;
        } else {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = builtIns.getLessFunByOperandType().get(IrTypesKt.getClassifierOrFail(progressionElementType));
            if (irSimpleFunctionSymbol3 == null) {
                Intrinsics.throwNpe();
            }
            irSimpleFunctionSymbol = irSimpleFunctionSymbol3;
        }
        IrSimpleFunctionSymbol compFun = irSimpleFunctionSymbol;
        switch (NumericForLoopHeader$WhenMappings.$EnumSwitchMapping$0[((NumericHeaderInfo)this.headerInfo).getDirection().ordinal()]) {
            case 1: {
                IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$with, compFun);
                boolean bl4 = false;
                boolean bl5 = false;
                IrCall $this$apply = irCall;
                boolean bl6 = false;
                $this$apply.putValueArgument(0, this.getLastExpression());
                $this$apply.putValueArgument(1, ExpressionHelpersKt.irGet($this$with, this.inductionVariable));
                irExpression = irCall;
                break;
            }
            case 2: {
                IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$with, compFun);
                boolean bl7 = false;
                boolean bl8 = false;
                IrCall $this$apply = irCall;
                boolean bl9 = false;
                $this$apply.putValueArgument(0, ExpressionHelpersKt.irGet($this$with, this.inductionVariable));
                $this$apply.putValueArgument(1, this.getLastExpression());
                irExpression = irCall;
                break;
            }
            case 3: {
                IrType stepType = progressionType.stepType(builtIns);
                boolean isLong = progressionType == ProgressionType.LONG_PROGRESSION;
                IrGeneratorContextInterface irGeneratorContextInterface = $this$with.getContext();
                IrGeneratorContextInterface irGeneratorContextInterface2 = $this$with.getContext();
                IrBuilderWithScope irBuilderWithScope = $this$with;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol4 = builtIns.getGreaterFunByOperandType().get(IrTypesKt.getClassifierOrFail(stepType));
                if (irSimpleFunctionSymbol4 == null) {
                    Intrinsics.throwNpe();
                }
                IrCall irCall = ExpressionHelpersKt.irCall(irBuilderWithScope, irSimpleFunctionSymbol4);
                Object object = irGeneratorContextInterface2;
                IrGeneratorContextInterface irGeneratorContextInterface3 = irGeneratorContextInterface;
                boolean bl10 = false;
                boolean bl11 = false;
                IrCall $this$apply = irCall;
                boolean bl12 = false;
                $this$apply.putValueArgument(0, ExpressionHelpersKt.irGet($this$with, this.stepVariable));
                $this$apply.putValueArgument(1, isLong ? ExpressionHelpersKt.irLong($this$with, 0L) : (IrExpression)ExpressionHelpersKt.irInt($this$with, 0));
                Object object2 = irCall;
                irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$with, compFun);
                object2 = (IrExpression)object2;
                bl10 = false;
                bl11 = false;
                $this$apply = irCall;
                boolean bl13 = false;
                $this$apply.putValueArgument(0, ExpressionHelpersKt.irGet($this$with, this.inductionVariable));
                $this$apply.putValueArgument(1, this.getLastExpression());
                IrExpression irExpression2 = irCall;
                IrExpression irExpression3 = PrimitivesKt.andand$default((IrGeneratorContextInterface)object, (IrExpression)object2, irExpression2, null, 4, null);
                IrGeneratorContextInterface irGeneratorContextInterface4 = $this$with.getContext();
                IrBuilderWithScope irBuilderWithScope2 = $this$with;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol5 = builtIns.getLessFunByOperandType().get(IrTypesKt.getClassifierOrFail(stepType));
                if (irSimpleFunctionSymbol5 == null) {
                    Intrinsics.throwNpe();
                }
                irCall = ExpressionHelpersKt.irCall(irBuilderWithScope2, irSimpleFunctionSymbol5);
                object2 = irGeneratorContextInterface4;
                object = irExpression3;
                bl10 = false;
                bl11 = false;
                $this$apply = irCall;
                boolean bl14 = false;
                $this$apply.putValueArgument(0, ExpressionHelpersKt.irGet($this$with, this.stepVariable));
                $this$apply.putValueArgument(1, isLong ? ExpressionHelpersKt.irLong($this$with, 0L) : (IrExpression)ExpressionHelpersKt.irInt($this$with, 0));
                irExpression2 = irCall;
                irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$with, compFun);
                irExpression2 = irExpression2;
                bl10 = false;
                bl11 = false;
                $this$apply = irCall;
                boolean bl15 = false;
                $this$apply.putValueArgument(0, this.getLastExpression());
                $this$apply.putValueArgument(1, ExpressionHelpersKt.irGet($this$with, this.inductionVariable));
                IrCall irCall2 = irCall;
                irExpression = PrimitivesKt.oror$default(irGeneratorContextInterface3, (IrExpression)object, PrimitivesKt.andand$default((IrGeneratorContextInterface)object2, irExpression2, irCall2, null, 4, null), null, 4, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irExpression;
    }

    @NotNull
    protected final T getHeaderInfo() {
        return this.headerInfo;
    }

    protected final boolean isLastInclusive() {
        return this.isLastInclusive;
    }

    public NumericForLoopHeader(@NotNull T headerInfo, @NotNull DeclarationIrBuilder builder, boolean isLastInclusive) {
        IrVariable irVariable2;
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull(headerInfo, (String)"headerInfo");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.headerInfo = headerInfo;
        this.isLastInclusive = isLastInclusive;
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$with = builder;
        boolean bl3 = false;
        this.inductionVariable = Scope.createTemporaryVariable$default($this$with.getScope(), UtilsKt.castIfNecessary(((NumericHeaderInfo)this.headerInfo).getFirst(), ((NumericHeaderInfo)this.headerInfo).getProgressionType().elementType($this$with.getContext().getIrBuiltIns()), ((NumericHeaderInfo)this.headerInfo).getProgressionType().getElementCastFunctionName()), "inductionVariable", true, null, null, null, 56, null);
        IrExpression last2 = this.ensureNotNullable($this$with, UtilsKt.castIfNecessary(((NumericHeaderInfo)this.headerInfo).getLast(), ((NumericHeaderInfo)this.headerInfo).getProgressionType().elementType($this$with.getContext().getIrBuiltIns()), ((NumericHeaderInfo)this.headerInfo).getProgressionType().getElementCastFunctionName()));
        IrVariable irVariable3 = this.lastVariableIfCanCacheLast = ((NumericHeaderInfo)this.headerInfo).getCanCacheLast() ? Scope.createTemporaryVariable$default($this$with.getScope(), last2, "last", false, null, null, null, 60, null) : null;
        if (((NumericHeaderInfo)this.headerInfo).getCanCacheLast()) {
            IrBuilderWithScope irBuilderWithScope = $this$with;
            IrVariable irVariable4 = this.lastVariableIfCanCacheLast;
            if (irVariable4 == null) {
                Intrinsics.throwNpe();
            }
            irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope, irVariable4);
        } else {
            irExpression = last2;
        }
        this.lastExpression = irExpression;
        IrType irType = ((NumericHeaderInfo)this.headerInfo).getProgressionType().stepType($this$with.getContext().getIrBuiltIns());
        NumericForLoopHeader numericForLoopHeader = this;
        boolean bl4 = false;
        boolean bl5 = false;
        IrType it = irType;
        boolean bl6 = false;
        numericForLoopHeader.stepVariable = irVariable2 = Scope.createTemporaryVariable$default($this$with.getScope(), this.ensureNotNullable($this$with, UtilsKt.castIfNecessary(((NumericHeaderInfo)this.headerInfo).getStep(), it, ((NumericHeaderInfo)this.headerInfo).getProgressionType().getStepCastFunctionName())), "step", false, null, null, it, 28, null);
    }
}

