/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar;

import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;

public class CoreJarFileSystem
extends DeprecatedVirtualFileSystem {
    private final Map<String, CoreJarHandler> myHandlers = ConcurrentFactoryMap.createMap(key -> new CoreJarHandler(this, (String)key));

    @Override
    @NotNull
    public String getProtocol() {
        return "jar";
    }

    @Override
    public VirtualFile findFileByPath(@NotNull @NonNls String path2) {
        if (path2 == null) {
            CoreJarFileSystem.$$$reportNull$$$0(0);
        }
        Couple<String> pair = this.splitPath(path2);
        return this.myHandlers.get(pair.first).findFileByPath((String)pair.second);
    }

    @NotNull
    protected Couple<String> splitPath(@NotNull String path2) {
        int separator;
        if (path2 == null) {
            CoreJarFileSystem.$$$reportNull$$$0(1);
        }
        if ((separator = path2.indexOf("!/")) < 0) {
            throw new IllegalArgumentException("Path in JarFileSystem must contain a separator: " + path2);
        }
        String localPath = path2.substring(0, separator);
        String pathInJar = path2.substring(separator + 2);
        Couple<String> couple = Couple.of(localPath, pathInJar);
        if (couple == null) {
            CoreJarFileSystem.$$$reportNull$$$0(2);
        }
        return couple;
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
        if (path2 == null) {
            CoreJarFileSystem.$$$reportNull$$$0(3);
        }
        return this.findFileByPath(path2);
    }

    public void clearHandlersCache() {
        this.myHandlers.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

