/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorWithRelation;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(JO\u0010)\u001a\u00020$\"\b\b\u0000\u0010**\u00020+2\u001e\u0010,\u001a\u001a\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020.0-2\u0006\u00100\u001a\u0002H*2\u0006\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020/H\u0002\u00a2\u0006\u0002\u00103R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "checkClassHeader", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkDeclarationWithVisibility", "modifierListOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkMemberReceiver", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkParameterBounds", "checkProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkSupertypes", "checkTypeAlias", "", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "reportExposure", "E", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;", "element", "elementVisibility", "restrictingDescriptor", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;)V", "frontend"})
public final class ExposedVisibilityChecker {
    private final BindingTrace trace;

    private final <E extends PsiElement> void reportExposure(DiagnosticFactory3<E, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnostic, E element, EffectiveVisibility elementVisibility, DescriptorWithRelation restrictingDescriptor) {
        block0: {
            BindingTrace bindingTrace = this.trace;
            if (bindingTrace == null) break block0;
            bindingTrace.report(diagnostic.on(element, elementVisibility, restrictingDescriptor, restrictingDescriptor.effectiveVisibility()));
        }
    }

    public final boolean checkClassHeader(@NotNull KtClassOrObject klass2, @NotNull ClassDescriptor classDescriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
        boolean result2 = this.checkSupertypes(klass2, classDescriptor2);
        result2 &= this.checkParameterBounds(klass2, classDescriptor2);
        KtPrimaryConstructor ktPrimaryConstructor = klass2.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return result2;
        }
        KtPrimaryConstructor constructor = ktPrimaryConstructor;
        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor2.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return result2;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor, (String)"classDescriptor.unsubsti\u2026structor ?: return result");
        ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
        return result2 & ExposedVisibilityChecker.checkFunction$default(this, constructor, constructorDescriptor, null, 4, null);
    }

    public final boolean checkDeclarationWithVisibility(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull Visibility visibility) {
        Intrinsics.checkParameterIsNotNull((Object)modifierListOwner, (String)"modifierListOwner");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)visibility, (String)"visibility");
        return modifierListOwner instanceof KtFunction && descriptor2 instanceof FunctionDescriptor ? this.checkFunction((KtFunction)modifierListOwner, (FunctionDescriptor)descriptor2, visibility) : (modifierListOwner instanceof KtProperty && descriptor2 instanceof PropertyDescriptor ? this.checkProperty((KtProperty)modifierListOwner, (PropertyDescriptor)descriptor2, visibility) : true);
    }

    public final void checkTypeAlias(@NotNull KtTypeAlias typeAlias, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)typeAlias, (String)"typeAlias");
        Intrinsics.checkParameterIsNotNull((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
        SimpleType expandedType2 = typeAliasDescriptor.getExpandedType();
        if (KotlinTypeKt.isError(expandedType2)) {
            return;
        }
        EffectiveVisibility typeAliasVisibility = EffectiveVisibilityKt.effectiveVisibility$default(typeAliasDescriptor, null, false, 3, null);
        DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(expandedType2, typeAliasVisibility);
        if (restricting != null) {
            DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_TYPEALIAS_EXPANDED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory3, (String)"EXPOSED_TYPEALIAS_EXPANDED_TYPE");
            PsiElement psiElement = typeAlias.getNameIdentifier();
            if (psiElement == null) {
                psiElement = typeAlias;
            }
            this.reportExposure(diagnosticFactory3, psiElement, typeAliasVisibility, restricting);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkFunction(@NotNull KtFunction function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull Visibility visibility) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)visibility, (String)"visibility");
        EffectiveVisibility functionVisibility = EffectiveVisibilityKt.effectiveVisibility$default(functionDescriptor, visibility, false, 2, null);
        boolean result2 = true;
        if (!(function2 instanceof KtConstructor)) {
            DescriptorWithRelation restricting;
            KotlinType kotlinType = functionDescriptor.getReturnType();
            DescriptorWithRelation descriptorWithRelation = restricting = kotlinType != null ? EffectiveVisibilityKt.leastPermissiveDescriptor(kotlinType, functionVisibility) : null;
            if (restricting != null) {
                DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_FUNCTION_RETURN_TYPE;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory3, (String)"EXPOSED_FUNCTION_RETURN_TYPE");
                PsiElement psiElement = function2.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = function2;
                }
                this.reportExposure(diagnosticFactory3, psiElement, functionVisibility, restricting);
                result2 = false;
            }
        }
        List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"functionDescriptor.valueParameters");
        Iterable $this$forEachIndexed$iv = list2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameterDescriptor;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            int i = n2;
            boolean bl2 = false;
            if (i >= function2.getValueParameters().size()) continue;
            KtParameter valueParameter = function2.getValueParameters().get(i);
            void v5 = parameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"parameterDescriptor");
            KotlinType kotlinType = v5.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameterDescriptor.type");
            DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(kotlinType, functionVisibility);
            if (restricting != null) {
                DiagnosticFactory3<KtParameter, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_PARAMETER_TYPE;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory3, (String)"EXPOSED_PARAMETER_TYPE");
                this.reportExposure(diagnosticFactory3, (PsiElement)valueParameter, functionVisibility, restricting);
                result2 = false;
                continue;
            }
            if (!(functionDescriptor instanceof ClassConstructorDescriptor) || !valueParameter.hasValOrVar()) continue;
            BindingTrace bindingTrace = this.trace;
            PropertyDescriptor propertyDescriptor = bindingTrace != null ? (PropertyDescriptor)bindingTrace.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor) : null;
            Substitutable<CallableDescriptor> substitutable = propertyDescriptor;
            if (substitutable == null) {
                ClassDescriptor classDescriptor2 = ((ClassConstructorDescriptor)functionDescriptor).getConstructedClass();
                substitutable = classDescriptor2;
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"functionDescriptor.constructedClass");
            }
            EffectiveVisibility propertyOrClassVisibility = EffectiveVisibilityKt.effectiveVisibility$default(substitutable, null, false, 3, null);
            KotlinType kotlinType2 = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"parameterDescriptor.type");
            DescriptorWithRelation restrictingByProperty = EffectiveVisibilityKt.leastPermissiveDescriptor(kotlinType2, propertyOrClassVisibility);
            if (restrictingByProperty == null) continue;
            DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory3, (String)"EXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR");
            this.reportExposure(diagnosticFactory3, (PsiElement)valueParameter, propertyOrClassVisibility, restrictingByProperty);
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(function2.getReceiverTypeReference(), functionDescriptor);
    }

    public static /* synthetic */ boolean checkFunction$default(ExposedVisibilityChecker exposedVisibilityChecker, KtFunction ktFunction, FunctionDescriptor functionDescriptor, Visibility visibility, int n, Object object) {
        if ((n & 4) != 0) {
            Visibility visibility2 = functionDescriptor.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility2, (String)"functionDescriptor.visibility");
            visibility = visibility2;
        }
        return exposedVisibilityChecker.checkFunction(ktFunction, functionDescriptor, visibility);
    }

    public final boolean checkProperty(@NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull Visibility visibility) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)propertyDescriptor, (String)"propertyDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)visibility, (String)"visibility");
        EffectiveVisibility propertyVisibility = EffectiveVisibilityKt.effectiveVisibility$default(propertyDescriptor, visibility, false, 2, null);
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"propertyDescriptor.type");
        DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(kotlinType, propertyVisibility);
        boolean result2 = true;
        if (restricting != null) {
            DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_PROPERTY_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory3, (String)"EXPOSED_PROPERTY_TYPE");
            PsiElement psiElement = property.getNameIdentifier();
            if (psiElement == null) {
                psiElement = property;
            }
            this.reportExposure(diagnosticFactory3, psiElement, propertyVisibility, restricting);
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(property.getReceiverTypeReference(), propertyDescriptor);
    }

    public static /* synthetic */ boolean checkProperty$default(ExposedVisibilityChecker exposedVisibilityChecker, KtProperty ktProperty, PropertyDescriptor propertyDescriptor, Visibility visibility, int n, Object object) {
        if ((n & 4) != 0) {
            Visibility visibility2 = propertyDescriptor.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility2, (String)"propertyDescriptor.visibility");
            visibility = visibility2;
        }
        return exposedVisibilityChecker.checkProperty(ktProperty, propertyDescriptor, visibility);
    }

    private final boolean checkMemberReceiver(KtTypeReference typeReference, CallableMemberDescriptor memberDescriptor) {
        if (typeReference == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = memberDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return true;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"memberDescriptor.extensi\u2026rParameter ?: return true");
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        EffectiveVisibility memberVisibility = EffectiveVisibilityKt.effectiveVisibility$default(memberDescriptor, null, false, 3, null);
        KotlinType kotlinType = receiverParameterDescriptor2.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverParameterDescriptor.type");
        DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(kotlinType, memberVisibility);
        if (restricting != null) {
            DiagnosticFactory3<KtTypeReference, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_RECEIVER_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory3, (String)"EXPOSED_RECEIVER_TYPE");
            this.reportExposure(diagnosticFactory3, (PsiElement)typeReference, memberVisibility, restricting);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSupertypes(KtClassOrObject klass2, ClassDescriptor classDescriptor2) {
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility$default(classDescriptor2, false, 1, null);
        boolean isInterface = classDescriptor2.getKind() == ClassKind.INTERFACE;
        List<KtSuperTypeListEntry> delegationList = klass2.getSuperTypeListEntries();
        boolean result2 = true;
        TypeConstructor typeConstructor2 = classDescriptor2.getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"classDescriptor.typeConstructor");
        Collection<KotlinType> collection = typeConstructor2.getSupertypes();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"classDescriptor.typeConstructor.supertypes");
        Iterable $this$forEachIndexed$iv = collection;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            boolean superIsInterface;
            ClassDescriptor superDescriptor;
            void superType;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            KotlinType kotlinType = (KotlinType)item$iv;
            int i = n2;
            boolean bl2 = false;
            if (i >= delegationList.size()) {
                return result2;
            }
            if (TypeUtils.getClassDescriptor((KotlinType)superType) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)superDescriptor, (String)"TypeUtils.getClassDescri\u2026 ?: return@forEachIndexed");
            boolean bl3 = superIsInterface = superDescriptor.getKind() == ClassKind.INTERFACE;
            if (superIsInterface != isInterface) continue;
            void v3 = superType;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"superType");
            DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor((KotlinType)v3, classVisibility);
            if (restricting == null) continue;
            DiagnosticFactory3<KtSuperTypeListEntry, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = isInterface ? Errors.EXPOSED_SUPER_INTERFACE : Errors.EXPOSED_SUPER_CLASS;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory3, (String)"if (isInterface) EXPOSED\u2026 else EXPOSED_SUPER_CLASS");
            this.reportExposure(diagnosticFactory3, (PsiElement)delegationList.get(i), classVisibility, restricting);
            result2 = false;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkParameterBounds(KtClassOrObject klass2, ClassDescriptor classDescriptor2) {
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility$default(classDescriptor2, false, 1, null);
        List<KtTypeParameter> list2 = klass2.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"klass.typeParameters");
        List<KtTypeParameter> typeParameterList = list2;
        boolean result2 = true;
        List<TypeParameterDescriptor> list3 = classDescriptor2.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"classDescriptor.declaredTypeParameters");
        Iterable $this$forEachIndexed$iv = list3;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        block0: for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameterDescriptor;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            int i = n2;
            boolean bl2 = false;
            if (i >= typeParameterList.size()) {
                return result2;
            }
            void v2 = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"typeParameterDescriptor");
            Iterator<KotlinType> iterator2 = v2.getUpperBounds().iterator();
            while (iterator2.hasNext()) {
                KotlinType upperBound;
                KotlinType kotlinType = upperBound = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"upperBound");
                DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(kotlinType, classVisibility);
                if (restricting == null) continue;
                DiagnosticFactory3<KtTypeParameter, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_TYPE_PARAMETER_BOUND;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory3, (String)"EXPOSED_TYPE_PARAMETER_BOUND");
                this.reportExposure(diagnosticFactory3, (PsiElement)typeParameterList.get(i), classVisibility, restricting);
                result2 = false;
                continue block0;
            }
        }
        return result2;
    }

    public ExposedVisibilityChecker(@Nullable BindingTrace trace) {
        this.trace = trace;
    }

    public /* synthetic */ ExposedVisibilityChecker(BindingTrace bindingTrace, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bindingTrace = null;
        }
        this(bindingTrace);
    }

    public ExposedVisibilityChecker() {
        this(null, 1, null);
    }
}

