/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.publish;

import java.io.File;
import java.util.Date;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.PublishArtifactInternal;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.util.GUtil;

public class DecoratingPublishArtifact
extends AbstractPublishArtifact
implements ConfigurablePublishArtifact {
    private String name;
    private String extension;
    private String type;
    private String classifier;
    private final PublishArtifact publishArtifact;
    private boolean classifierSet;

    public DecoratingPublishArtifact(PublishArtifact publishArtifact) {
        super(publishArtifact.getBuildDependencies());
        this.publishArtifact = publishArtifact;
    }

    public PublishArtifact getPublishArtifact() {
        return this.publishArtifact;
    }

    @Override
    public DecoratingPublishArtifact builtBy(Object ... tasks) {
        super.builtBy(tasks);
        return this;
    }

    public String getName() {
        return (String)GUtil.elvis((Object)this.name, (Object)this.publishArtifact.getName());
    }

    public String getExtension() {
        return (String)GUtil.elvis((Object)this.extension, (Object)this.publishArtifact.getExtension());
    }

    public String getType() {
        return (String)GUtil.elvis((Object)this.type, (Object)this.publishArtifact.getType());
    }

    public String getClassifier() {
        if (this.classifierSet) {
            return this.classifier;
        }
        return this.publishArtifact.getClassifier();
    }

    public File getFile() {
        return this.publishArtifact.getFile();
    }

    public Date getDate() {
        return this.publishArtifact.getDate();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
        this.classifierSet = true;
    }

    public boolean shouldBePublished() {
        if (this.publishArtifact instanceof PublishArtifactInternal) {
            return ((PublishArtifactInternal)this.publishArtifact).shouldBePublished();
        }
        return true;
    }
}

