/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.invocation;

import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.GradleLauncher;
import org.gradle.internal.Factory;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.work.WorkerLeaseService;

public class GradleBuildController
implements BuildController {
    private State state = State.Created;
    private final GradleLauncher gradleLauncher;
    private final WorkerLeaseService workerLeaseService;

    public GradleBuildController(GradleLauncher gradleLauncher, WorkerLeaseService workerLeaseService) {
        this.gradleLauncher = gradleLauncher;
        this.workerLeaseService = workerLeaseService;
    }

    public GradleBuildController(GradleLauncher gradleLauncher) {
        this(gradleLauncher, (WorkerLeaseService)gradleLauncher.getGradle().getServices().get(WorkerLeaseService.class));
    }

    public GradleLauncher getLauncher() {
        if (this.state == State.Completed) {
            throw new IllegalStateException("Cannot use launcher after build has completed.");
        }
        return this.gradleLauncher;
    }

    @Override
    public GradleInternal getGradle() {
        return this.getLauncher().getGradle();
    }

    @Override
    public GradleInternal run() {
        return this.doBuild((Action<? super GradleLauncher>)((Action)GradleLauncher::executeTasks));
    }

    @Override
    public GradleInternal configure() {
        return this.doBuild((Action<? super GradleLauncher>)((Action)GradleLauncher::getConfiguredBuild));
    }

    private GradleInternal doBuild(final Action<? super GradleLauncher> build) {
        try {
            GradleInternal gradleInternal = (GradleInternal)this.workerLeaseService.withLocks(Collections.singleton(this.workerLeaseService.getWorkerLease()), (Factory)new Factory<GradleInternal>(){

                public GradleInternal create() {
                    GradleInternal gradle = GradleBuildController.this.getGradle();
                    GradleLauncher launcher = GradleBuildController.this.getLauncher();
                    build.execute((Object)launcher);
                    launcher.finishBuild();
                    return gradle;
                }
            });
            return gradleInternal;
        }
        finally {
            this.state = State.Completed;
        }
    }

    public void stop() {
        this.gradleLauncher.stop();
    }

    private static enum State {
        Created,
        Completed;

    }
}

