"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var axis_utils_1 = require("../../utils/axis_utils");
var compute_axis_ticks_dimensions_1 = require("./compute_axis_ticks_dimensions");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var compute_series_domains_1 = require("./compute_series_domains");
var count_bars_in_cluster_1 = require("./count_bars_in_cluster");
var get_axis_styles_1 = require("./get_axis_styles");
var get_bar_paddings_1 = require("./get_bar_paddings");
var get_specs_1 = require("./get_specs");
var is_histogram_mode_enabled_1 = require("./is_histogram_mode_enabled");
exports.computeAxisVisibleTicksSelector = re_reselect_1.default([
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_chart_theme_1.getChartThemeSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    get_specs_1.getAxisSpecsSelector,
    compute_axis_ticks_dimensions_1.computeAxisTicksDimensionsSelector,
    get_axis_styles_1.getAxesStylesSelector,
    compute_series_domains_1.computeSeriesDomainsSelector,
    count_bars_in_cluster_1.countBarsInClusterSelector,
    is_histogram_mode_enabled_1.isHistogramModeEnabledSelector,
    get_bar_paddings_1.getBarPaddingsSelector,
    get_specs_1.getSeriesSpecsSelector,
], function (chartDimensions, chartTheme, settingsSpec, axesSpecs, axesTicksDimensions, axesStyles, seriesDomainsAndData, totalBarsInCluster, isHistogramMode, barsPadding, seriesSpecs) {
    var _a, _b;
    var fallBackTickFormatter = (_b = (_a = seriesSpecs.find(function (_a) {
        var tickFormat = _a.tickFormat;
        return tickFormat;
    })) === null || _a === void 0 ? void 0 : _a.tickFormat, (_b !== null && _b !== void 0 ? _b : axis_utils_1.defaultTickFormatter));
    var xDomain = seriesDomainsAndData.xDomain, yDomain = seriesDomainsAndData.yDomain;
    return axis_utils_1.getAxisTicksPositions(chartDimensions, chartTheme, settingsSpec.rotation, axesSpecs, axesTicksDimensions, axesStyles, xDomain, yDomain, totalBarsInCluster, isHistogramMode, fallBackTickFormatter, barsPadding);
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=compute_axis_visible_ticks.js.map