"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var chroma_js_1 = __importDefault(require("chroma-js"));
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importStar(require("react"));
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var calcs_1 = require("../../chart_types/partition_chart/layout/utils/calcs");
var mouse_1 = require("../../state/actions/mouse");
var get_chart_rotation_1 = require("../../state/selectors/get_chart_rotation");
var get_chart_theme_1 = require("../../state/selectors/get_chart_theme");
var get_internal_is_intialized_1 = require("../../state/selectors/get_internal_is_intialized");
var get_internal_is_tooltip_visible_1 = require("../../state/selectors/get_internal_is_tooltip_visible");
var get_internal_tooltip_anchor_position_1 = require("../../state/selectors/get_internal_tooltip_anchor_position");
var get_internal_tooltip_info_1 = require("../../state/selectors/get_internal_tooltip_info");
var get_settings_specs_1 = require("../../state/selectors/get_settings_specs");
var get_tooltip_header_formatter_1 = require("../../state/selectors/get_tooltip_header_formatter");
var commons_1 = require("../../utils/commons");
var portal_1 = require("../portal");
var get_tooltip_settings_1 = require("./get_tooltip_settings");
var TooltipComponent = function (_a) {
    var info = _a.info, headerFormatter = _a.headerFormatter, position = _a.position, getChartContainerRef = _a.getChartContainerRef, settings = _a.settings, visible = _a.visible, rotation = _a.rotation, chartId = _a.chartId, onPointerMove = _a.onPointerMove, backgroundColor = _a.backgroundColor;
    var _b, _c, _d, _e;
    var chartRef = getChartContainerRef();
    var handleScroll = function () {
        onPointerMove({ x: -1, y: -1 }, new Date().getTime());
    };
    react_1.useEffect(function () {
        window.addEventListener('scroll', handleScroll, true);
        return function () { return window.removeEventListener('scroll', handleScroll, true); };
    }, []);
    var renderHeader = react_1.useCallback(function (header) {
        if (!header || !header.isVisible) {
            return null;
        }
        return (react_1.default.createElement("div", { className: "echTooltip__header" }, headerFormatter ? headerFormatter(header) : header.formattedValue));
    }, [headerFormatter]);
    var renderValues = function (values) { return (react_1.default.createElement("div", { className: "echTooltip__list" }, values.map(function (_a, index) {
        var seriesIdentifier = _a.seriesIdentifier, valueAccessor = _a.valueAccessor, label = _a.label, markValue = _a.markValue, formattedValue = _a.formattedValue, formattedMarkValue = _a.formattedMarkValue, color = _a.color, isHighlighted = _a.isHighlighted, isVisible = _a.isVisible;
        if (!isVisible) {
            return null;
        }
        var classes = classnames_1.default('echTooltip__item', {
            echTooltip__rowHighlighted: isHighlighted,
        });
        var adjustedBGColor = calcs_1.isColorValid(color) && chroma_js_1.default(color).alpha() === 0 ? 'transparent' : backgroundColor;
        return (react_1.default.createElement("div", { key: seriesIdentifier.key + "__" + valueAccessor + "__" + index, className: classes, style: {
                borderLeftColor: color,
            } },
            react_1.default.createElement("div", { className: "echTooltip__item--backgroundColor", style: { backgroundColor: adjustedBGColor } },
                react_1.default.createElement("div", { className: "echTooltip__item--color", style: { backgroundColor: color } })),
            react_1.default.createElement("div", { className: "echTooltip__item--container" },
                react_1.default.createElement("span", { className: "echTooltip__label" }, label),
                react_1.default.createElement("span", { className: "echTooltip__value" }, formattedValue),
                commons_1.isDefined(markValue) && react_1.default.createElement("span", { className: "echTooltip__markValue" },
                    "\u00A0(",
                    formattedMarkValue,
                    ")"))));
    }))); };
    var renderTooltip = function () {
        var _a;
        if (!info || !visible) {
            return null;
        }
        if (typeof settings !== 'string' && ((_a = settings) === null || _a === void 0 ? void 0 : _a.customTooltip)) {
            var CustomTooltip = settings.customTooltip;
            return react_1.default.createElement(CustomTooltip, __assign({}, info));
        }
        return (react_1.default.createElement("div", { className: "echTooltip" },
            renderHeader(info.header),
            renderValues(info.values)));
    };
    var anchorPosition = react_1.useMemo(function () {
        if (!position || !visible) {
            return null;
        }
        var x0 = position.x0, x1 = position.x1, y0 = position.y0, y1 = position.y1;
        var width = x0 !== undefined ? x1 - x0 : 0;
        var height = y0 !== undefined ? y1 - y0 : 0;
        return {
            left: x1 - width,
            width: width,
            top: y1 - height,
            height: height,
        };
    }, [visible, (_b = position) === null || _b === void 0 ? void 0 : _b.x0, (_c = position) === null || _c === void 0 ? void 0 : _c.x1, (_d = position) === null || _d === void 0 ? void 0 : _d.y0, (_e = position) === null || _e === void 0 ? void 0 : _e.y1]);
    var popperSettings = react_1.useMemo(function () {
        if (!settings || typeof settings === 'string') {
            return;
        }
        var placement = settings.placement, fallbackPlacements = settings.fallbackPlacements, boundary = settings.boundary, rest = __rest(settings, ["placement", "fallbackPlacements", "boundary"]);
        return __assign(__assign({}, rest), { placement: (placement !== null && placement !== void 0 ? placement : (rotation === 0 || rotation === 180 ? portal_1.Placement.Right : portal_1.Placement.Top)), fallbackPlacements: (fallbackPlacements !== null && fallbackPlacements !== void 0 ? fallbackPlacements : (rotation === 0 || rotation === 180
                ? [portal_1.Placement.Right, portal_1.Placement.Left, portal_1.Placement.Top, portal_1.Placement.Bottom]
                : [portal_1.Placement.Top, portal_1.Placement.Bottom, portal_1.Placement.Right, portal_1.Placement.Left])), boundary: boundary === 'chart' && chartRef.current ? chartRef.current : undefined });
    }, [settings, chartRef, rotation]);
    if (!visible) {
        return null;
    }
    return (react_1.default.createElement(portal_1.TooltipPortal, { scope: "MainTooltip", anchor: {
            position: anchorPosition,
            ref: chartRef.current,
        }, settings: popperSettings, chartId: chartId, visible: visible }, renderTooltip()));
};
TooltipComponent.displayName = 'Tooltip';
var HIDDEN_TOOLTIP_PROPS = {
    visible: false,
    info: undefined,
    position: null,
    headerFormatter: undefined,
    settings: {},
    rotation: 0,
    chartId: '',
    backgroundColor: 'transparent',
};
var mapDispatchToProps = function (dispatch) {
    return redux_1.bindActionCreators({ onPointerMove: mouse_1.onPointerMove }, dispatch);
};
var mapStateToProps = function (state) {
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return HIDDEN_TOOLTIP_PROPS;
    }
    var _a = get_internal_is_tooltip_visible_1.getInternalIsTooltipVisibleSelector(state), visible = _a.visible, isExternal = _a.isExternal;
    var settingsSpec = get_settings_specs_1.getSettingsSpecSelector(state);
    var settings = get_tooltip_settings_1.getTooltipSettings(settingsSpec, isExternal);
    return {
        visible: visible,
        info: get_internal_tooltip_info_1.getInternalTooltipInfoSelector(state),
        position: get_internal_tooltip_anchor_position_1.getInternalTooltipAnchorPositionSelector(state),
        headerFormatter: get_tooltip_header_formatter_1.getTooltipHeaderFormatterSelector(state),
        settings: settings,
        rotation: get_chart_rotation_1.getChartRotationSelector(state),
        chartId: state.chartId,
        backgroundColor: get_chart_theme_1.getChartThemeSelector(state).background.color,
    };
};
exports.Tooltip = react_1.memo(react_redux_1.connect(mapStateToProps, mapDispatchToProps)(TooltipComponent));
//# sourceMappingURL=tooltip.js.map