# -*- coding: utf-8 -*-
#
# Picard, the next-generation MusicBrainz tagger
#
# Copyright (C) 2007 Lukáš Lalinský
# Copyright (C) 2014, 2020 Laurent Monin
# Copyright (C) 2017 Sambhav Kothari
# Copyright (C) 2019 Philipp Wolfer
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.


# List of alias locales
ALIAS_LOCALES = {
    'aa': N_('Afar'),
    'aa_DJ': N_('Afar (Djibouti)'),
    'aa_ER': N_('Afar (Eritrea)'),
    'aa_ER_SAAHO': N_('Afar (Eritrea) (Saho)'),
    'aa_ET': N_('Afar (Ethiopia)'),
    'af': N_('Afrikaans'),
    'af_NA': N_('Afrikaans (Namibia)'),
    'af_ZA': N_('Afrikaans (South Africa)'),
    'ak': N_('Akan'),
    'ak_GH': N_('Akan (Ghana)'),
    'sq': N_('Albanian'),
    'sq_AL': N_('Albanian (Albania)'),
    'am': N_('Amharic'),
    'am_ET': N_('Amharic (Ethiopia)'),
    'ar': N_('Arabic'),
    'ar_DZ': N_('Arabic (Algeria)'),
    'ar_BH': N_('Arabic (Bahrain)'),
    'ar_EG': N_('Arabic (Egypt)'),
    'ar_IQ': N_('Arabic (Iraq)'),
    'ar_JO': N_('Arabic (Jordan)'),
    'ar_KW': N_('Arabic (Kuwait)'),
    'ar_LB': N_('Arabic (Lebanon)'),
    'ar_LY': N_('Arabic (Libya)'),
    'ar_MA': N_('Arabic (Morocco)'),
    'ar_OM': N_('Arabic (Oman)'),
    'ar_QA': N_('Arabic (Qatar)'),
    'ar_SA': N_('Arabic (Saudi Arabia)'),
    'ar_SD': N_('Arabic (Sudan)'),
    'ar_SY': N_('Arabic (Syria)'),
    'ar_TN': N_('Arabic (Tunisia)'),
    'ar_AE': N_('Arabic (United Arab Emirates)'),
    'ar_YE': N_('Arabic (Yemen)'),
    'hy': N_('Armenian'),
    'hy_AM': N_('Armenian (Armenia)'),
    'hy_AM_REVISED': N_('Armenian (Armenia) (Revised Orthography)'),
    'as': N_('Assamese'),
    'as_IN': N_('Assamese (India)'),
    'cch': N_('Atsam'),
    'cch_NG': N_('Atsam (Nigeria)'),
    'az': N_('Azerbaijani'),
    'az_AZ': N_('Azerbaijani (Azerbaijan)'),
    'az_Cyrl': N_('Azerbaijani (Cyrillic)'),
    'az_Cyrl_AZ': N_('Azerbaijani (Cyrillic) (Azerbaijan)'),
    'az_Latn': N_('Azerbaijani (Latin)'),
    'az_Latn_AZ': N_('Azerbaijani (Latin) (Azerbaijan)'),
    'eu': N_('Basque'),
    'eu_ES': N_('Basque (Spain)'),
    'be': N_('Belarusian'),
    'be_BY': N_('Belarusian (Belarus)'),
    'bn': N_('Bengali'),
    'bn_BD': N_('Bengali (Bangladesh)'),
    'bn_IN': N_('Bengali (India)'),
    'byn': N_('Blin'),
    'byn_ER': N_('Blin (Eritrea)'),
    'bs': N_('Bosnian'),
    'bs_BA': N_('Bosnian (Bosnia and Herzegovina)'),
    'bg': N_('Bulgarian'),
    'bg_BG': N_('Bulgarian (Bulgaria)'),
    'my': N_('Burmese'),
    'my_MM': N_('Burmese (Myanmar [Burma])'),
    'ca': N_('Catalan'),
    'ca_ES': N_('Catalan (Spain)'),
    'zh': N_('Chinese'),
    'zh_CN': N_('Chinese (China)'),
    'zh_HK': N_('Chinese (Hong Kong)'),
    'zh_MO': N_('Chinese (Macau)'),
    'zh_Hans': N_('Chinese (Simplified Han)'),
    'zh_Hans_CN': N_('Chinese (Simplified Han) (China)'),
    'zh_Hans_HK': N_('Chinese (Simplified Han) (Hong Kong)'),
    'zh_Hans_MO': N_('Chinese (Simplified Han) (Macau)'),
    'zh_Hans_SG': N_('Chinese (Simplified Han) (Singapore)'),
    'zh_SG': N_('Chinese (Singapore)'),
    'zh_TW': N_('Chinese (Taiwan)'),
    'zh_Hant': N_('Chinese (Traditional Han)'),
    'zh_Hant_HK': N_('Chinese (Traditional Han) (Hong Kong)'),
    'zh_Hant_MO': N_('Chinese (Traditional Han) (Macau)'),
    'zh_Hant_TW': N_('Chinese (Traditional Han) (Taiwan)'),
    'cop': N_('Coptic'),
    'kw': N_('Cornish'),
    'kw_GB': N_('Cornish (United Kingdom)'),
    'hr': N_('Croatian'),
    'hr_HR': N_('Croatian (Croatia)'),
    'cs': N_('Czech'),
    'cs_CZ': N_('Czech (Czech Republic)'),
    'da': N_('Danish'),
    'da_DK': N_('Danish (Denmark)'),
    'dv': N_('Divehi'),
    'dv_MV': N_('Divehi (Maldives)'),
    'nl': N_('Dutch'),
    'nl_BE': N_('Dutch (Belgium)'),
    'nl_NL': N_('Dutch (Netherlands)'),
    'dz': N_('Dzongkha'),
    'dz_BT': N_('Dzongkha (Bhutan)'),
    'en': N_('English'),
    'en_AS': N_('English (American Samoa)'),
    'en_AU': N_('English (Australia)'),
    'en_BE': N_('English (Belgium)'),
    'en_BZ': N_('English (Belize)'),
    'en_BW': N_('English (Botswana)'),
    'en_CA': N_('English (Canada)'),
    'en_Dsrt': N_('English (Deseret)'),
    'en_Dsrt_US': N_('English (Deseret) (United States)'),
    'en_GU': N_('English (Guam)'),
    'en_HK': N_('English (Hong Kong)'),
    'en_IN': N_('English (India)'),
    'en_IE': N_('English (Ireland)'),
    'en_JM': N_('English (Jamaica)'),
    'en_MT': N_('English (Malta)'),
    'en_MH': N_('English (Marshall Islands)'),
    'en_NA': N_('English (Namibia)'),
    'en_NZ': N_('English (New Zealand)'),
    'en_MP': N_('English (Northern Mariana Islands)'),
    'en_PK': N_('English (Pakistan)'),
    'en_PH': N_('English (Philippines)'),
    'en_Shaw': N_('English (Shavian)'),
    'en_SG': N_('English (Singapore)'),
    'en_ZA': N_('English (South Africa)'),
    'en_TT': N_('English (Trinidad and Tobago)'),
    'en_UM': N_('English (U.S. Minor Outlying Islands)'),
    'en_VI': N_('English (U.S. Virgin Islands)'),
    'en_GB': N_('English (United Kingdom)'),
    'en_US': N_('English (United States)'),
    'en_US_POSIX': N_('English (United States) (Computer)'),
    'en_ZW': N_('English (Zimbabwe)'),
    'eo': N_('Esperanto'),
    'et': N_('Estonian'),
    'et_EE': N_('Estonian (Estonia)'),
    'ee': N_('Ewe'),
    'ee_GH': N_('Ewe (Ghana)'),
    'ee_TG': N_('Ewe (Togo)'),
    'fo': N_('Faroese'),
    'fo_FO': N_('Faroese (Faroe Islands)'),
    'fil': N_('Filipino'),
    'fil_PH': N_('Filipino (Philippines)'),
    'fi': N_('Finnish'),
    'fi_FI': N_('Finnish (Finland)'),
    'fr': N_('French'),
    'fr_BE': N_('French (Belgium)'),
    'fr_CA': N_('French (Canada)'),
    'fr_FR': N_('French (France)'),
    'fr_LU': N_('French (Luxembourg)'),
    'fr_MC': N_('French (Monaco)'),
    'fr_SN': N_('French (Senegal)'),
    'fr_CH': N_('French (Switzerland)'),
    'fur': N_('Friulian'),
    'fur_IT': N_('Friulian (Italy)'),
    'gaa': N_('Ga'),
    'gaa_GH': N_('Ga (Ghana)'),
    'gl': N_('Galician'),
    'gl_ES': N_('Galician (Spain)'),
    'gez': N_('Geez'),
    'gez_ER': N_('Geez (Eritrea)'),
    'gez_ET': N_('Geez (Ethiopia)'),
    'ka': N_('Georgian'),
    'ka_GE': N_('Georgian (Georgia)'),
    'de': N_('German'),
    'de_AT': N_('German (Austria)'),
    'de_BE': N_('German (Belgium)'),
    'de_DE': N_('German (Germany)'),
    'de_LI': N_('German (Liechtenstein)'),
    'de_LU': N_('German (Luxembourg)'),
    'de_CH': N_('German (Switzerland)'),
    'el_POLYTON': N_('Greek'),
    'el': N_('Greek'),
    'el_CY': N_('Greek (Cyprus)'),
    'el_GR': N_('Greek (Greece)'),
    'gu': N_('Gujarati'),
    'gu_IN': N_('Gujarati (India)'),
    'ha': N_('Hausa'),
    'ha_Arab': N_('Hausa (Arabic)'),
    'ha_Arab_NG': N_('Hausa (Arabic) (Nigeria)'),
    'ha_Arab_SD': N_('Hausa (Arabic) (Sudan)'),
    'ha_GH': N_('Hausa (Ghana)'),
    'ha_Latn': N_('Hausa (Latin)'),
    'ha_Latn_GH': N_('Hausa (Latin) (Ghana)'),
    'ha_Latn_NE': N_('Hausa (Latin) (Niger)'),
    'ha_Latn_NG': N_('Hausa (Latin) (Nigeria)'),
    'ha_NE': N_('Hausa (Niger)'),
    'ha_NG': N_('Hausa (Nigeria)'),
    'ha_SD': N_('Hausa (Sudan)'),
    'haw': N_('Hawaiian'),
    'haw_US': N_('Hawaiian (United States)'),
    'he': N_('Hebrew'),
    'he_IL': N_('Hebrew (Israel)'),
    'hi': N_('Hindi'),
    'hi_IN': N_('Hindi (India)'),
    'hu': N_('Hungarian'),
    'hu_HU': N_('Hungarian (Hungary)'),
    'is': N_('Icelandic'),
    'is_IS': N_('Icelandic (Iceland)'),
    'ig': N_('Igbo'),
    'ig_NG': N_('Igbo (Nigeria)'),
    'id': N_('Indonesian'),
    'id_ID': N_('Indonesian (Indonesia)'),
    'ia': N_('Interlingua'),
    'iu': N_('Inuktitut'),
    'ga': N_('Irish'),
    'ga_IE': N_('Irish (Ireland)'),
    'it': N_('Italian'),
    'it_IT': N_('Italian (Italy)'),
    'it_CH': N_('Italian (Switzerland)'),
    'ja': N_('Japanese'),
    'ja_JP': N_('Japanese (Japan)'),
    'kaj': N_('Jju'),
    'kaj_NG': N_('Jju (Nigeria)'),
    'kl': N_('Kalaallisut'),
    'kl_GL': N_('Kalaallisut (Greenland)'),
    'kam': N_('Kamba'),
    'kam_KE': N_('Kamba (Kenya)'),
    'kn': N_('Kannada'),
    'kn_IN': N_('Kannada (India)'),
    'kk': N_('Kazakh'),
    'kk_Cyrl': N_('Kazakh (Cyrillic)'),
    'kk_Cyrl_KZ': N_('Kazakh (Cyrillic) (Kazakhstan)'),
    'kk_KZ': N_('Kazakh (Kazakhstan)'),
    'km': N_('Khmer'),
    'km_KH': N_('Khmer (Cambodia)'),
    'rw': N_('Kinyarwanda'),
    'rw_RW': N_('Kinyarwanda (Rwanda)'),
    'ky': N_('Kirghiz'),
    'ky_KG': N_('Kirghiz (Kyrgyzstan)'),
    'kok': N_('Konkani'),
    'kok_IN': N_('Konkani (India)'),
    'ko': N_('Korean'),
    'ko_KR': N_('Korean (South Korea)'),
    'kfo': N_('Koro'),
    'kfo_CI': N_('Koro (Côte d’Ivoire)'),
    'kpe': N_('Kpelle'),
    'kpe_GN': N_('Kpelle (Guinea)'),
    'kpe_LR': N_('Kpelle (Liberia)'),
    'ku': N_('Kurdish'),
    'ku_Arab': N_('Kurdish (Arabic)'),
    'ku_Arab_IR': N_('Kurdish (Arabic) (Iran)'),
    'ku_Arab_IQ': N_('Kurdish (Arabic) (Iraq)'),
    'ku_Arab_SY': N_('Kurdish (Arabic) (Syria)'),
    'ku_IR': N_('Kurdish (Iran)'),
    'ku_IQ': N_('Kurdish (Iraq)'),
    'ku_Latn': N_('Kurdish (Latin)'),
    'ku_Latn_TR': N_('Kurdish (Latin) (Turkey)'),
    'ku_SY': N_('Kurdish (Syria)'),
    'ku_TR': N_('Kurdish (Turkey)'),
    'lo': N_('Lao'),
    'lo_LA': N_('Lao (Laos)'),
    'lv': N_('Latvian'),
    'lv_LV': N_('Latvian (Latvia)'),
    'ln': N_('Lingala'),
    'ln_CG': N_('Lingala (Congo - Brazzaville)'),
    'ln_CD': N_('Lingala (Congo - Kinshasa)'),
    'lt': N_('Lithuanian'),
    'lt_LT': N_('Lithuanian (Lithuania)'),
    'nds': N_('Low German'),
    'nds_DE': N_('Low German (Germany)'),
    'mk': N_('Macedonian'),
    'mk_MK': N_('Macedonian (Macedonia)'),
    'ms': N_('Malay'),
    'ms_BN': N_('Malay (Brunei)'),
    'ms_MY': N_('Malay (Malaysia)'),
    'ml': N_('Malayalam'),
    'ml_IN': N_('Malayalam (India)'),
    'mt': N_('Maltese'),
    'mt_MT': N_('Maltese (Malta)'),
    'gv': N_('Manx'),
    'gv_GB': N_('Manx (United Kingdom)'),
    'mr': N_('Marathi'),
    'mr_IN': N_('Marathi (India)'),
    'mo': N_('Moldavian'),
    'mn': N_('Mongolian'),
    'mn_CN': N_('Mongolian (China)'),
    'mn_Cyrl': N_('Mongolian (Cyrillic)'),
    'mn_Cyrl_MN': N_('Mongolian (Cyrillic) (Mongolia)'),
    'mn_MN': N_('Mongolian (Mongolia)'),
    'mn_Mong': N_('Mongolian (Mongolian)'),
    'mn_Mong_CN': N_('Mongolian (Mongolian) (China)'),
    'ne': N_('Nepali'),
    'ne_IN': N_('Nepali (India)'),
    'ne_NP': N_('Nepali (Nepal)'),
    'se': N_('Northern Sami'),
    'se_FI': N_('Northern Sami (Finland)'),
    'se_NO': N_('Northern Sami (Norway)'),
    'nso': N_('Northern Sotho'),
    'nso_ZA': N_('Northern Sotho (South Africa)'),
    'no': N_('Norwegian'),
    'nb': N_('Norwegian Bokmål'),
    'nb_NO': N_('Norwegian Bokmål (Norway)'),
    'nn': N_('Norwegian Nynorsk'),
    'nn_NO': N_('Norwegian Nynorsk (Norway)'),
    'ny': N_('Nyanja'),
    'ny_MW': N_('Nyanja (Malawi)'),
    'oc': N_('Occitan'),
    'oc_FR': N_('Occitan (France)'),
    'or': N_('Oriya'),
    'or_IN': N_('Oriya (India)'),
    'om': N_('Oromo'),
    'om_ET': N_('Oromo (Ethiopia)'),
    'om_KE': N_('Oromo (Kenya)'),
    'ps': N_('Pashto'),
    'ps_AF': N_('Pashto (Afghanistan)'),
    'fa': N_('Persian'),
    'fa_AF': N_('Persian (Afghanistan)'),
    'fa_IR': N_('Persian (Iran)'),
    'pl': N_('Polish'),
    'pl_PL': N_('Polish (Poland)'),
    'pt': N_('Portuguese'),
    'pt_BR': N_('Portuguese (Brazil)'),
    'pt_PT': N_('Portuguese (Portugal)'),
    'pa': N_('Punjabi'),
    'pa_Arab': N_('Punjabi (Arabic)'),
    'pa_Arab_PK': N_('Punjabi (Arabic) (Pakistan)'),
    'pa_Guru': N_('Punjabi (Gurmukhi)'),
    'pa_Guru_IN': N_('Punjabi (Gurmukhi) (India)'),
    'pa_IN': N_('Punjabi (India)'),
    'pa_PK': N_('Punjabi (Pakistan)'),
    'ro': N_('Romanian'),
    'ro_MD': N_('Romanian (Moldova)'),
    'ro_RO': N_('Romanian (Romania)'),
    'ru': N_('Russian'),
    'ru_RU': N_('Russian (Russia)'),
    'ru_UA': N_('Russian (Ukraine)'),
    'sa': N_('Sanskrit'),
    'sa_IN': N_('Sanskrit (India)'),
    'sr_YU': N_('Serbian'),
    'sr': N_('Serbian'),
    'sr_BA': N_('Serbian (Bosnia and Herzegovina)'),
    'sr_Cyrl': N_('Serbian (Cyrillic)'),
    'sr_Cyrl_YU': N_('Serbian (Cyrillic)'),
    'sr_Cyrl_BA': N_('Serbian (Cyrillic) (Bosnia and Herzegovina)'),
    'sr_Cyrl_ME': N_('Serbian (Cyrillic) (Montenegro)'),
    'sr_Cyrl_RS': N_('Serbian (Cyrillic) (Serbia)'),
    'sr_Cyrl_CS': N_('Serbian (Cyrillic) (Serbia and Montenegro)'),
    'sr_Latn': N_('Serbian (Latin)'),
    'sr_Latn_YU': N_('Serbian (Latin)'),
    'sr_Latn_BA': N_('Serbian (Latin) (Bosnia and Herzegovina)'),
    'sr_Latn_ME': N_('Serbian (Latin) (Montenegro)'),
    'sr_Latn_RS': N_('Serbian (Latin) (Serbia)'),
    'sr_Latn_CS': N_('Serbian (Latin) (Serbia and Montenegro)'),
    'sr_ME': N_('Serbian (Montenegro)'),
    'sr_RS': N_('Serbian (Serbia)'),
    'sr_CS': N_('Serbian (Serbia and Montenegro)'),
    'sh': N_('Serbo-Croatian'),
    'sh_YU': N_('Serbo-Croatian'),
    'sh_BA': N_('Serbo-Croatian (Bosnia and Herzegovina)'),
    'sh_CS': N_('Serbo-Croatian (Serbia and Montenegro)'),
    'ii': N_('Sichuan Yi'),
    'ii_CN': N_('Sichuan Yi (China)'),
    'sid': N_('Sidamo'),
    'sid_ET': N_('Sidamo (Ethiopia)'),
    'si': N_('Sinhala'),
    'si_LK': N_('Sinhala (Sri Lanka)'),
    'sk': N_('Slovak'),
    'sk_SK': N_('Slovak (Slovakia)'),
    'sl': N_('Slovenian'),
    'sl_SI': N_('Slovenian (Slovenia)'),
    'so': N_('Somali'),
    'so_DJ': N_('Somali (Djibouti)'),
    'so_ET': N_('Somali (Ethiopia)'),
    'so_KE': N_('Somali (Kenya)'),
    'so_SO': N_('Somali (Somalia)'),
    'nr': N_('South Ndebele'),
    'nr_ZA': N_('South Ndebele (South Africa)'),
    'st': N_('Southern Sotho'),
    'st_LS': N_('Southern Sotho (Lesotho)'),
    'st_ZA': N_('Southern Sotho (South Africa)'),
    'es': N_('Spanish'),
    'es_AR': N_('Spanish (Argentina)'),
    'es_BO': N_('Spanish (Bolivia)'),
    'es_CL': N_('Spanish (Chile)'),
    'es_CO': N_('Spanish (Colombia)'),
    'es_CR': N_('Spanish (Costa Rica)'),
    'es_DO': N_('Spanish (Dominican Republic)'),
    'es_EC': N_('Spanish (Ecuador)'),
    'es_SV': N_('Spanish (El Salvador)'),
    'es_GT': N_('Spanish (Guatemala)'),
    'es_HN': N_('Spanish (Honduras)'),
    'es_MX': N_('Spanish (Mexico)'),
    'es_NI': N_('Spanish (Nicaragua)'),
    'es_PA': N_('Spanish (Panama)'),
    'es_PY': N_('Spanish (Paraguay)'),
    'es_PE': N_('Spanish (Peru)'),
    'es_PR': N_('Spanish (Puerto Rico)'),
    'es_ES': N_('Spanish (Spain)'),
    'es_US': N_('Spanish (United States)'),
    'es_UY': N_('Spanish (Uruguay)'),
    'es_VE': N_('Spanish (Venezuela)'),
    'sw': N_('Swahili'),
    'sw_KE': N_('Swahili (Kenya)'),
    'sw_TZ': N_('Swahili (Tanzania)'),
    'ss': N_('Swati'),
    'ss_ZA': N_('Swati (South Africa)'),
    'ss_SZ': N_('Swati (Swaziland)'),
    'sv': N_('Swedish'),
    'sv_FI': N_('Swedish (Finland)'),
    'sv_SE': N_('Swedish (Sweden)'),
    'gsw': N_('Swiss German'),
    'gsw_CH': N_('Swiss German (Switzerland)'),
    'syr': N_('Syriac'),
    'syr_SY': N_('Syriac (Syria)'),
    'tl': N_('Tagalog'),
    'tg': N_('Tajik'),
    'tg_Cyrl': N_('Tajik (Cyrillic)'),
    'tg_Cyrl_TJ': N_('Tajik (Cyrillic) (Tajikistan)'),
    'tg_TJ': N_('Tajik (Tajikistan)'),
    'ta': N_('Tamil'),
    'ta_IN': N_('Tamil (India)'),
    'trv': N_('Taroko'),
    'trv_TW': N_('Taroko (Taiwan)'),
    'tt': N_('Tatar'),
    'tt_RU': N_('Tatar (Russia)'),
    'te': N_('Telugu'),
    'te_IN': N_('Telugu (India)'),
    'th': N_('Thai'),
    'th_TH': N_('Thai (Thailand)'),
    'bo': N_('Tibetan'),
    'bo_CN': N_('Tibetan (China)'),
    'bo_IN': N_('Tibetan (India)'),
    'tig': N_('Tigre'),
    'tig_ER': N_('Tigre (Eritrea)'),
    'ti': N_('Tigrinya'),
    'ti_ER': N_('Tigrinya (Eritrea)'),
    'ti_ET': N_('Tigrinya (Ethiopia)'),
    'to': N_('Tonga'),
    'to_TO': N_('Tonga (Tonga)'),
    'ts': N_('Tsonga'),
    'ts_ZA': N_('Tsonga (South Africa)'),
    'tn': N_('Tswana'),
    'tn_ZA': N_('Tswana (South Africa)'),
    'tr': N_('Turkish'),
    'tr_TR': N_('Turkish (Turkey)'),
    'kcg': N_('Tyap'),
    'kcg_NG': N_('Tyap (Nigeria)'),
    'ug': N_('Uighur'),
    'ug_Arab': N_('Uighur (Arabic)'),
    'ug_Arab_CN': N_('Uighur (Arabic) (China)'),
    'ug_CN': N_('Uighur (China)'),
    'uk': N_('Ukrainian'),
    'uk_UA': N_('Ukrainian (Ukraine)'),
    'ur': N_('Urdu'),
    'ur_IN': N_('Urdu (India)'),
    'ur_PK': N_('Urdu (Pakistan)'),
    'uz': N_('Uzbek'),
    'uz_AF': N_('Uzbek (Afghanistan)'),
    'uz_Arab': N_('Uzbek (Arabic)'),
    'uz_Arab_AF': N_('Uzbek (Arabic) (Afghanistan)'),
    'uz_Cyrl': N_('Uzbek (Cyrillic)'),
    'uz_Cyrl_UZ': N_('Uzbek (Cyrillic) (Uzbekistan)'),
    'uz_Latn': N_('Uzbek (Latin)'),
    'uz_Latn_UZ': N_('Uzbek (Latin) (Uzbekistan)'),
    'uz_UZ': N_('Uzbek (Uzbekistan)'),
    've': N_('Venda'),
    've_ZA': N_('Venda (South Africa)'),
    'vi': N_('Vietnamese'),
    'vi_VN': N_('Vietnamese (Vietnam)'),
    'wal': N_('Walamo'),
    'wal_ET': N_('Walamo (Ethiopia)'),
    'cy': N_('Welsh'),
    'cy_GB': N_('Welsh (United Kingdom)'),
    'wo': N_('Wolof'),
    'wo_Latn': N_('Wolof (Latin)'),
    'wo_Latn_SN': N_('Wolof (Latin) (Senegal)'),
    'wo_SN': N_('Wolof (Senegal)'),
    'xh': N_('Xhosa'),
    'xh_ZA': N_('Xhosa (South Africa)'),
    'yo': N_('Yoruba'),
    'yo_NG': N_('Yoruba (Nigeria)'),
    'zu': N_('Zulu'),
    'zu_ZA': N_('Zulu (South Africa)'),
}
