/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l / i64vec4(165l, 133l, 193l, 76l)) => i64vec4(0l, 0l, 0l, 0l)
 * (3l / i64vec4(165l, 133l, 193l, 76l)) => i64vec4(0l, 0l, 0l, 0l)
 * (-1192l / i64vec4(165l, 133l, 193l, 76l)) => i64vec4(-7l, -8l, -6l, -15l)
 * (1048576l / i64vec4(165l, 133l, 193l, 76l)) => i64vec4(6355l, 7884l, 5433l, 13797l)
 * (4251475l / i64vec4(165l, 133l, 193l, 76l)) => i64vec4(25766l, 31965l, 22028l, 55940l)
 * (29852643761l / i64vec4(165l, 133l, 193l, 76l)) => i64vec4(180925113l, 224455968l, 154676910l, 392797944l)
 * (-4398046511104l / i64vec4(165l, 133l, 193l, 76l)) => i64vec4(-26654827340l, -33068018880l, -22787805757l, -57869033040l)
 * (-3948976685146l / i64vec4(165l, 133l, 193l, 76l)) => i64vec4(-23933192031l, -29691554023l, -20461019094l, -51960219541l)
 * (-135763469567146206l / i64vec4(165l, 133l, 193l, 76l)) => i64vec4(-822808906467552l, -1020777966670272l, -703437666151016l, -1786361441672976l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0l / i64vec4(165l, 133l, 193l, 76l)), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array0;
  float[all(equal((3l / i64vec4(165l, 133l, 193l, 76l)), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array1;
  float[all(equal((-1192l / i64vec4(165l, 133l, 193l, 76l)), i64vec4(-7l, -8l, -6l, -15l))) ? 1 : -1] array2;
  float[all(equal((1048576l / i64vec4(165l, 133l, 193l, 76l)), i64vec4(6355l, 7884l, 5433l, 13797l))) ? 1 : -1] array3;
  float[all(equal((4251475l / i64vec4(165l, 133l, 193l, 76l)), i64vec4(25766l, 31965l, 22028l, 55940l))) ? 1 : -1] array4;
  float[all(equal((29852643761l / i64vec4(165l, 133l, 193l, 76l)), i64vec4(180925113l, 224455968l, 154676910l, 392797944l))) ? 1 : -1] array5;
  float[all(equal((-4398046511104l / i64vec4(165l, 133l, 193l, 76l)), i64vec4(-26654827340l, -33068018880l, -22787805757l, -57869033040l))) ? 1 : -1] array6;
  float[all(equal((-3948976685146l / i64vec4(165l, 133l, 193l, 76l)), i64vec4(-23933192031l, -29691554023l, -20461019094l, -51960219541l))) ? 1 : -1] array7;
  float[all(equal((-135763469567146206l / i64vec4(165l, 133l, 193l, 76l)), i64vec4(-822808906467552l, -1020777966670272l, -703437666151016l, -1786361441672976l))) ? 1 : -1] array8;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
