/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(22, -23, 4) << 0u) => ivec3(22, -23, 4)
 * (ivec3(22, -23, 4) << 1u) => ivec3(44, -46, 8)
 * (ivec3(22, -23, 4) << 2u) => ivec3(88, -92, 16)
 * (ivec3(22, -23, 4) << 5u) => ivec3(704, -736, 128)
 * (ivec3(22, -23, 4) << 25u) => ivec3(738197504, -771751936, 134217728)
 * (ivec3(22, -23, 4) << 31u) => ivec3(0, -2147483648, 0)
 * (ivec3(22, 23, 4) << 0u) => ivec3(22, 23, 4)
 * (ivec3(22, 23, 4) << 1u) => ivec3(44, 46, 8)
 * (ivec3(22, 23, 4) << 2u) => ivec3(88, 92, 16)
 * (ivec3(22, 23, 4) << 5u) => ivec3(704, 736, 128)
 * (ivec3(22, 23, 4) << 25u) => ivec3(738197504, 771751936, 134217728)
 * (ivec3(22, 23, 4) << 31u) => ivec3(0, -2147483648, 0)
 * (ivec3(-19, 1, -13) << 0u) => ivec3(-19, 1, -13)
 * (ivec3(-19, 1, -13) << 1u) => ivec3(-38, 2, -26)
 * (ivec3(-19, 1, -13) << 2u) => ivec3(-76, 4, -52)
 * (ivec3(-19, 1, -13) << 5u) => ivec3(-608, 32, -416)
 * (ivec3(-19, 1, -13) << 25u) => ivec3(-637534208, 33554432, -436207616)
 * (ivec3(-19, 1, -13) << 31u) => ivec3(-2147483648, -2147483648, -2147483648)
 * (ivec3(19, 1, 13) << 0u) => ivec3(19, 1, 13)
 * (ivec3(19, 1, 13) << 1u) => ivec3(38, 2, 26)
 * (ivec3(19, 1, 13) << 2u) => ivec3(76, 4, 52)
 * (ivec3(19, 1, 13) << 5u) => ivec3(608, 32, 416)
 * (ivec3(19, 1, 13) << 25u) => ivec3(637534208, 33554432, 436207616)
 * (ivec3(19, 1, 13) << 31u) => ivec3(-2147483648, -2147483648, -2147483648)
 */
#version 150

void main()
{
  float[all(equal((ivec3(22, -23, 4) << 0u), ivec3(22, -23, 4))) ? 1 : -1] array0;
  float[all(equal((ivec3(22, -23, 4) << 1u), ivec3(44, -46, 8))) ? 1 : -1] array1;
  float[all(equal((ivec3(22, -23, 4) << 2u), ivec3(88, -92, 16))) ? 1 : -1] array2;
  float[all(equal((ivec3(22, -23, 4) << 5u), ivec3(704, -736, 128))) ? 1 : -1] array3;
  float[all(equal((ivec3(22, -23, 4) << 25u), ivec3(738197504, -771751936, 134217728))) ? 1 : -1] array4;
  float[all(equal((ivec3(22, -23, 4) << 31u), ivec3(0, -2147483648, 0))) ? 1 : -1] array5;
  float[all(equal((ivec3(22, 23, 4) << 0u), ivec3(22, 23, 4))) ? 1 : -1] array6;
  float[all(equal((ivec3(22, 23, 4) << 1u), ivec3(44, 46, 8))) ? 1 : -1] array7;
  float[all(equal((ivec3(22, 23, 4) << 2u), ivec3(88, 92, 16))) ? 1 : -1] array8;
  float[all(equal((ivec3(22, 23, 4) << 5u), ivec3(704, 736, 128))) ? 1 : -1] array9;
  float[all(equal((ivec3(22, 23, 4) << 25u), ivec3(738197504, 771751936, 134217728))) ? 1 : -1] array10;
  float[all(equal((ivec3(22, 23, 4) << 31u), ivec3(0, -2147483648, 0))) ? 1 : -1] array11;
  float[all(equal((ivec3(-19, 1, -13) << 0u), ivec3(-19, 1, -13))) ? 1 : -1] array12;
  float[all(equal((ivec3(-19, 1, -13) << 1u), ivec3(-38, 2, -26))) ? 1 : -1] array13;
  float[all(equal((ivec3(-19, 1, -13) << 2u), ivec3(-76, 4, -52))) ? 1 : -1] array14;
  float[all(equal((ivec3(-19, 1, -13) << 5u), ivec3(-608, 32, -416))) ? 1 : -1] array15;
  float[all(equal((ivec3(-19, 1, -13) << 25u), ivec3(-637534208, 33554432, -436207616))) ? 1 : -1] array16;
  float[all(equal((ivec3(-19, 1, -13) << 31u), ivec3(-2147483648, -2147483648, -2147483648))) ? 1 : -1] array17;
  float[all(equal((ivec3(19, 1, 13) << 0u), ivec3(19, 1, 13))) ? 1 : -1] array18;
  float[all(equal((ivec3(19, 1, 13) << 1u), ivec3(38, 2, 26))) ? 1 : -1] array19;
  float[all(equal((ivec3(19, 1, 13) << 2u), ivec3(76, 4, 52))) ? 1 : -1] array20;
  float[all(equal((ivec3(19, 1, 13) << 5u), ivec3(608, 32, 416))) ? 1 : -1] array21;
  float[all(equal((ivec3(19, 1, 13) << 25u), ivec3(637534208, 33554432, 436207616))) ? 1 : -1] array22;
  float[all(equal((ivec3(19, 1, 13) << 31u), ivec3(-2147483648, -2147483648, -2147483648))) ? 1 : -1] array23;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length());
}
