/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.debug.RunnerListener;
import processing.app.exec.LineProcessor;
import processing.app.exec.ProcessRegistry;
import processing.app.exec.ProcessResult;
import processing.app.exec.StreamPump;
import processing.app.tools.android.AndroidDeviceProperties;
import processing.app.tools.android.AndroidEnvironment;
import processing.app.tools.android.AndroidSDK;
import processing.app.tools.android.DeviceListener;
import processing.app.tools.android.LogEntry;
import processing.core.PApplet;

class AndroidDevice
implements AndroidDeviceProperties {
    private final AndroidEnvironment env;
    private final String id;
    private final Set<Integer> activeProcesses = new HashSet<Integer>();
    private final Set<DeviceListener> listeners = Collections.synchronizedSet(new HashSet());
    private Process logcat;
    private static final Pattern SIG = Pattern.compile("PID:\\s+(\\d+)\\s+SIG:\\s+(\\d+)");
    private final List<String> stackTrace = new ArrayList<String>();

    public AndroidDevice(AndroidEnvironment androidEnvironment, String string) {
        this.env = androidEnvironment;
        this.id = string;
    }

    public void bringLauncherToFront() {
        try {
            this.adb("shell", "am", "start", "-a", "android.intent.action.MAIN", "-c", "android.intent.category.HOME");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public boolean installApp(String string, RunnerListener runnerListener) {
        if (!this.isAlive()) {
            return false;
        }
        this.bringLauncherToFront();
        try {
            ProcessResult processResult = this.adb("install", "-r", string);
            if (!processResult.succeeded()) {
                runnerListener.statusError("Could not install the sketch.");
                System.err.println(processResult);
                return false;
            }
            String string2 = null;
            for (String string3 : processResult) {
                if (!string3.startsWith("Failure")) continue;
                string2 = string3.substring(8);
                System.err.println(string3);
            }
            if (string2 == null) {
                runnerListener.statusNotice("Done installing.");
                return true;
            }
            runnerListener.statusError("Error while installing " + string2);
        }
        catch (IOException iOException) {
            runnerListener.statusError(iOException);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public boolean launchApp(String string, String string2) throws IOException, InterruptedException {
        if (!this.isAlive()) {
            return false;
        }
        return this.adb("shell", "am", "start", "-e", "debug", "true", "-a", "android.intent.action.MAIN", "-c", "android.intent.category.LAUNCHER", "-n", string + "/." + string2).succeeded();
    }

    public boolean isEmulator() {
        return this.id.startsWith("emulator");
    }

    private void reportStackTrace(LogEntry logEntry) {
        if (this.stackTrace.isEmpty()) {
            System.err.println("That's weird. Proc " + logEntry.pid + " got signal 3, but there's no stack trace.");
        }
        List<String> list = Collections.unmodifiableList(new ArrayList<String>(this.stackTrace));
        for (DeviceListener deviceListener : this.listeners) {
            deviceListener.stacktrace(list);
        }
        this.stackTrace.clear();
    }

    void initialize() throws IOException, InterruptedException {
        this.adb("logcat", "-c");
        String[] stringArray = this.generateAdbCommand("logcat");
        String string = PApplet.join((String[])stringArray, (char)' ');
        this.logcat = Runtime.getRuntime().exec(stringArray);
        ProcessRegistry.watch(this.logcat);
        new StreamPump(this.logcat.getInputStream(), "log: " + string).addTarget(new LogLineProcessor()).start();
        new StreamPump(this.logcat.getErrorStream(), "err: " + string).addTarget(System.err).start();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AndroidDevice.this.logcat.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("AndroidDevice: logcat process monitor interrupted");
                }
                finally {
                    AndroidDevice.this.shutdown();
                }
            }
        }, "AndroidDevice: logcat process monitor").start();
    }

    synchronized void shutdown() {
        if (!this.isAlive()) {
            return;
        }
        if (this.logcat != null) {
            this.logcat.destroy();
            this.logcat = null;
            ProcessRegistry.unwatch(this.logcat);
        }
        this.env.deviceRemoved(this);
        if (this.activeProcesses.size() > 0) {
            for (DeviceListener deviceListener : this.listeners) {
                deviceListener.sketchStopped();
            }
        }
        this.listeners.clear();
    }

    synchronized boolean isAlive() {
        return this.logcat != null;
    }

    public String getId() {
        return this.id;
    }

    public AndroidEnvironment getEnv() {
        return this.env;
    }

    private void startProc(String string, int n) {
        this.activeProcesses.add(n);
    }

    private void endProc(int n) {
        this.activeProcesses.remove(n);
        for (DeviceListener deviceListener : this.listeners) {
            deviceListener.sketchStopped();
        }
    }

    public void addListener(DeviceListener deviceListener) {
        this.listeners.add(deviceListener);
    }

    public void removeListener(DeviceListener deviceListener) {
        this.listeners.remove(deviceListener);
    }

    private ProcessResult adb(String ... stringArray) throws InterruptedException, IOException {
        String[] stringArray2 = this.generateAdbCommand(stringArray);
        return AndroidSDK.runADB(stringArray2);
    }

    private String[] generateAdbCommand(String ... stringArray) {
        return PApplet.concat((String[])new String[]{"adb", "-s", this.getId()}, (String[])stringArray);
    }

    public String toString() {
        return "[AndroidDevice " + this.getId() + "]";
    }

    private class LogLineProcessor
    implements LineProcessor {
        private LogLineProcessor() {
        }

        public void processLine(String string) {
            LogEntry logEntry = new LogEntry(string);
            if (logEntry.message.startsWith("PROCESSING")) {
                if (logEntry.message.contains("onStart")) {
                    AndroidDevice.this.startProc(logEntry.source, logEntry.pid);
                } else if (logEntry.message.contains("onStop")) {
                    AndroidDevice.this.endProc(logEntry.pid);
                }
            } else if (logEntry.source.equals("Process")) {
                this.handleCrash(logEntry);
            } else if (AndroidDevice.this.activeProcesses.contains(logEntry.pid)) {
                this.handleConsole(logEntry);
            }
        }

        private void handleCrash(LogEntry logEntry) {
            Matcher matcher = SIG.matcher(logEntry.message);
            if (matcher.find()) {
                int n = Integer.parseInt(matcher.group(1));
                int n2 = Integer.parseInt(matcher.group(2));
                if (AndroidDevice.this.activeProcesses.contains(n) && n2 == 3) {
                    AndroidDevice.this.endProc(n);
                    AndroidDevice.this.reportStackTrace(logEntry);
                }
            }
        }

        private void handleConsole(LogEntry logEntry) {
            boolean bl;
            boolean bl2 = bl = logEntry.source.equals("AndroidRuntime") && logEntry.severity == LogEntry.Severity.Error;
            if (bl) {
                if (!logEntry.message.startsWith("Uncaught handler")) {
                    AndroidDevice.this.stackTrace.add(logEntry.message);
                    System.err.println(logEntry.message);
                }
            } else if (logEntry.source.equals("System.out") || logEntry.source.equals("System.err")) {
                if (logEntry.severity.useErrorStream) {
                    System.err.println(logEntry.message);
                } else {
                    System.out.println(logEntry.message);
                }
            }
        }
    }
}

