/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.download.SharedIndexDownloadJson;
import com.intellij.indexing.shared.download.SharedIndexListLookup;
import com.intellij.indexing.shared.download.SharedIndexListLookupKt;
import com.intellij.indexing.shared.download.SharedIndexListLookupResult;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexNetworkCache;
import com.intellij.indexing.shared.download.SharedIndexNetworkCacheScope;
import com.intellij.indexing.shared.download.SharedIndexUrlDecision;
import com.intellij.indexing.shared.download.UrlSiblingsChecker;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0002!\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\rJ&\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\rJ(\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006#"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexListLookup;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cache", "com/intellij/indexing/shared/download/SharedIndexListLookup$cache$1", "Lcom/intellij/indexing/shared/download/SharedIndexListLookup$cache$1;", "cacheSize", "", "collectUrlsToProcess", "", "", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "extractListBaseUrl", "url", "groupUrsByListPaths", "", "urls", "invalidateCaches", "", "lookupListFor", "Lcom/intellij/indexing/shared/download/SharedIndexListLookupResult;", "listUrl", "parseListJson", "", "lookupUrl", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "ListLookupCacheEntry", "ListLookupRequest", "intellij.indexing.shared"})
public final class SharedIndexListLookup {
    private final Logger LOG;
    private final cache.1 cache;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<String>> groupUrsByListPaths(@NotNull List<String> urls) {
        void $this$groupByTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Iterable $this$mapNotNull$iv = urls;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String string = this.extractListBaseUrl(it);
            if ((string != null ? TuplesKt.to((Object)string, (Object)it) : null) == null) continue;
            pair = pair;
            boolean bl3 = false;
            boolean bl4 = false;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-SharedIndexListLookup$groupUrsByListPaths$42 = false;
            String key$iv$iv = (String)it2.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-SharedIndexListLookup$groupUrsByListPaths$42 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            String string = (String)it.getSecond();
            list.add(string);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> collectUrlsToProcess(@NotNull SharedIndexLookupRequest request, @NotNull ProgressIndicator indicator) {
        void $this$filterTo$iv$iv;
        Iterable listBase;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        List<String> urls = request.indexUrls();
        if (!request.getUseListJsonIndexToSkipUrls() || !Registry.is((String)"shared.indexes.use.cdn.list")) {
            return urls;
        }
        Map<String, List<String>> checkBases = this.groupUrsByListPaths(urls);
        HashSet skipUrls = new HashSet();
        Object object = checkBases;
        boolean bl = false;
        Iterator<Map.Entry<String, List<String>>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> entry;
            Map.Entry<String, List<String>> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            List<String> listUrls = entry2.getValue();
            if (!StringsKt.startsWith$default((String)((Object)listBase), (String)request.baseUrl(), (boolean)false, (int)2, null)) continue;
            SharedIndexListLookupResult lookup = this.lookupListFor(request, indicator, (String)((Object)listBase));
            for (String url : listUrls) {
                if (lookup.testUrl(request, url) != SharedIndexUrlDecision.SKIP) continue;
                Collection collection = skipUrls;
                boolean bl3 = false;
                collection.add(url);
                this.LOG.debug("Shared index download URL " + url + " is not listed, will be skipped");
            }
        }
        Iterable $this$filter$iv = urls;
        boolean $i$f$filter = false;
        listBase = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl4 = false;
            if (!(!skipUrls.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final String extractListBaseUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String url2 = StringsKt.trim((String)url, (char[])new char[]{'/'});
        int idx = StringsKt.lastIndexOf$default((CharSequence)url2, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (idx <= 0 || idx + 1 == url2.length()) {
            return null;
        }
        String string = url2;
        int n = 0;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, idx);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return StringsKt.trim((String)string3, (char[])new char[]{'/'});
    }

    public final void invalidateCaches() {
        this.cache.invalidateCaches();
    }

    @VisibleForTesting
    public final int cacheSize() {
        return this.cache.cacheSize();
    }

    @NotNull
    public final SharedIndexListLookupResult lookupListFor(@NotNull SharedIndexLookupRequest request, @NotNull ProgressIndicator indicator, @NotNull String listUrl) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)listUrl, (String)"listUrl");
        Object object = (ListLookupCacheEntry)SharedIndexNetworkCache.lookupOrCompute$default(this.cache, new ListLookupRequest(listUrl), indicator, null, (Function1)new Function1<SharedIndexNetworkCacheScope, ListLookupCacheEntry>(this, listUrl, request, indicator){
            final /* synthetic */ SharedIndexListLookup this$0;
            final /* synthetic */ String $listUrl;
            final /* synthetic */ SharedIndexLookupRequest $request;
            final /* synthetic */ ProgressIndicator $indicator;

            @Nullable
            public final ListLookupCacheEntry invoke(@NotNull SharedIndexNetworkCacheScope $this$lookupOrCompute) {
                SharedIndexListLookupResult sharedIndexListLookupResult;
                Intrinsics.checkNotNullParameter((Object)$this$lookupOrCompute, (String)"$receiver");
                String lookupUrl = StringsKt.trim((String)this.$listUrl, (char[])new char[]{'/'}) + "/list.json.xz";
                ObjectNode json = SharedIndexDownloadJson.INSTANCE.downloadJsonXz(this.$request, lookupUrl, this.$indicator);
                if (json == null) {
                    SharedIndexListLookup.access$getLOG$p(this.this$0).info("Failed to download the list of allowed URLs from " + lookupUrl + ". It looks like there is no internet connection. The " + this.$request + " is skipped");
                    sharedIndexListLookupResult = SharedIndexListLookupKt.access$getRejectAllListLookupResult$p();
                } else {
                    Set siblings = SharedIndexListLookup.access$parseListJson(this.this$0, lookupUrl, this.$request, json);
                    if (siblings == null || siblings.isEmpty()) {
                        SharedIndexListLookup.access$getLOG$p(this.this$0).debug("Invalid data is downloaded as the list of allowed URLs from " + lookupUrl + ". The " + this.$request + " is skipped");
                        sharedIndexListLookupResult = SharedIndexListLookupKt.access$getRejectAllListLookupResult$p();
                    } else {
                        sharedIndexListLookupResult = new UrlSiblingsChecker(this.$listUrl, siblings);
                    }
                }
                SharedIndexListLookupResult checker = sharedIndexListLookupResult;
                return new ListLookupCacheEntry($this$lookupOrCompute.getNow(), checker);
            }
            {
                this.this$0 = sharedIndexListLookup;
                this.$listUrl = string;
                this.$request = sharedIndexLookupRequest;
                this.$indicator = progressIndicator;
                super(1);
            }
        }, 4, null);
        if (object == null || (object = ((ListLookupCacheEntry)object).getChecker()) == null) {
            object = SharedIndexListLookupKt.access$getRejectAllListLookupResult$p();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> parseListJson(String lookupUrl, SharedIndexLookupRequest request, ObjectNode json) {
        void $this$mapNotNullTo$iv$iv;
        String listVersion;
        JsonNode jsonNode = json.get("list_version");
        String string = listVersion = jsonNode != null ? jsonNode.asText() : null;
        if (Intrinsics.areEqual((Object)listVersion, (Object)"1") ^ true) {
            this.LOG.trace("List Index data version mismatch. The current version is " + listVersion + " in " + lookupUrl + " for " + request);
            return null;
        }
        JsonNode jsonNode2 = json.get("names");
        if (!(jsonNode2 instanceof ArrayNode)) {
            jsonNode2 = null;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode2;
        if (arrayNode == null) {
            SharedIndexListLookup sharedIndexListLookup = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedIndexListLookup $this$run = sharedIndexListLookup;
            boolean bl3 = false;
            $this$run.LOG.trace("Index data format is incomplete. Missing 'entries' element in " + lookupUrl + " for " + request);
            return null;
        }
        ArrayNode names = arrayNode;
        Iterable $this$mapNotNull$iv = (Iterable)names;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JsonNode it = (JsonNode)element$iv$iv;
            boolean bl4 = false;
            if (it.asText() == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            String it$iv$iv = string2;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public SharedIndexListLookup() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexListLookup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
        this.cache = new SharedIndexNetworkCache<ListLookupRequest, ListLookupCacheEntry>(){

            @NotNull
            protected Instant getCreated(@NotNull ListLookupCacheEntry $this$created) {
                Intrinsics.checkNotNullParameter((Object)$this$created, (String)"$this$created");
                return $this$created.getComputed();
            }
        };
    }

    public static final /* synthetic */ Logger access$getLOG$p(SharedIndexListLookup $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ Set access$parseListJson(SharedIndexListLookup $this, String lookupUrl, SharedIndexLookupRequest request, ObjectNode json) {
        return $this.parseListJson(lookupUrl, request, json);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexListLookup$ListLookupRequest;", "", "listUrl", "", "(Ljava/lang/String;)V", "getListUrl", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.indexing.shared"})
    private static final class ListLookupRequest {
        @NotNull
        private final String listUrl;

        @NotNull
        public final String getListUrl() {
            return this.listUrl;
        }

        public ListLookupRequest(@NotNull String listUrl) {
            Intrinsics.checkNotNullParameter((Object)listUrl, (String)"listUrl");
            this.listUrl = listUrl;
        }

        @NotNull
        public final String component1() {
            return this.listUrl;
        }

        @NotNull
        public final ListLookupRequest copy(@NotNull String listUrl) {
            Intrinsics.checkNotNullParameter((Object)listUrl, (String)"listUrl");
            return new ListLookupRequest(listUrl);
        }

        public static /* synthetic */ ListLookupRequest copy$default(ListLookupRequest listLookupRequest, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = listLookupRequest.listUrl;
            }
            return listLookupRequest.copy(string);
        }

        @NotNull
        public String toString() {
            return "ListLookupRequest(listUrl=" + this.listUrl + ")";
        }

        public int hashCode() {
            String string = this.listUrl;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListLookupRequest)) break block3;
                    ListLookupRequest listLookupRequest = (ListLookupRequest)object;
                    if (!Intrinsics.areEqual((Object)this.listUrl, (Object)listLookupRequest.listUrl)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexListLookup$ListLookupCacheEntry;", "", "computed", "Ljava/time/Instant;", "checker", "Lcom/intellij/indexing/shared/download/SharedIndexListLookupResult;", "(Ljava/time/Instant;Lcom/intellij/indexing/shared/download/SharedIndexListLookupResult;)V", "getChecker", "()Lcom/intellij/indexing/shared/download/SharedIndexListLookupResult;", "getComputed", "()Ljava/time/Instant;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.indexing.shared"})
    private static final class ListLookupCacheEntry {
        @NotNull
        private final Instant computed;
        @Nullable
        private final SharedIndexListLookupResult checker;

        @NotNull
        public final Instant getComputed() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexListLookupResult getChecker() {
            return this.checker;
        }

        public ListLookupCacheEntry(@NotNull Instant computed, @Nullable SharedIndexListLookupResult checker) {
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            this.computed = computed;
            this.checker = checker;
        }

        @NotNull
        public final Instant component1() {
            return this.computed;
        }

        @Nullable
        public final SharedIndexListLookupResult component2() {
            return this.checker;
        }

        @NotNull
        public final ListLookupCacheEntry copy(@NotNull Instant computed, @Nullable SharedIndexListLookupResult checker) {
            Intrinsics.checkNotNullParameter((Object)computed, (String)"computed");
            return new ListLookupCacheEntry(computed, checker);
        }

        public static /* synthetic */ ListLookupCacheEntry copy$default(ListLookupCacheEntry listLookupCacheEntry, Instant instant, SharedIndexListLookupResult sharedIndexListLookupResult, int n, Object object) {
            if ((n & 1) != 0) {
                instant = listLookupCacheEntry.computed;
            }
            if ((n & 2) != 0) {
                sharedIndexListLookupResult = listLookupCacheEntry.checker;
            }
            return listLookupCacheEntry.copy(instant, sharedIndexListLookupResult);
        }

        @NotNull
        public String toString() {
            return "ListLookupCacheEntry(computed=" + this.computed + ", checker=" + this.checker + ")";
        }

        public int hashCode() {
            Instant instant = this.computed;
            SharedIndexListLookupResult sharedIndexListLookupResult = this.checker;
            return (instant != null ? ((Object)instant).hashCode() : 0) * 31 + (sharedIndexListLookupResult != null ? sharedIndexListLookupResult.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListLookupCacheEntry)) break block3;
                    ListLookupCacheEntry listLookupCacheEntry = (ListLookupCacheEntry)object;
                    if (!Intrinsics.areEqual((Object)this.computed, (Object)listLookupCacheEntry.computed) || !Intrinsics.areEqual((Object)this.checker, (Object)listLookupCacheEntry.checker)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

