/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.jdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.util.Computable;
import com.intellij.util.lang.JavaVersion;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\bR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/java/jdk/JdkAliases;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "computeAliasesForInstalledJdk", "", "", "jdkHome", "computeAliasesForJdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "computeAliasesForJdkVersion", "versionString", "intellij.indexing.shared.java"})
public final class JdkAliases {
    private static final Logger LOG;
    @NotNull
    public static final JdkAliases INSTANCE;

    @NotNull
    public final List<String> computeAliasesForJdk(@NotNull Sdk sdk) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        try {
            boolean $i$f$runReadAction = false;
            String string2 = (String)ApplicationManager.getApplication().runReadAction(new Computable(sdk){
                final /* synthetic */ Sdk $sdk$inlined;
                {
                    this.$sdk$inlined = sdk;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)this.$sdk$inlined.getVersionString();
                }
            });
            if (string2 == null) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            string = string2;
        }
        catch (Throwable e) {
            LOG.warn("Failed to compute SDK version for: " + sdk + ". " + e.getMessage(), e);
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        String string3 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"try {\n      runReadActio\u2026    return listOf()\n    }");
        String versionString = string3;
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)this.computeAliasesForInstalledJdk(sdk.getHomePath()), (Iterable)this.computeAliasesForJdkVersion(versionString)));
    }

    @NotNull
    public final List<String> computeAliasesForJdkVersion(@NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        try {
            JavaVersion javaVersion = JavaVersion.tryParse((String)versionString);
            if (javaVersion == null) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(ver\u2026tring) ?: return listOf()");
            JavaVersion version = javaVersion;
            Object[] objectArray = new String[2];
            String string = version.toFeatureMinorUpdateString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version.toFeatureMinorUpdateString()");
            objectArray[0] = string;
            String string2 = version.toFeatureString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"version.toFeatureString()");
            objectArray[1] = string2;
            return CollectionsKt.listOf((Object[])objectArray);
        }
        catch (Throwable e) {
            LOG.warn("Failed to compute aliases for: " + versionString + ". " + e.getMessage(), e);
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
    }

    private final List<String> computeAliasesForInstalledJdk(String jdkHome) {
        if (jdkHome == null) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        try {
            Object object = JdkInstaller.Companion.getInstance().findJdkItemForInstalledJdk(jdkHome);
            if (object == null || (object = object.getSharedIndexAliases()) == null) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            return object;
        }
        catch (Throwable e) {
            LOG.warn("Failed to get installed JDK aliases for: " + jdkHome + ". " + e.getMessage(), e);
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
    }

    private JdkAliases() {
    }

    static {
        JdkAliases jdkAliases;
        INSTANCE = jdkAliases = new JdkAliases();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JdkAliases.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

