/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.impl.SingleChunkReadonlyZipStorage;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.xmlb.annotations.Attribute;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/indexing/shared/platform/impl/BundledSharedIndexProvider;", "Lcom/intellij/openapi/extensions/PluginAware;", "()V", "chunkId", "", "getChunkId", "()Ljava/lang/String;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "pluginPath", "productPath", "resolvedChunkIdAndPath", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "getResolvedChunkIdAndPath", "()Lkotlin/Pair;", "resolvedChunkIdAndPath$delegate", "Lkotlin/Lazy;", "openChunkStorage", "Lcom/intellij/indexing/shared/platform/impl/SingleChunkReadonlyZipStorage;", "setPluginDescriptor", "", "intellij.indexing.shared"})
public final class BundledSharedIndexProvider
implements PluginAware {
    @Attribute(value="productPath")
    @JvmField
    @Nullable
    public String productPath;
    @Attribute(value="pluginPath")
    @JvmField
    @Nullable
    public String pluginPath;
    private PluginDescriptor pluginDescriptor;
    private final Lazy resolvedChunkIdAndPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pair<? extends String, ? extends Path>>(this){
        final /* synthetic */ BundledSharedIndexProvider this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Pair<String, Path> invoke() {
            Pair pair;
            try {
                List list;
                Path resolvedPath;
                Object object;
                String productPath = this.this$0.productPath;
                String pluginPath = this.this$0.pluginPath;
                if (!(productPath != null ^ pluginPath != null)) {
                    BundledSharedIndexProvider $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error("Only one parameter must be used in " + this.this$0);
                    return null;
                }
                Path path = productPath != null ? Paths.get(PathManager.getHomePath(), new String[0]).resolve(productPath) : (pluginPath != null ? ((object = BundledSharedIndexProvider.access$getPluginDescriptor$p(this.this$0)) != null && (object = object.getPluginPath()) != null ? object.resolve(pluginPath) : null) : (resolvedPath = null));
                if (resolvedPath == null) {
                    return null;
                }
                if (!PathKt.isDirectory((Path)resolvedPath)) {
                    BundledSharedIndexProvider $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.warn("Bundled shared index is not found at: " + resolvedPath);
                    return null;
                }
                String sharedIndexExtension = ".ijx";
                AutoCloseable autoCloseable = Files.list(resolvedPath);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    Stream stream = (Stream)autoCloseable;
                    boolean bl3 = false;
                    Stream<T> stream2 = stream.filter(new Predicate(sharedIndexExtension){
                        final /* synthetic */ String $sharedIndexExtension$inlined;
                        {
                            this.$sharedIndexExtension$inlined = string;
                        }

                        public final boolean test(Path it) {
                            Path path = it;
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                            return PathKt.isFile((Path)path) && StringsKt.endsWith$default((String)((Object)it.getFileName()).toString(), (String)this.$sharedIndexExtension$inlined, (boolean)false, (int)2, null);
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue(stream2, (String)"stream.filter { it.isFil\u2026h(sharedIndexExtension) }");
                    list = StreamsKt.toList(stream2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                List indexes = list;
                if (indexes.isEmpty()) {
                    BundledSharedIndexProvider $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.warn("Failed to find any bundled shared indexes at: " + resolvedPath);
                    return null;
                }
                Path path2 = (Path)CollectionsKt.singleOrNull((List)indexes);
                if (path2 == null) {
                    BundledSharedIndexProvider $i$f$thisLogger = this.this$0;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    BundledSharedIndexProvider $this$run = $i$f$thisLogger;
                    boolean bl6 = false;
                    BundledSharedIndexProvider $this$thisLogger$iv = $this$run;
                    boolean $i$f$thisLogger2 = false;
                    Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.warn("There are several shared index files found at " + resolvedPath + ": " + indexes + ". Please make sure IntelliJ was installed into an empty folder");
                    return null;
                }
                Path theBundledIndex = path2;
                BundledSharedIndexProvider $this$thisLogger$iv = this.this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.debug("Resolved bundled shared shared index: " + theBundledIndex + " (" + StringUtil.formatFileSize((long)PathKt.size((Path)theBundledIndex)));
                BundledSharedIndexProvider bundledSharedIndexProvider = this.this$0;
                boolean bl7 = false;
                boolean bl8 = false;
                BundledSharedIndexProvider $this$run = bundledSharedIndexProvider;
                boolean bl9 = false;
                String name = StringsKt.removeSuffix((String)((Object)theBundledIndex.getFileName()).toString(), (CharSequence)sharedIndexExtension);
                Object object2 = BundledSharedIndexProvider.access$getPluginDescriptor$p($this$run);
                if (object2 == null || (object2 = object2.getPluginId()) == null || (object2 = object2.getIdString()) == null) {
                    object2 = "global";
                }
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"pluginDescriptor?.pluginId?.idString ?: \"global\"");
                Object source = object2;
                StringBuilder stringBuilder = new StringBuilder().append("bundled-").append(name).append('-').append((String)source).append('-');
                ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
                String chunkId = stringBuilder.append(applicationInfo.getBuild()).toString();
                pair = TuplesKt.to((Object)chunkId, (Object)theBundledIndex);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                BundledSharedIndexProvider $this$thisLogger$iv = this.this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn("Failed to locate bundled shared index for " + BundledSharedIndexProvider.access$getPluginDescriptor$p(this.this$0) + " and " + this.this$0.pluginPath + ". " + t.getMessage(), t);
                pair = null;
            }
            return pair;
        }
        {
            this.this$0 = bundledSharedIndexProvider;
            super(0);
        }
    }));

    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        this.pluginDescriptor = pluginDescriptor;
    }

    @Nullable
    public final String getChunkId() {
        Pair<String, Path> pair = this.getResolvedChunkIdAndPath();
        if (pair == null) {
            return null;
        }
        Pair<String, Path> pair2 = pair;
        String chunkId = (String)pair2.component1();
        return chunkId;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SingleChunkReadonlyZipStorage openChunkStorage() {
        Pair<String, Path> pair = this.getResolvedChunkIdAndPath();
        if (pair == null) {
            return null;
        }
        Object object = pair;
        String string = (String)object.component1();
        Path resolvedPath = (Path)object.component2();
        try {
            void chunkId;
            object = new SingleChunkReadonlyZipStorage((String)chunkId, resolvedPath, "bundled-" + (String)chunkId);
        }
        catch (Throwable t) {
            BundledSharedIndexProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BundledSharedIndexProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Failed to load bundled shared index: " + resolvedPath + ". " + t.getMessage(), t);
            return null;
        }
        return object;
    }

    private final Pair<String, Path> getResolvedChunkIdAndPath() {
        Lazy lazy = this.resolvedChunkIdAndPath$delegate;
        BundledSharedIndexProvider bundledSharedIndexProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Pair)lazy.getValue();
    }

    public static final /* synthetic */ PluginDescriptor access$getPluginDescriptor$p(BundledSharedIndexProvider $this) {
        return $this.pluginDescriptor;
    }

    public static final /* synthetic */ void access$setPluginDescriptor$p(BundledSharedIndexProvider $this, PluginDescriptor pluginDescriptor) {
        $this.pluginDescriptor = pluginDescriptor;
    }
}

