/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.intellij.indexing.shared.platform.impl.SharedIndexMainZipStorage;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a0\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002\u001a\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0002\u001a\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0010\u001a\u00020\bH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "doTakeSnapshotRecursively", "", "", "", "root", "Ljava/nio/file/Path;", "ensureSnapshotsEqual", "", "expectedSnapshot", "actualSnapshot", "takeSourceChunkSnapshot", "chunkPath", "takeStoredChunkSnapshot", "chunkRoot", "intellij.indexing.shared"})
public final class SharedIndexMainZipStorageKt {
    private static final Logger LOG;

    private static final void ensureSnapshotsEqual(Map<String, Long> expectedSnapshot, Map<String, Long> actualSnapshot) throws IOException {
        MapDifference diff = Maps.difference(actualSnapshot, expectedSnapshot);
        Map missedFiles = diff.entriesOnlyOnLeft();
        Map differedFiles = diff.entriesDiffering();
        Map superfluousFiles = diff.entriesOnlyOnRight();
        if (missedFiles.isEmpty() && differedFiles.isEmpty() && superfluousFiles.isEmpty()) {
            return;
        }
        Map map = missedFiles;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"missedFiles");
        Map map2 = map;
        boolean bl = false;
        if (!map2.isEmpty()) {
            throw (Throwable)new IOException("Shared index chunk files " + missedFiles.keySet() + " were not copied to shared index central storage");
        }
        Map map3 = superfluousFiles;
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"superfluousFiles");
        map2 = map3;
        bl = false;
        if (!map2.isEmpty()) {
            LOG.error("Superfluous files has been observed after chunk was copied " + superfluousFiles.keySet());
            return;
        }
        Map map4 = differedFiles;
        Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"differedFiles");
        map2 = map4;
        bl = false;
        if (!map2.isEmpty()) {
            throw (Throwable)new IOException("Shared index chunk files " + differedFiles + " corrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, Long> takeSourceChunkSnapshot(Path chunkPath) {
        Map<String, Long> map;
        Closeable closeable = UncompressedZipFileSystem.create(chunkPath);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            UncompressedZipFileSystem chunkFs = (UncompressedZipFileSystem)closeable;
            boolean bl3 = false;
            UncompressedZipFileSystem uncompressedZipFileSystem = chunkFs;
            Intrinsics.checkNotNullExpressionValue((Object)uncompressedZipFileSystem, (String)"chunkFs");
            Path path = uncompressedZipFileSystem.getRootDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"chunkFs.rootDirectory");
            map = SharedIndexMainZipStorageKt.doTakeSnapshotRecursively(path);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return map;
    }

    private static final Map<String, Long> takeStoredChunkSnapshot(Path chunkRoot) {
        return SharedIndexMainZipStorageKt.doTakeSnapshotRecursively(chunkRoot);
    }

    private static final Map<String, Long> doTakeSnapshotRecursively(Path root) {
        boolean bl = false;
        Map snapshot2 = new LinkedHashMap();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(root, snapshot2){
            final /* synthetic */ Path $root;
            final /* synthetic */ Map $snapshot;

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!Files.isDirectory(file, new LinkOption[0])) {
                    String normalized = StringsKt.removePrefix((String)StringsKt.removePrefix((String)((Object)file.toAbsolutePath()).toString(), (CharSequence)((Object)this.$root).toString()), (CharSequence)"/");
                    this.$snapshot.put(normalized, Files.size(file));
                }
                return FileVisitResult.CONTINUE;
            }
            {
                this.$root = $captured_local_variable$0;
                this.$snapshot = $captured_local_variable$1;
            }
        });
        Map<String, Long> map = Collections.unmodifiableMap(snapshot2);
        Intrinsics.checkNotNullExpressionValue(map, (String)"Collections.unmodifiableMap(snapshot)");
        return map;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexMainZipStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Map access$takeSourceChunkSnapshot(Path chunkPath) {
        return SharedIndexMainZipStorageKt.takeSourceChunkSnapshot(chunkPath);
    }

    public static final /* synthetic */ Map access$takeStoredChunkSnapshot(Path chunkRoot) {
        return SharedIndexMainZipStorageKt.takeStoredChunkSnapshot(chunkRoot);
    }

    public static final /* synthetic */ void access$ensureSnapshotsEqual(Map expectedSnapshot, Map actualSnapshot) {
        SharedIndexMainZipStorageKt.ensureSnapshotsEqual(expectedSnapshot, actualSnapshot);
    }
}

