/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.indexing.shared.util.ChunkedDownloader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.LongIterator;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongProgression;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0003\u0019\u001a\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005JF\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0011JL\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/indexing/shared/util/ChunkedDownloader;", "", "bytesPerChunk", "", "maxThreads", "(II)V", "download", "", "url", "", "headers", "", "expectedSize", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "handler", "Lkotlin/Function1;", "Ljava/io/InputStream;", "submitRangeDownloads", "Ljava/util/ArrayList;", "Lcom/intellij/indexing/shared/util/ChunkedDownloader$ChunkFuture;", "Lkotlin/collections/ArrayList;", "executor", "Ljava/util/concurrent/ExecutorService;", "ChunkFuture", "CombiningInputStream", "Companion", "intellij.indexing.shared"})
public final class ChunkedDownloader {
    private final int bytesPerChunk;
    private final int maxThreads;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void download(@NotNull String url, @NotNull Map<String, String> headers, long expectedSize, @NotNull ProgressIndicator indicator, @NotNull Function1<? super InputStream, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        LOG.trace("Downloading " + url + " using " + this.maxThreads + " and a chunk size of " + this.bytesPerChunk);
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Shared index chunk downloader", (Executor)ProcessIOExecutorService.INSTANCE, (int)this.maxThreads);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026ice.INSTANCE, maxThreads)");
        ExecutorService executor = executorService;
        ArrayList<ChunkFuture> chunkFutures = this.submitRangeDownloads(executor, url, expectedSize, headers, indicator);
        try {
            Closeable closeable = new CombiningInputStream(chunkFutures, indicator);
            boolean bl = false;
            boolean bl2 = false;
            Object object = null;
            try {
                CombiningInputStream it = (CombiningInputStream)closeable;
                boolean bl3 = false;
                handler.invoke((Object)it);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                object = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        finally {
            executor.shutdownNow();
            Iterable $this$forEach$iv = chunkFutures;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChunkFuture it = (ChunkFuture)element$iv;
                boolean bl = false;
                FileUtil.delete((Path)it.getTmpFile());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<ChunkFuture> submitRangeDownloads(ExecutorService executor, String url, long expectedSize, Map<String, String> headers, ProgressIndicator indicator) {
        double d = (double)expectedSize / (double)this.bytesPerChunk;
        boolean bl = false;
        int numOfChunks = (int)Math.ceil(d);
        ArrayList<ChunkFuture> chunkFutures = new ArrayList<ChunkFuture>();
        boolean bl2 = false;
        long l = 0L;
        Iterator iterator = ((Iterable)RangesKt.step((LongProgression)((LongProgression)new LongRange(l, expectedSize)), (long)this.bytesPerChunk)).iterator();
        while (iterator.hasNext()) {
            Future<?> future2;
            void i;
            long start = ((LongIterator)iterator).nextLong();
            long l2 = start + (long)this.bytesPerChunk - 1L;
            long l3 = expectedSize - 1L;
            boolean bl3 = false;
            long end = Math.min(l2, l3);
            String range = "" + start + '-' + end;
            Path tmpFile = Files.createTempFile(StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null), "part." + (int)i, new FileAttribute[0]);
            Future<?> future3 = future2 = executor.submit(new Runnable((int)i, numOfChunks, indicator, url, range, headers, tmpFile){
                final /* synthetic */ int $i;
                final /* synthetic */ int $numOfChunks;
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ String $url;
                final /* synthetic */ String $range;
                final /* synthetic */ Map $headers;
                final /* synthetic */ Path $tmpFile;

                public final void run() {
                    ChunkedDownloader.access$getLOG$cp().trace("Downloading chunk " + this.$i + " of " + this.$numOfChunks);
                    this.$indicator.checkCanceled();
                    HttpRequests.requestWithRange((String)this.$url, (String)this.$range).productNameAsUserAgent().tuner(new HttpRequests.ConnectionTuner(this){
                        final /* synthetic */ submitRangeDownloads.future.1 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final void tune(@NotNull URLConnection tuner) {
                            Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
                            Map $this$forEach$iv = this.this$0.$headers;
                            boolean $i$f$forEach = false;
                            Map map = $this$forEach$iv;
                            boolean bl = false;
                            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                            while (iterator.hasNext()) {
                                void k;
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> $dstr$k$v = element$iv = iterator.next();
                                boolean bl2 = false;
                                Map.Entry<K, V> entry = $dstr$k$v;
                                boolean bl3 = false;
                                String string = (String)entry.getKey();
                                entry = $dstr$k$v;
                                bl3 = false;
                                String v = (String)entry.getValue();
                                tuner.addRequestProperty((String)k, v);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }).accept("application/octet-stream, application/xz").throwStatusCodeException(true).connect(new HttpRequests.RequestProcessor(this){
                        final /* synthetic */ submitRangeDownloads.future.1 this$0;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void process(@NotNull HttpRequests.Request it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.this$0.$indicator.checkCanceled();
                            Path path = this.this$0.$tmpFile;
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tmpFile");
                            Closeable closeable = PathKt.outputStream$default((Path)path, (boolean)false, (int)1, null);
                            boolean bl = false;
                            boolean bl2 = false;
                            Throwable throwable = null;
                            try {
                                OutputStream os = (OutputStream)closeable;
                                boolean bl3 = false;
                                Closeable closeable2 = it.getInputStream();
                                boolean bl4 = false;
                                boolean bl5 = false;
                                Throwable throwable2 = null;
                                try {
                                    InputStream it2 = (InputStream)closeable2;
                                    boolean bl6 = false;
                                    InputStream inputStream = it2;
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it");
                                    ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)os, (int)0, (int)2, null);
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$i = n;
                    this.$numOfChunks = n2;
                    this.$indicator = progressIndicator;
                    this.$url = string;
                    this.$range = string2;
                    this.$headers = map;
                    this.$tmpFile = path;
                }
            });
            Intrinsics.checkNotNullExpressionValue(future3, (String)"future");
            Path path = tmpFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tmpFile");
            chunkFutures.add(new ChunkFuture(future3, path));
            ++i;
        }
        return chunkFutures;
    }

    public ChunkedDownloader(int bytesPerChunk, int maxThreads) {
        this.bytesPerChunk = bytesPerChunk;
        this.maxThreads = maxThreads;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ChunkedDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(ChunkedDownloader::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/util/ChunkedDownloader$ChunkFuture;", "", "future", "Ljava/util/concurrent/Future;", "tmpFile", "Ljava/nio/file/Path;", "(Ljava/util/concurrent/Future;Ljava/nio/file/Path;)V", "getFuture", "()Ljava/util/concurrent/Future;", "getTmpFile", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.indexing.shared"})
    private static final class ChunkFuture {
        @NotNull
        private final Future<?> future;
        @NotNull
        private final Path tmpFile;

        @NotNull
        public final Future<?> getFuture() {
            return this.future;
        }

        @NotNull
        public final Path getTmpFile() {
            return this.tmpFile;
        }

        public ChunkFuture(@NotNull Future<?> future2, @NotNull Path tmpFile) {
            Intrinsics.checkNotNullParameter(future2, (String)"future");
            Intrinsics.checkNotNullParameter((Object)tmpFile, (String)"tmpFile");
            this.future = future2;
            this.tmpFile = tmpFile;
        }

        @NotNull
        public final Future<?> component1() {
            return this.future;
        }

        @NotNull
        public final Path component2() {
            return this.tmpFile;
        }

        @NotNull
        public final ChunkFuture copy(@NotNull Future<?> future2, @NotNull Path tmpFile) {
            Intrinsics.checkNotNullParameter(future2, (String)"future");
            Intrinsics.checkNotNullParameter((Object)tmpFile, (String)"tmpFile");
            return new ChunkFuture(future2, tmpFile);
        }

        public static /* synthetic */ ChunkFuture copy$default(ChunkFuture chunkFuture, Future future2, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                future2 = chunkFuture.future;
            }
            if ((n & 2) != 0) {
                path = chunkFuture.tmpFile;
            }
            return chunkFuture.copy(future2, path);
        }

        @NotNull
        public String toString() {
            return "ChunkFuture(future=" + this.future + ", tmpFile=" + this.tmpFile + ")";
        }

        public int hashCode() {
            Future<?> future2 = this.future;
            Path path = this.tmpFile;
            return (future2 != null ? future2.hashCode() : 0) * 31 + (path != null ? ((Object)path).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ChunkFuture)) break block3;
                    ChunkFuture chunkFuture = (ChunkFuture)object;
                    if (!Intrinsics.areEqual(this.future, chunkFuture.future) || !Intrinsics.areEqual((Object)this.tmpFile, (Object)chunkFuture.tmpFile)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0001H\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0016J \u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0016R!\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lcom/intellij/indexing/shared/util/ChunkedDownloader$CombiningInputStream;", "Ljava/io/InputStream;", "chunkFutures", "Ljava/util/ArrayList;", "Lcom/intellij/indexing/shared/util/ChunkedDownloader$ChunkFuture;", "Lkotlin/collections/ArrayList;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Ljava/util/ArrayList;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getChunkFutures", "()Ljava/util/ArrayList;", "currentInputStream", "Lkotlin/Lazy;", "getCurrentInputStream", "()Lkotlin/Lazy;", "setCurrentInputStream", "(Lkotlin/Lazy;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "close", "", "getNextStream", "read", "b", "", "off", "len", "intellij.indexing.shared"})
    private static final class CombiningInputStream
    extends InputStream {
        @NotNull
        private Lazy<? extends InputStream> currentInputStream;
        private int index;
        @NotNull
        private final ArrayList<ChunkFuture> chunkFutures;
        @NotNull
        private final ProgressIndicator indicator;

        @NotNull
        public final Lazy<InputStream> getCurrentInputStream() {
            return this.currentInputStream;
        }

        public final void setCurrentInputStream(@NotNull Lazy<? extends InputStream> lazy) {
            Intrinsics.checkNotNullParameter(lazy, (String)"<set-?>");
            this.currentInputStream = lazy;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @Override
        public int read() {
            byte[] tmp = new byte[1];
            if (this.read(tmp, 0, 1) != 1) {
                return -1;
            }
            return tmp[0] & 0xFF;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.indicator.checkCanceled();
            int result2 = ((InputStream)this.currentInputStream.getValue()).read(b, off, len);
            if (result2 == -1) {
                if (this.chunkFutures.size() <= this.index) {
                    return result2;
                }
                ((InputStream)this.currentInputStream.getValue()).close();
                this.currentInputStream = LazyKt.lazyOf((Object)this.getNextStream());
                return this.read(b, off, len);
            }
            return result2;
        }

        @Override
        public void close() {
            ((InputStream)this.currentInputStream.getValue()).close();
        }

        private final InputStream getNextStream() {
            ProgressIndicatorUtils.awaitWithCheckCanceled(this.chunkFutures.get(this.index).getFuture(), (ProgressIndicator)this.indicator);
            int n = this.index;
            this.index = n + 1;
            File file = this.chunkFutures.get(n).getTmpFile().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"chunkFutures[index++].tmpFile.toFile()");
            Object object = file;
            int n2 = 0;
            object = new FileInputStream((File)object);
            n2 = 0x100000;
            boolean bl = false;
            return object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n2);
        }

        @NotNull
        public final ArrayList<ChunkFuture> getChunkFutures() {
            return this.chunkFutures;
        }

        @NotNull
        public final ProgressIndicator getIndicator() {
            return this.indicator;
        }

        public CombiningInputStream(@NotNull ArrayList<ChunkFuture> chunkFutures, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter(chunkFutures, (String)"chunkFutures");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.chunkFutures = chunkFutures;
            this.indicator = indicator;
            this.currentInputStream = LazyKt.lazy((Function0)((Function0)new Function0<InputStream>(this){
                final /* synthetic */ CombiningInputStream this$0;

                @NotNull
                public final InputStream invoke() {
                    return CombiningInputStream.access$getNextStream(this.this$0);
                }
                {
                    this.this$0 = combiningInputStream;
                    super(0);
                }
            }));
        }

        public static final /* synthetic */ InputStream access$getNextStream(CombiningInputStream $this) {
            return $this.getNextStream();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/indexing/shared/util/ChunkedDownloader$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.indexing.shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

