/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.components;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.datavis.r.VisualizationBundle;
import org.intellij.datavis.r.inlays.InlayExecutorKt;
import org.intellij.datavis.r.inlays.components.ColoredTextConsole;
import org.intellij.datavis.r.inlays.components.EmptySoftWrapPainter;
import org.intellij.datavis.r.inlays.components.InlayOutput;
import org.intellij.datavis.r.inlays.components.InlayOutputKt;
import org.intellij.datavis.r.inlays.components.InlayOutputText;
import org.intellij.datavis.r.inlays.components.InlayOutputText$addData$1$$special$;
import org.intellij.datavis.r.inlays.components.ProcessOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00112\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u001cH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/intellij/datavis/r/inlays/components/InlayOutputText;", "Lorg/intellij/datavis/r/inlays/components/InlayOutput;", "parent", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearAction", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)V", "console", "Lorg/intellij/datavis/r/inlays/components/ColoredTextConsole;", "scrollPaneTopBorderHeight", "", "acceptType", "", "type", "", "addData", "message", "outputType", "Lcom/intellij/openapi/util/Key;", "data", "clear", "getCollapsedDescription", "saveAs", "scrollToTop", "updateSize", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.notebooks.visualization"})
public final class InlayOutputText
extends InlayOutput {
    private final ColoredTextConsole console;
    private final int scrollPaneTopBorderHeight;

    @Override
    public void clear() {
        this.console.clear();
    }

    @Override
    public void addData(@NotNull String data, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        InlayExecutorKt.runAsyncInlay((Function0)new Function0<Unit>(this, data){
            final /* synthetic */ InlayOutputText this$0;
            final /* synthetic */ String $data;

            public final void invoke() {
                List list;
                File file = new File(this.$data);
                boolean bl = false;
                boolean bl2 = false;
                File it = file;
                boolean bl3 = false;
                File file2 = it.exists() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"json") ? file : null;
                if (file2 != null) {
                    file = file2;
                    bl = false;
                    bl2 = false;
                    File file3 = file;
                    boolean bl4 = false;
                    list = (List)new Gson().fromJson(FilesKt.readText$default((File)file3, null, (int)1, null), new TypeToken<List<? extends ProcessOutput>>(){}.getType());
                } else {
                    list = null;
                }
                file = list;
                bl = false;
                bl2 = false;
                File outputs = file;
                boolean bl5 = false;
                SwingUtilities.invokeLater(new Runnable((List)((Object)outputs), this){
                    final /* synthetic */ List $outputs;
                    final /* synthetic */ addData.1 this$0;
                    {
                        this.$outputs = list;
                        this.this$0 = var2_2;
                    }

                    public final void run() {
                        block4: {
                            if (this.$outputs == null) {
                                ColoredTextConsole coloredTextConsole = InlayOutputText.access$getConsole$p(this.this$0.this$0);
                                String string = StringsKt.trimEnd((String)StringsKt.replace$default((String)this.this$0.$data, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (char[])new char[]{'\n'});
                                ProcessOutputType processOutputType = ProcessOutputType.STDOUT;
                                Intrinsics.checkNotNullExpressionValue((Object)processOutputType, (String)"ProcessOutputType.STDOUT");
                                coloredTextConsole.addData(string, (Key)processOutputType);
                            } else {
                                Iterable $this$forEach$iv = this.$outputs;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    ProcessOutput it = (ProcessOutput)element$iv;
                                    boolean bl = false;
                                    InlayOutputText.access$getConsole$p(this.this$0.this$0).addData(it.getText(), it.getKind());
                                }
                            }
                            InlayOutputText.access$getConsole$p(this.this$0.this$0).flushDeferredText();
                            Editor editor = InlayOutputText.access$getConsole$p(this.this$0.this$0).getEditor();
                            if (!(editor instanceof EditorImpl)) {
                                editor = null;
                            }
                            EditorImpl editorImpl = (EditorImpl)editor;
                            if (editorImpl == null) break block4;
                            EditorImpl editorImpl2 = editorImpl;
                            boolean bl = false;
                            boolean bl2 = false;
                            EditorImpl $this$apply = editorImpl2;
                            boolean bl3 = false;
                            InlayOutputText.access$updateSize(this.this$0.this$0, $this$apply);
                            $this$apply.getSoftWrapModel().setSoftWrapPainter((SoftWrapPainter)EmptySoftWrapPainter.INSTANCE);
                            $this$apply.getSoftWrapModel().addSoftWrapChangeListener(new SoftWrapChangeListener($this$apply, this){
                                final /* synthetic */ EditorImpl $this_apply;
                                final /* synthetic */ addData$1$$special$$inlined$let$lambda$1 this$0;
                                {
                                    this.$this_apply = $receiver;
                                    this.this$0 = var2_2;
                                }

                                public void recalculationEnds() {
                                    InlayOutputText.access$updateSize(this.this$0.this$0.this$0, this.$this_apply);
                                }

                                public void softWrapsChanged() {
                                }
                            });
                        }
                    }
                });
            }
            {
                this.this$0 = inlayOutputText;
                this.$data = string;
                super(0);
            }
        });
    }

    private final void updateSize(EditorImpl editor) {
        block0: {
            boolean bl = false;
            boolean bl2 = false;
            EditorImpl $this$with = editor;
            boolean bl3 = false;
            DocumentEx documentEx = $this$with.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"document");
            int textHeight = $this$with.offsetToXY((int)documentEx.getTextLength()).y + $this$with.getLineHeight() + this.scrollPaneTopBorderHeight;
            JComponent jComponent = $this$with.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"component");
            jComponent.setPreferredSize(new Dimension($this$with.getPreferredSize().width, textHeight));
            Function1<Integer, Unit> function1 = this.getOnHeightCalculated();
            if (function1 == null) break block0;
            int n = this.getToolbarPane().getPreferredSize().height;
            boolean bl4 = false;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)Math.max(textHeight, n));
        }
    }

    public final void addData(@NotNull String message, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        this.console.addData(message, outputType);
    }

    @Override
    public void scrollToTop() {
        this.console.scrollTo(0);
    }

    @Override
    @NotNull
    public String getCollapsedDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.console.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"console.text");
        String string2 = string;
        int n = 0;
        int n2 = this.console.getText().length();
        int n3 = 60;
        boolean bl = false;
        n2 = Math.min(n2, n3);
        n3 = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return stringBuilder.append(string4).append(" .....").toString();
    }

    @Override
    public boolean acceptType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"TEXT");
    }

    @Override
    public void saveAs() {
        String title = VisualizationBundle.INSTANCE.message("inlay.action.export.as.txt.title", new Object[0]);
        String description = VisualizationBundle.INSTANCE.message("inlay.action.export.as.txt.description", new Object[0]);
        this.saveWithFileChooser(title, description, new String[]{"txt"}, "output", (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this){
            final /* synthetic */ InlayOutputText this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull File destination) {
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                Object object = destination;
                Charset charset = Charsets.UTF_8;
                int n = 8192;
                boolean bl = false;
                Object object2 = object;
                boolean bl2 = false;
                Object object3 = object2;
                boolean bl3 = false;
                object3 = new FileOutputStream((File)object3);
                bl3 = false;
                object2 = new OutputStreamWriter((OutputStream)object3, charset);
                bl2 = false;
                object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
                boolean bl4 = false;
                n = 0;
                Throwable throwable = null;
                try {
                    BufferedWriter out = (BufferedWriter)object;
                    boolean bl5 = false;
                    out.write(InlayOutputText.access$getConsole$p(this.this$0).getText());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            {
                this.this$0 = inlayOutputText;
                super(1);
            }
        }));
    }

    public InlayOutputText(@NotNull Disposable parent, final @NotNull Editor editor, @NotNull Function0<Unit> clearAction2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(clearAction2, (String)"clearAction");
        super(parent, editor, clearAction2);
        this.console = new ColoredTextConsole(this.getProject(), true);
        this.scrollPaneTopBorderHeight = 5;
        Disposer.register((Disposable)parent, (Disposable)((Disposable)this.console));
        this.getToolbarPane().setDataComponent(this.console.getComponent());
        InlayOutputKt.initOutputTextConsole(editor, parent, this.console, this.scrollPaneTopBorderHeight);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect((Disposable)this.console).subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public final void globalSchemeChange(@Nullable EditorColorsScheme it) {
                Editor editor2 = console.getEditor();
                if (editor2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                }
                EditorEx editorEx = (EditorEx)editor2;
                boolean bl = false;
                boolean bl2 = false;
                EditorEx $this$apply = editorEx;
                boolean bl3 = false;
                InlayOutputKt.updateOutputTextConsoleUI(console, editor);
                $this$apply.getComponent().repaint();
            }
        });
    }

    public static final /* synthetic */ void access$updateSize(InlayOutputText $this, EditorImpl editor) {
        $this.updateSize(editor);
    }
}

