/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.table.paging;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.ComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.datavis.r.VisualizationBundle;
import org.intellij.datavis.r.inlays.dataframe.DataFrame;
import org.intellij.datavis.r.inlays.table.DataFrameTableModel;
import org.intellij.datavis.r.inlays.table.PagingTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0012\u0010&\u001a\u00020\"2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010'\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/intellij/datavis/r/inlays/table/paging/TablePaginator;", "Ljavax/swing/JPanel;", "()V", "currentPage", "Ljavax/swing/JTextField;", "currentPageChanging", "", "label", "Ljavax/swing/JLabel;", "getLabel", "()Ljavax/swing/JLabel;", "rowsNumber", "Lcom/intellij/openapi/ui/ComboBox;", "", "value", "Ljavax/swing/JTable;", "table", "getTable", "()Ljavax/swing/JTable;", "setTable", "(Ljavax/swing/JTable;)V", "tableModel", "Lorg/intellij/datavis/r/inlays/table/PagingTableModel;", "getTableModel", "()Lorg/intellij/datavis/r/inlays/table/PagingTableModel;", "setTableModel", "(Lorg/intellij/datavis/r/inlays/table/PagingTableModel;)V", "toFirst", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "toLast", "toNext", "toPrevious", "totalPages", "cleanUp", "", "createActionButtons", "getDataFrame", "Lorg/intellij/datavis/r/inlays/dataframe/DataFrame;", "setUp", "updateInfo", "intellij.notebooks.visualization"})
public final class TablePaginator
extends JPanel {
    private final ComboBox<Integer> rowsNumber = new ComboBox((Object[])new Integer[]{10, 15, 30, 100});
    private ActionButton toFirst;
    private ActionButton toPrevious;
    private ActionButton toNext;
    private ActionButton toLast;
    private JTextField currentPage = new JTextField();
    private final JLabel totalPages = new JLabel();
    private boolean currentPageChanging;
    @NotNull
    private final JLabel label = new JLabel();
    @Nullable
    private JTable table;
    @Nullable
    private PagingTableModel tableModel;

    @NotNull
    public final JLabel getLabel() {
        return this.label;
    }

    @Nullable
    public final JTable getTable() {
        return this.table;
    }

    public final void setTable(@Nullable JTable value) {
        if (Intrinsics.areEqual((Object)this.table, (Object)value)) {
            return;
        }
        this.cleanUp();
        this.setUp(value);
        this.table = value;
    }

    @Nullable
    public final PagingTableModel getTableModel() {
        return this.tableModel;
    }

    public final void setTableModel(@Nullable PagingTableModel pagingTableModel) {
        this.tableModel = pagingTableModel;
    }

    private final void cleanUp() {
        int i;
        if (this.table == null) {
            return;
        }
        if (this.getParent() != null) {
            Container capturedParent = this.getParent();
            capturedParent.remove(this);
            capturedParent.revalidate();
        }
        JTable jTable = this.table;
        Intrinsics.checkNotNull((Object)jTable);
        int n = jTable.getColumnCount();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n2;
            int n5 = n2++;
            int[] nArray2 = nArray;
            boolean bl = false;
            nArray2[n5] = n3 = 75;
        }
        int[] columnWidths = nArray;
        n = 0;
        JTable jTable2 = this.table;
        Intrinsics.checkNotNull((Object)jTable2);
        int n6 = jTable2.getColumnCount();
        while (n < n6) {
            JTable jTable3 = this.table;
            Intrinsics.checkNotNull((Object)jTable3);
            TableColumn tableColumn = jTable3.getColumnModel().getColumn(i);
            Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"table!!.columnModel.getColumn(i)");
            columnWidths[i] = tableColumn.getWidth();
            ++i;
        }
        JTable jTable4 = this.table;
        Intrinsics.checkNotNull((Object)jTable4);
        JTable jTable5 = this.table;
        Intrinsics.checkNotNull((Object)jTable5);
        jTable4.setModel(new DataFrameTableModel(this.getDataFrame(jTable5)));
        JTable jTable6 = this.table;
        Intrinsics.checkNotNull((Object)jTable6);
        n6 = jTable6.getColumnCount();
        for (i = 0; i < n6; ++i) {
            JTable jTable7 = this.table;
            Intrinsics.checkNotNull((Object)jTable7);
            TableColumn tableColumn = jTable7.getColumnModel().getColumn(i);
            Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"table!!.columnModel.getColumn(i)");
            tableColumn.setPreferredWidth(columnWidths[i]);
        }
    }

    private final DataFrame getDataFrame(JTable table) {
        DataFrame dataFrame;
        if (table.getModel() instanceof DataFrameTableModel) {
            TableModel tableModel = table.getModel();
            if (tableModel == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.intellij.datavis.r.inlays.table.DataFrameTableModel");
            }
            dataFrame = ((DataFrameTableModel)tableModel).getDataFrame();
        } else {
            TableModel tableModel = table.getModel();
            if (tableModel == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.intellij.datavis.r.inlays.table.PagingTableModel");
            }
            dataFrame = ((PagingTableModel)tableModel).getDataFrame();
        }
        return dataFrame;
    }

    private final void setUp(JTable table) {
        Container container;
        if (table == null) {
            return;
        }
        Container container2 = table.getParent();
        if (!((container2 != null && (container2 = container2.getParent()) != null ? container2.getParent() : (container = null)) instanceof JPanel)) {
            container = null;
        }
        JPanel jPanel = (JPanel)container;
        if (jPanel == null) {
            return;
        }
        JPanel parentPanel = jPanel;
        parentPanel.add((Component)this, "Last");
        parentPanel.revalidate();
        if (table.getModel() instanceof PagingTableModel) {
            TableModel tableModel = table.getModel();
            if (tableModel == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.intellij.datavis.r.inlays.table.PagingTableModel");
            }
            this.tableModel = (PagingTableModel)tableModel;
        } else {
            int i;
            this.tableModel = new PagingTableModel(this.getDataFrame(table));
            int n = table.getColumnCount();
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n2;
                int n5 = n2++;
                int[] nArray2 = nArray;
                boolean bl = false;
                nArray2[n5] = n3 = 75;
            }
            int[] columnWidths = nArray;
            n = 0;
            int n6 = table.getColumnCount();
            while (n < n6) {
                TableColumn tableColumn = table.getColumnModel().getColumn(i);
                Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"table.columnModel.getColumn(i)");
                columnWidths[i] = tableColumn.getWidth();
                ++i;
            }
            table.setModel(this.tableModel);
            n6 = table.getColumnCount();
            for (i = 0; i < n6; ++i) {
                TableColumn tableColumn = table.getColumnModel().getColumn(i);
                Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"table.columnModel.getColumn(i)");
                tableColumn.setPreferredWidth(columnWidths[i]);
            }
            PagingTableModel pagingTableModel = this.tableModel;
            Intrinsics.checkNotNull((Object)pagingTableModel);
            Object object = this.rowsNumber.getSelectedItem();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            pagingTableModel.setPageSize((Integer)object);
        }
        if (table.getRowSorter() != null) {
            table.getRowSorter().addRowSorterListener(new RowSorterListener(this, table){
                final /* synthetic */ TablePaginator this$0;
                final /* synthetic */ JTable $table;

                public final void sorterChanged(RowSorterEvent e) {
                    RowSorterEvent rowSorterEvent = e;
                    Intrinsics.checkNotNullExpressionValue((Object)rowSorterEvent, (String)"e");
                    if (rowSorterEvent.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                        int sortColumn = -1;
                        boolean sortDescending = false;
                        RowSorter<? extends TableModel> rowSorter = this.$table.getRowSorter();
                        if (rowSorter != null) {
                            Iterator<RowSorter.SortKey> iterator = rowSorter.getSortKeys().iterator();
                            while (iterator.hasNext()) {
                                RowSorter.SortKey sortKey;
                                RowSorter.SortKey sortKey2 = sortKey = iterator.next();
                                Intrinsics.checkNotNullExpressionValue((Object)sortKey2, (String)"sortKey");
                                if (sortKey2.getSortOrder() == SortOrder.UNSORTED) continue;
                                sortColumn = sortKey.getColumn();
                                sortDescending = sortKey.getSortOrder() == SortOrder.DESCENDING;
                                break;
                            }
                        }
                        if (sortColumn != -1) {
                            DataFrame dataFrame = TablePaginator.access$getDataFrame(this.this$0, this.$table);
                            dataFrame.sortBy(dataFrame.get(sortColumn).getName(), sortDescending);
                            TableModel tableModel = this.$table.getModel();
                            if (tableModel == null) {
                                throw new NullPointerException("null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
                            }
                            ((AbstractTableModel)tableModel).fireTableDataChanged();
                        }
                    }
                }
                {
                    this.this$0 = tablePaginator;
                    this.$table = jTable;
                }
            });
        }
        this.updateInfo();
    }

    private final void updateInfo() {
        this.currentPageChanging = true;
        Object[] objectArray = new Object[3];
        PagingTableModel pagingTableModel = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel);
        int n = pagingTableModel.getPageOffset();
        PagingTableModel pagingTableModel2 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel2);
        objectArray[0] = n * pagingTableModel2.getPageSize() + 1;
        PagingTableModel pagingTableModel3 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel3);
        int n2 = pagingTableModel3.getPageOffset();
        PagingTableModel pagingTableModel4 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel4);
        int n3 = n2 * pagingTableModel4.getPageSize();
        PagingTableModel pagingTableModel5 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel5);
        objectArray[1] = n3 + pagingTableModel5.getRowCount();
        PagingTableModel pagingTableModel6 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel6);
        objectArray[2] = pagingTableModel6.getRealRowCount();
        this.label.setText(VisualizationBundle.INSTANCE.message("paginator.displaying", objectArray));
        PagingTableModel pagingTableModel7 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel7);
        this.currentPage.setText(String.valueOf(pagingTableModel7.getPageOffset() + 1));
        Object[] objectArray2 = new Object[1];
        PagingTableModel pagingTableModel8 = this.tableModel;
        Intrinsics.checkNotNull((Object)pagingTableModel8);
        objectArray2[0] = String.valueOf(pagingTableModel8.getPageCount());
        this.totalPages.setText(VisualizationBundle.INSTANCE.message("paginator.of", objectArray2));
        this.currentPageChanging = false;
    }

    private final void createActionButtons() {
        AnAction action2 = new AnAction(this, VisualizationBundle.INSTANCE.message("paginator.first.page.text", new Object[0]), VisualizationBundle.INSTANCE.message("paginator.first.page.description", new Object[0]), AllIcons.Actions.Play_first){
            final /* synthetic */ TablePaginator this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PagingTableModel pagingTableModel = this.this$0.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel);
                pagingTableModel.setPageOffset(0);
                TablePaginator.access$updateInfo(this.this$0);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        this.toFirst = new ActionButton(action2, action2.getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        action2 = new AnAction(this, VisualizationBundle.INSTANCE.message("paginator.previous.page.text", new Object[0]), VisualizationBundle.INSTANCE.message("paginator.previous.page.description", new Object[0]), AllIcons.Actions.Play_back){
            final /* synthetic */ TablePaginator this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PagingTableModel pagingTableModel = this.this$0.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel);
                int n = pagingTableModel.getPageOffset();
                pagingTableModel.setPageOffset(n + -1);
                TablePaginator.access$updateInfo(this.this$0);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        this.toPrevious = new ActionButton(action2, (action2).getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        action2 = new AnAction(this, VisualizationBundle.INSTANCE.message("paginator.next.page.text", new Object[0]), VisualizationBundle.INSTANCE.message("paginator.next.page.description", new Object[0]), AllIcons.Actions.Play_forward){
            final /* synthetic */ TablePaginator this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PagingTableModel pagingTableModel = this.this$0.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel);
                int n = pagingTableModel.getPageOffset();
                pagingTableModel.setPageOffset(n + 1);
                TablePaginator.access$updateInfo(this.this$0);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        this.toNext = new ActionButton(action2, (action2).getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        action2 = new AnAction(this, VisualizationBundle.INSTANCE.message("paginator.last.page.text", new Object[0]), VisualizationBundle.INSTANCE.message("paginator.last.page.description", new Object[0]), AllIcons.Actions.Play_last){
            final /* synthetic */ TablePaginator this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PagingTableModel pagingTableModel = this.this$0.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel);
                PagingTableModel pagingTableModel2 = this.this$0.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel2);
                pagingTableModel.setPageOffset(pagingTableModel2.getPageCount() - 1);
                TablePaginator.access$updateInfo(this.this$0);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        this.toLast = new ActionButton(action2, (action2).getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    public TablePaginator() {
        super(new BorderLayout());
        JComponent editorComponent;
        this.createActionButtons();
        this.currentPage.getDocument().addDocumentListener(new DocumentListener(){

            private final int currentPageIndex() {
                String string = currentPage.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentPage.text");
                Integer index = StringsKt.toIntOrNull((String)string);
                if (index == null) {
                    PagingTableModel pagingTableModel = this.getTableModel();
                    Intrinsics.checkNotNull((Object)pagingTableModel);
                    return pagingTableModel.getPageOffset();
                }
                return index;
            }

            private final void updatePageOffset() {
                if (currentPageChanging) {
                    return;
                }
                PagingTableModel pagingTableModel = this.getTableModel();
                if (pagingTableModel != null) {
                    pagingTableModel.setPageOffset(this.currentPageIndex() - 1);
                }
                JLabel jLabel = this.getLabel();
                Object[] objectArray = new Object[3];
                PagingTableModel pagingTableModel2 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel2);
                int n = pagingTableModel2.getPageOffset();
                PagingTableModel pagingTableModel3 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel3);
                objectArray[0] = n * pagingTableModel3.getPageSize() + 1;
                PagingTableModel pagingTableModel4 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel4);
                int n2 = pagingTableModel4.getPageOffset();
                PagingTableModel pagingTableModel5 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel5);
                int n3 = n2 * pagingTableModel5.getPageSize();
                PagingTableModel pagingTableModel6 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel6);
                objectArray[1] = n3 + pagingTableModel6.getRowCount();
                PagingTableModel pagingTableModel7 = this.getTableModel();
                Intrinsics.checkNotNull((Object)pagingTableModel7);
                objectArray[2] = pagingTableModel7.getRealRowCount();
                jLabel.setText(VisualizationBundle.INSTANCE.message("paginator.displaying", objectArray));
            }

            @Override
            public void changedUpdate(@Nullable DocumentEvent e) {
                this.updatePageOffset();
            }

            @Override
            public void insertUpdate(@Nullable DocumentEvent e) {
                this.updatePageOffset();
            }

            @Override
            public void removeUpdate(@Nullable DocumentEvent e) {
                this.updatePageOffset();
            }
        });
        this.rowsNumber.setEditable(true);
        ComboBoxEditor comboBoxEditor = this.rowsNumber.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)comboBoxEditor, (String)"rowsNumber.editor");
        Component component = comboBoxEditor.getEditorComponent();
        if (!(component instanceof JComponent)) {
            component = null;
        }
        JComponent jComponent = editorComponent = (JComponent)component;
        if (jComponent != null) {
            jComponent.putClientProperty("AuxEditorComponent", true);
        }
        this.rowsNumber.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                if (rowsNumber.getSelectedItem() instanceof Integer) {
                    PagingTableModel pagingTableModel = this.getTableModel();
                    if (pagingTableModel != null) {
                        Object object = rowsNumber.getSelectedItem();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        pagingTableModel.setPageSize((Integer)object);
                    }
                    this.updateInfo();
                }
            }
        });
        JPanel rightPanel = new JPanel();
        rightPanel.add((Component)this.rowsNumber);
        this.add((Component)rightPanel, "After");
        JPanel panel = new JPanel(new FlowLayout(0));
        ActionButton actionButton = this.toFirst;
        if (actionButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toFirst");
        }
        panel.add((Component)actionButton);
        ActionButton actionButton2 = this.toPrevious;
        if (actionButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toPrevious");
        }
        panel.add((Component)actionButton2);
        panel.add(new JToolBar.Separator());
        panel.add(new JLabel(VisualizationBundle.INSTANCE.message("paginator.label.page", new Object[0])));
        this.currentPage.putClientProperty("AuxEditorComponent", true);
        panel.add(this.currentPage);
        panel.add(this.totalPages);
        panel.add(new JToolBar.Separator());
        ActionButton actionButton3 = this.toNext;
        if (actionButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toNext");
        }
        panel.add((Component)actionButton3);
        ActionButton actionButton4 = this.toLast;
        if (actionButton4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toLast");
        }
        panel.add((Component)actionButton4);
        panel.add(new JToolBar.Separator());
        panel.add(this.label);
        this.add((Component)panel, "Before");
    }

    public static final /* synthetic */ DataFrame access$getDataFrame(TablePaginator $this, JTable table) {
        return $this.getDataFrame(table);
    }

    public static final /* synthetic */ void access$setCurrentPage$p(TablePaginator $this, JTextField jTextField) {
        $this.currentPage = jTextField;
    }

    public static final /* synthetic */ void access$setCurrentPageChanging$p(TablePaginator $this, boolean bl) {
        $this.currentPageChanging = bl;
    }
}

