/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.editor;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.editor.NotebookCellGutterController;
import org.jetbrains.plugins.notebooks.editor.NotebookCellInlayController;
import org.jetbrains.plugins.notebooks.editor.NotebookCellInlayManager;
import org.jetbrains.plugins.notebooks.editor.NotebookCellLines;
import org.jetbrains.plugins.notebooks.editor.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.editor.NotebookEditorAppearanceProviderKt;
import org.jetbrains.plugins.notebooks.editor.NotebookVisualizationUiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/CellBackgroundGutterController;", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellGutterController;", "()V", "paint", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "intervalIterator", "", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Interval;", "visualLineStart", "", "visualLineEnd", "logicalLineStart", "logicalLineEnd", "paintCaretRow", "lines", "Lkotlin/ranges/IntRange;", "intellij.notebooks.visualization"})
public final class CellBackgroundGutterController
implements NotebookCellGutterController {
    @Override
    public void paint(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull ListIterator<NotebookCellLines.Interval> intervalIterator, int visualLineStart, int visualLineEnd, int logicalLineStart, int logicalLineEnd) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter(intervalIterator, (String)"intervalIterator");
        NotebookCellLines notebookCellLines = NotebookCellLines.Companion.get((Editor)editor);
        NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)editor);
        if (notebookCellInlayManager == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Register inlay manager first"));
        }
        NotebookCellInlayManager notebookCellInlayManager2 = notebookCellInlayManager;
        NotebookCellLines.Interval interval = intervalIterator.next();
        int top = editor.offsetToXY((int)editor.getDocument().getLineStartOffset((int)interval.getLines().getFirst())).y;
        int height = editor.offsetToXY((int)editor.getDocument().getLineEndOffset((int)interval.getLines().getLast())).y + editor.getLineHeight() - top;
        NotebookEditorAppearance appearance = NotebookEditorAppearanceProviderKt.getNotebookAppearance((Editor)editor);
        if (interval.getType() == NotebookCellLines.CellType.CODE) {
            boolean $i$f$paintNotebookCellBackgroundGutter = false;
            NotebookEditorAppearance appearance$iv = NotebookEditorAppearanceProviderKt.getNotebookAppearance((Editor)editor);
            Color stripe$iv = appearance$iv.getCellStripeColor(editor, interval);
            Color stripeHover$iv = appearance$iv.getCellStripeHoverColor(editor, interval);
            int borderWidth$iv = appearance$iv.getLeftBorderWidth();
            int rectBorderCellX$iv = r.width - borderWidth$iv;
            EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
            g.setColor(appearance$iv.getCodeCellBackground(editorColorsScheme));
            if (editor.getEditorKind() == EditorKind.DIFF) {
                g.fillRect(rectBorderCellX$iv + 3, top, borderWidth$iv - 3, height);
            } else {
                g.fillRect(rectBorderCellX$iv, top, borderWidth$iv, height);
            }
            boolean bl = false;
            this.paintCaretRow(editor, g, interval.getLines());
            if (editor.getEditorKind() != EditorKind.DIFF) {
                if (stripe$iv != null) {
                    NotebookVisualizationUiUtilKt.paintCellStripe(appearance$iv, g, r, stripe$iv, top, height);
                }
                if (stripeHover$iv != null) {
                    g.setColor(stripeHover$iv);
                    g.fillRect(r.width - appearance$iv.getLeftBorderWidth(), top, appearance$iv.getCellLeftLineHoverWidth(), height);
                }
            }
        } else {
            if (editor.getEditorKind() == EditorKind.DIFF) {
                return;
            }
            this.paintCaretRow(editor, g, interval.getLines());
            Color color = appearance.getCellStripeColor(editor, interval);
            if (color != null) {
                Color $i$f$paintNotebookCellBackgroundGutter = color;
                boolean bl = false;
                boolean bl2 = false;
                Color it = $i$f$paintNotebookCellBackgroundGutter;
                boolean bl3 = false;
                NotebookVisualizationUiUtilKt.paintCellStripe(appearance, g, r, it, top, height);
            }
        }
        for (NotebookCellInlayController controller : notebookCellInlayManager2.inlaysForInterval(interval)) {
            controller.paintGutter(editor, g, r, notebookCellLines.getIntervals().listIterator(interval.getOrdinal()));
        }
    }

    private final void paintCaretRow(EditorImpl editor, Graphics g, IntRange lines) {
        EditorSettings editorSettings = editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        if (editorSettings.isCaretRowShown()) {
            CaretModelImpl caretModelImpl = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModelImpl, (String)"editor.caretModel");
            CaretModelImpl caretModel = caretModelImpl;
            int caretLine = caretModel.getLogicalPosition().line;
            if (lines.contains(caretLine)) {
                g.setColor(editor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR));
                g.fillRect(0, editor.visualLineToY(caretModel.getVisualPosition().line), g.getClipBounds().width, editor.getLineHeight());
            }
        }
    }
}

