/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.editor.NotebookCellLinesProviderKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010*\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\bf\u0018\u0000 \u00152\u00020\u0001:\u0006\u0014\u0015\u0016\u0017\u0018\u0019J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines;", "", "intervalListeners", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$IntervalListener;", "getIntervalListeners", "()Lcom/intellij/util/EventDispatcher;", "intervals", "", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Interval;", "getIntervals", "()Ljava/util/List;", "modificationStamp", "", "getModificationStamp", "()J", "intervalsIterator", "", "startLine", "", "CellType", "Companion", "Interval", "IntervalListener", "Marker", "MarkersAtLines", "intellij.notebooks.visualization"})
public interface NotebookCellLines {
    @NotNull
    public static final Companion Companion = org.jetbrains.plugins.notebooks.editor.NotebookCellLines$Companion.$$INSTANCE;

    @NotNull
    public ListIterator<Interval> intervalsIterator(int var1);

    @NotNull
    public List<Interval> getIntervals();

    @NotNull
    public EventDispatcher<IntervalListener> getIntervalListeners();

    public long getModificationStamp();

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$CellType;", "", "(Ljava/lang/String;I)V", "CODE", "MARKDOWN", "RAW", "intellij.notebooks.visualization"})
    public static final class CellType
    extends Enum<CellType> {
        public static final /* enum */ CellType CODE;
        public static final /* enum */ CellType MARKDOWN;
        public static final /* enum */ CellType RAW;
        private static final /* synthetic */ CellType[] $VALUES;

        static {
            CellType[] cellTypeArray = new CellType[3];
            CellType[] cellTypeArray2 = cellTypeArray;
            cellTypeArray[0] = CODE = new CellType();
            cellTypeArray[1] = MARKDOWN = new CellType();
            cellTypeArray[2] = RAW = new CellType();
            $VALUES = cellTypeArray;
        }

        public static CellType[] values() {
            return (CellType[])$VALUES.clone();
        }

        public static CellType valueOf(String string) {
            return Enum.valueOf(CellType.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Marker;", "", "ordinal", "", "type", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$CellType;", "offset", "length", "(ILorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$CellType;II)V", "getLength", "()I", "getOffset", "getOrdinal", "getType", "()Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$CellType;", "compareTo", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "", "intellij.notebooks.visualization"})
    public static final class Marker
    implements Comparable<Marker> {
        private final int ordinal;
        @NotNull
        private final CellType type;
        private final int offset;
        private final int length;

        @Override
        public int compareTo(@NotNull Marker other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.offset - other.offset;
        }

        public final int getOrdinal() {
            return this.ordinal;
        }

        @NotNull
        public final CellType getType() {
            return this.type;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int getLength() {
            return this.length;
        }

        public Marker(int ordinal, @NotNull CellType type, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.ordinal = ordinal;
            this.type = type;
            this.offset = offset;
            this.length = length;
        }

        public final int component1() {
            return this.ordinal;
        }

        @NotNull
        public final CellType component2() {
            return this.type;
        }

        public final int component3() {
            return this.offset;
        }

        public final int component4() {
            return this.length;
        }

        @NotNull
        public final Marker copy(int ordinal, @NotNull CellType type, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new Marker(ordinal, type, offset, length);
        }

        public static /* synthetic */ Marker copy$default(Marker marker, int n, CellType cellType, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = marker.ordinal;
            }
            if ((n4 & 2) != 0) {
                cellType = marker.type;
            }
            if ((n4 & 4) != 0) {
                n2 = marker.offset;
            }
            if ((n4 & 8) != 0) {
                n3 = marker.length;
            }
            return marker.copy(n, cellType, n2, n3);
        }

        @NotNull
        public String toString() {
            return "Marker(ordinal=" + this.ordinal + ", type=" + (Object)((Object)this.type) + ", offset=" + this.offset + ", length=" + this.length + ")";
        }

        public int hashCode() {
            CellType cellType = this.type;
            return ((Integer.hashCode(this.ordinal) * 31 + (cellType != null ? ((Object)((Object)cellType)).hashCode() : 0)) * 31 + Integer.hashCode(this.offset)) * 31 + Integer.hashCode(this.length);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Marker)) break block3;
                    Marker marker = (Marker)object;
                    if (this.ordinal != marker.ordinal || !Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)marker.type)) || this.offset != marker.offset || this.length != marker.length) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$MarkersAtLines;", "", "hasTopLine", "", "hasBottomLine", "(Ljava/lang/String;IZZ)V", "getHasBottomLine", "()Z", "getHasTopLine", "NO", "TOP", "BOTTOM", "TOP_AND_BOTTOM", "intellij.notebooks.visualization"})
    public static final class MarkersAtLines
    extends Enum<MarkersAtLines> {
        public static final /* enum */ MarkersAtLines NO;
        public static final /* enum */ MarkersAtLines TOP;
        public static final /* enum */ MarkersAtLines BOTTOM;
        public static final /* enum */ MarkersAtLines TOP_AND_BOTTOM;
        private static final /* synthetic */ MarkersAtLines[] $VALUES;
        private final boolean hasTopLine;
        private final boolean hasBottomLine;

        static {
            MarkersAtLines[] markersAtLinesArray = new MarkersAtLines[4];
            MarkersAtLines[] markersAtLinesArray2 = markersAtLinesArray;
            markersAtLinesArray[0] = NO = new MarkersAtLines(false, false);
            markersAtLinesArray[1] = TOP = new MarkersAtLines(true, false);
            markersAtLinesArray[2] = BOTTOM = new MarkersAtLines(false, true);
            markersAtLinesArray[3] = TOP_AND_BOTTOM = new MarkersAtLines(true, true);
            $VALUES = markersAtLinesArray;
        }

        public final boolean getHasTopLine() {
            return this.hasTopLine;
        }

        public final boolean getHasBottomLine() {
            return this.hasBottomLine;
        }

        private MarkersAtLines(boolean hasTopLine, boolean hasBottomLine) {
            this.hasTopLine = hasTopLine;
            this.hasBottomLine = hasBottomLine;
        }

        public static MarkersAtLines[] values() {
            return (MarkersAtLines[])$VALUES.clone();
        }

        public static MarkersAtLines valueOf(String string) {
            return Enum.valueOf(MarkersAtLines.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Interval;", "", "ordinal", "", "type", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$CellType;", "lines", "Lkotlin/ranges/IntRange;", "markers", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$MarkersAtLines;", "(ILorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$CellType;Lkotlin/ranges/IntRange;Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$MarkersAtLines;)V", "getLines", "()Lkotlin/ranges/IntRange;", "getMarkers", "()Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$MarkersAtLines;", "getOrdinal", "()I", "getType", "()Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$CellType;", "compareTo", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "", "intellij.notebooks.visualization"})
    public static final class Interval
    implements Comparable<Interval> {
        private final int ordinal;
        @NotNull
        private final CellType type;
        @NotNull
        private final IntRange lines;
        @NotNull
        private final MarkersAtLines markers;

        @Override
        public int compareTo(@NotNull Interval other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.lines.getFirst() - other.lines.getFirst();
        }

        public final int getOrdinal() {
            return this.ordinal;
        }

        @NotNull
        public final CellType getType() {
            return this.type;
        }

        @NotNull
        public final IntRange getLines() {
            return this.lines;
        }

        @NotNull
        public final MarkersAtLines getMarkers() {
            return this.markers;
        }

        public Interval(int ordinal, @NotNull CellType type, @NotNull IntRange lines, @NotNull MarkersAtLines markers) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)((Object)markers), (String)"markers");
            this.ordinal = ordinal;
            this.type = type;
            this.lines = lines;
            this.markers = markers;
        }

        public final int component1() {
            return this.ordinal;
        }

        @NotNull
        public final CellType component2() {
            return this.type;
        }

        @NotNull
        public final IntRange component3() {
            return this.lines;
        }

        @NotNull
        public final MarkersAtLines component4() {
            return this.markers;
        }

        @NotNull
        public final Interval copy(int ordinal, @NotNull CellType type, @NotNull IntRange lines, @NotNull MarkersAtLines markers) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)((Object)markers), (String)"markers");
            return new Interval(ordinal, type, lines, markers);
        }

        public static /* synthetic */ Interval copy$default(Interval interval, int n, CellType cellType, IntRange intRange, MarkersAtLines markersAtLines, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = interval.ordinal;
            }
            if ((n2 & 2) != 0) {
                cellType = interval.type;
            }
            if ((n2 & 4) != 0) {
                intRange = interval.lines;
            }
            if ((n2 & 8) != 0) {
                markersAtLines = interval.markers;
            }
            return interval.copy(n, cellType, intRange, markersAtLines);
        }

        @NotNull
        public String toString() {
            return "Interval(ordinal=" + this.ordinal + ", type=" + (Object)((Object)this.type) + ", lines=" + this.lines + ", markers=" + (Object)((Object)this.markers) + ")";
        }

        public int hashCode() {
            CellType cellType = this.type;
            IntRange intRange = this.lines;
            MarkersAtLines markersAtLines = this.markers;
            return ((Integer.hashCode(this.ordinal) * 31 + (cellType != null ? ((Object)((Object)cellType)).hashCode() : 0)) * 31 + (intRange != null ? intRange.hashCode() : 0)) * 31 + (markersAtLines != null ? ((Object)((Object)markersAtLines)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Interval)) break block3;
                    Interval interval = (Interval)object;
                    if (this.ordinal != interval.ordinal || !Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)interval.type)) || !Intrinsics.areEqual((Object)this.lines, (Object)interval.lines) || !Intrinsics.areEqual((Object)((Object)this.markers), (Object)((Object)interval.markers))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$IntervalListener;", "Ljava/util/EventListener;", "segmentChanged", "", "oldIntervals", "", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Interval;", "newIntervals", "intellij.notebooks.visualization"})
    public static interface IntervalListener
    extends EventListener {
        public void segmentChanged(@NotNull List<Interval> var1, @NotNull List<Interval> var2);
    }

    @Metadata(mv={1, 5, 1}, k=3)
    public static final class DefaultImpls {
        public static /* synthetic */ ListIterator intervalsIterator$default(NotebookCellLines notebookCellLines, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: intervalsIterator");
            }
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return notebookCellLines.intervalsIterator(n);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Companion;", "", "()V", "get", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines;", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasSupport", "", "intellij.notebooks.visualization"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final NotebookCellLines get(@NotNull Editor editor) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    object = NotebookCellLinesProviderKt.getNotebookCellLinesProvider(editor);
                    if (object == null) break block2;
                    Document document = editor.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                    if ((object = object.create(document)) != null) break block3;
                }
                String string = "Can't get for " + editor + " with document " + editor.getDocument();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return object;
        }

        public final boolean hasSupport(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return NotebookCellLinesProviderKt.getNotebookCellLinesProvider(editor) != null;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

