/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.editor.NotebookCellLines;
import org.jetbrains.plugins.notebooks.editor.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.editor.NotebookEditorAppearanceProviderKt;
import org.jetbrains.plugins.notebooks.editor.NotebookVisualizationUiUtilKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u00a6\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006\u001a\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018\u001aL\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u000e\b\u0006\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0086\b\u00f8\u0001\u0000\u001a`\u0010$\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0\f0%\"\u0004\b\u0000\u0010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0\f2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0\f2\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020\u000f0*H\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010+\u001a\u00020\u001a*\u00020,2\u0006\u0010-\u001a\u00020.\u001a\u0014\u0010/\u001a\u0004\u0018\u000100*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u00101\u001a\u00020\u0002*\u00020,2\u0006\u0010\u0012\u001a\u00020\u0006\u001a\u0012\u00102\u001a\u00020\u0002*\u00020,2\u0006\u00103\u001a\u00020\u0006\u001a\u0018\u00104\u001a\b\u0012\u0004\u0012\u00020\u00020\f*\u00020,2\u0006\u00105\u001a\u00020\u0001\u001a\u0018\u00104\u001a\b\u0012\u0004\u0012\u00020\u000206*\u0002072\u0006\u00105\u001a\u00020\u0001\u001a\u0014\u00108\u001a\u000200*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a\u0012\u00109\u001a\u000200*\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0002\u001a\u0014\u0010:\u001a\u0004\u0018\u000100*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0015\u0010;\u001a\u00020\u000f*\u00020\u00012\u0006\u0010<\u001a\u00020\u0001H\u0086\u0004\u001a\u001e\u0010=\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u00010>2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u001a2\u0010?\u001a\u00020\u001a*\u00020@2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020B2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006\u001aH\u0010C\u001a\u0002H&\"\u0004\b\u0000\u0010&\"\b\b\u0001\u0010D*\u00020\u001c*\u0002HD2!\u0010E\u001a\u001d\u0012\u0013\u0012\u0011HD\u00a2\u0006\f\bG\u0012\b\bH\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u0002H&0FH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010I\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006J"}, d2={"contentLines", "Lkotlin/ranges/IntRange;", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Interval;", "getContentLines", "(Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Interval;)Lkotlin/ranges/IntRange;", "firstContentLine", "", "getFirstContentLine", "(Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Interval;)I", "lastContentLine", "getLastContentLine", "groupNeighborCells", "", "cells", "isLineVisible", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "line", "makeMarkersFromIntervals", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Marker;", "document", "Lcom/intellij/openapi/editor/Document;", "intervals", "", "paintNotebookCellBackgroundGutter", "", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "interval", "top", "height", "actionBetweenBackgroundAndStripe", "Lkotlin/Function0;", "trimLists", "Lkotlin/Pair;", "T", "left", "right", "comparator", "Lkotlin/Function2;", "addEditorDocumentListener", "Lcom/intellij/openapi/editor/Editor;", "listener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "getBottomMarker", "", "getCell", "getCellByOrdinal", "ordinal", "getCells", "lines", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines;", "getLineText", "getText", "getTopMarker", "hasIntersectionWith", "other", "mergeAndJoinIntersections", "", "paintCellStripe", "Lorg/jetbrains/plugins/notebooks/editor/NotebookEditorAppearance;", "stripe", "Ljava/awt/Color;", "use", "G", "handler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "(Ljava/awt/Graphics;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.notebooks.visualization"})
public final class NotebookVisualizationUiUtilKt {
    public static final boolean hasIntersectionWith(@NotNull IntRange $this$hasIntersectionWith, @NotNull IntRange other) {
        Intrinsics.checkNotNullParameter((Object)$this$hasIntersectionWith, (String)"$this$hasIntersectionWith");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$hasIntersectionWith.getFirst() <= other.getLast() && $this$hasIntersectionWith.getLast() >= other.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T, G extends Graphics> T use(@NotNull G $this$use, @NotNull Function1<? super G, ? extends T> handler) {
        Object object;
        int $i$f$use = 0;
        Intrinsics.checkNotNullParameter($this$use, (String)"$this$use");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        try {
            object = handler.invoke($this$use);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$use.dispose();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    @NotNull
    public static final <T> Pair<List<T>, List<T>> trimLists(@NotNull List<? extends T> left, @NotNull List<? extends T> right, @NotNull Function2<? super T, ? super T, Boolean> comparator) {
        int trimRight;
        int trimLeft;
        int $i$f$trimLists = 0;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        int n = left.size();
        int n2 = right.size();
        boolean bl = false;
        int minSize = Math.min(n, n2);
        for (trimLeft = 0; trimLeft < minSize && ((Boolean)comparator.invoke(left.get(trimLeft), right.get(trimLeft))).booleanValue(); ++trimLeft) {
        }
        for (trimRight = 0; trimRight < minSize - trimLeft && ((Boolean)comparator.invoke(left.get(left.size() - trimRight - 1), right.get(right.size() - trimRight - 1))).booleanValue(); ++trimRight) {
        }
        List<T> list = left;
        boolean bl2 = false;
        boolean bl3 = false;
        List<T> $this$run = list;
        boolean bl4 = false;
        List<? extends T> list2 = $this$run.subList(trimLeft, $this$run.size() - trimRight);
        list = right;
        bl2 = false;
        bl3 = false;
        $this$run = list;
        List<? extends T> list3 = list2;
        boolean bl5 = false;
        List<T> list4 = $this$run.subList(trimLeft, $this$run.size() - trimRight);
        return TuplesKt.to(list3, list4);
    }

    public static final void paintNotebookCellBackgroundGutter(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull NotebookCellLines.Interval interval, int top, int height, @NotNull Function0<Unit> actionBetweenBackgroundAndStripe) {
        int $i$f$paintNotebookCellBackgroundGutter = 0;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter(actionBetweenBackgroundAndStripe, (String)"actionBetweenBackgroundAndStripe");
        NotebookEditorAppearance appearance = NotebookEditorAppearanceProviderKt.getNotebookAppearance((Editor)editor);
        Color stripe = appearance.getCellStripeColor(editor, interval);
        Color stripeHover = appearance.getCellStripeHoverColor(editor, interval);
        int borderWidth = appearance.getLeftBorderWidth();
        int rectBorderCellX = r.width - borderWidth;
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
        g.setColor(appearance.getCodeCellBackground(editorColorsScheme));
        if (editor.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(rectBorderCellX + 3, top, borderWidth - 3, height);
        } else {
            g.fillRect(rectBorderCellX, top, borderWidth, height);
        }
        actionBetweenBackgroundAndStripe.invoke();
        if (editor.getEditorKind() == EditorKind.DIFF) {
            return;
        }
        if (stripe != null) {
            NotebookVisualizationUiUtilKt.paintCellStripe(appearance, g, r, stripe, top, height);
        }
        if (stripeHover != null) {
            g.setColor(stripeHover);
            g.fillRect(r.width - appearance.getLeftBorderWidth(), top, appearance.getCellLeftLineHoverWidth(), height);
        }
    }

    public static /* synthetic */ void paintNotebookCellBackgroundGutter$default(EditorImpl editor, Graphics g, Rectangle r, NotebookCellLines.Interval interval, int top, int height, Function0 actionBetweenBackgroundAndStripe, int n, Object object) {
        if ((n & 0x40) != 0) {
            actionBetweenBackgroundAndStripe = paintNotebookCellBackgroundGutter.1.INSTANCE;
        }
        boolean $i$f$paintNotebookCellBackgroundGutter = false;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)actionBetweenBackgroundAndStripe, (String)"actionBetweenBackgroundAndStripe");
        NotebookEditorAppearance appearance = NotebookEditorAppearanceProviderKt.getNotebookAppearance((Editor)editor);
        Color stripe = appearance.getCellStripeColor(editor, interval);
        Color stripeHover = appearance.getCellStripeHoverColor(editor, interval);
        int borderWidth = appearance.getLeftBorderWidth();
        int rectBorderCellX = r.width - borderWidth;
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
        g.setColor(appearance.getCodeCellBackground(editorColorsScheme));
        if (editor.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(rectBorderCellX + 3, top, borderWidth - 3, height);
        } else {
            g.fillRect(rectBorderCellX, top, borderWidth, height);
        }
        actionBetweenBackgroundAndStripe.invoke();
        if (editor.getEditorKind() == EditorKind.DIFF) {
            return;
        }
        if (stripe != null) {
            NotebookVisualizationUiUtilKt.paintCellStripe(appearance, g, r, stripe, top, height);
        }
        if (stripeHover != null) {
            g.setColor(stripeHover);
            g.fillRect(r.width - appearance.getLeftBorderWidth(), top, appearance.getCellLeftLineHoverWidth(), height);
        }
    }

    public static final void paintCellStripe(@NotNull NotebookEditorAppearance $this$paintCellStripe, @NotNull Graphics g, @NotNull Rectangle r, @NotNull Color stripe, int top, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$paintCellStripe, (String)"$this$paintCellStripe");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)stripe, (String)"stripe");
        g.setColor(stripe);
        g.fillRect(r.width - $this$paintCellStripe.getLeftBorderWidth(), top, $this$paintCellStripe.getCellLeftLineWidth(), height);
    }

    public static final void addEditorDocumentListener(@NotNull Editor $this$addEditorDocumentListener, @NotNull DocumentListener listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$addEditorDocumentListener, (String)"$this$addEditorDocumentListener");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        boolean bl = $this$addEditorDocumentListener instanceof EditorImpl;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (!((EditorImpl)$this$addEditorDocumentListener).isDisposed()) {
            ((EditorImpl)$this$addEditorDocumentListener).getDocument().addDocumentListener(listener2, ((EditorImpl)$this$addEditorDocumentListener).getDisposable());
        }
    }

    @NotNull
    public static final String getText(@NotNull Document $this$getText, @NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"$this$getText");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        String string = $this$getText.getText(new TextRange($this$getText.getLineStartOffset(interval.getLines().getFirst()), $this$getText.getLineEndOffset(interval.getLines().getLast())));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(TextRange(\n    g\u2026interval.lines.last)\n  ))");
        return string;
    }

    private static final String getLineText(Document $this$getLineText, int line) {
        String string = $this$getLineText.getText(new TextRange($this$getLineText.getLineStartOffset(line), $this$getLineText.getLineEndOffset(line)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(TextRange(getLin\u2026 getLineEndOffset(line)))");
        return string;
    }

    @NotNull
    public static final NotebookCellLines.Interval getCell(@NotNull Editor $this$getCell, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$getCell, (String)"$this$getCell");
        return NotebookCellLines.Companion.get($this$getCell).intervalsIterator(line).next();
    }

    @NotNull
    public static final List<NotebookCellLines.Interval> getCells(@NotNull Editor $this$getCells, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)$this$getCells, (String)"$this$getCells");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        return SequencesKt.toList(NotebookVisualizationUiUtilKt.getCells(NotebookCellLines.Companion.get($this$getCells), lines));
    }

    @NotNull
    public static final NotebookCellLines.Interval getCellByOrdinal(@NotNull Editor $this$getCellByOrdinal, int ordinal) {
        Intrinsics.checkNotNullParameter((Object)$this$getCellByOrdinal, (String)"$this$getCellByOrdinal");
        return NotebookCellLines.Companion.get($this$getCellByOrdinal).getIntervals().get(ordinal);
    }

    @NotNull
    public static final Sequence<NotebookCellLines.Interval> getCells(@NotNull NotebookCellLines $this$getCells, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)$this$getCells, (String)"$this$getCells");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        return SequencesKt.takeWhile((Sequence)SequencesKt.asSequence((Iterator)$this$getCells.intervalsIterator(lines.getFirst())), (Function1)((Function1)new Function1<NotebookCellLines.Interval, Boolean>(lines){
            final /* synthetic */ IntRange $lines;

            public final boolean invoke(@NotNull NotebookCellLines.Interval it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getLines().getFirst() <= this.$lines.getLast();
            }
            {
                this.$lines = intRange;
                super(1);
            }
        }));
    }

    @Nullable
    public static final String getTopMarker(@NotNull NotebookCellLines.Interval $this$getTopMarker, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$getTopMarker, (String)"$this$getTopMarker");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return $this$getTopMarker.getMarkers().getHasTopLine() ? NotebookVisualizationUiUtilKt.getLineText(document, $this$getTopMarker.getLines().getFirst()) : null;
    }

    @Nullable
    public static final String getBottomMarker(@NotNull NotebookCellLines.Interval $this$getBottomMarker, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$getBottomMarker, (String)"$this$getBottomMarker");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return $this$getBottomMarker.getMarkers().getHasBottomLine() ? NotebookVisualizationUiUtilKt.getLineText(document, $this$getBottomMarker.getLines().getLast()) : null;
    }

    public static final int getFirstContentLine(@NotNull NotebookCellLines.Interval $this$firstContentLine) {
        Intrinsics.checkNotNullParameter((Object)$this$firstContentLine, (String)"$this$firstContentLine");
        return $this$firstContentLine.getMarkers().getHasTopLine() ? $this$firstContentLine.getLines().getFirst() + 1 : $this$firstContentLine.getLines().getFirst();
    }

    public static final int getLastContentLine(@NotNull NotebookCellLines.Interval $this$lastContentLine) {
        Intrinsics.checkNotNullParameter((Object)$this$lastContentLine, (String)"$this$lastContentLine");
        return $this$lastContentLine.getMarkers().getHasBottomLine() ? $this$lastContentLine.getLines().getLast() - 1 : $this$lastContentLine.getLines().getLast();
    }

    @NotNull
    public static final IntRange getContentLines(@NotNull NotebookCellLines.Interval $this$contentLines) {
        Intrinsics.checkNotNullParameter((Object)$this$contentLines, (String)"$this$contentLines");
        int n = NotebookVisualizationUiUtilKt.getFirstContentLine($this$contentLines);
        return new IntRange(n, NotebookVisualizationUiUtilKt.getLastContentLine($this$contentLines));
    }

    @NotNull
    public static final List<NotebookCellLines.Marker> makeMarkersFromIntervals(@NotNull Document document, @NotNull Iterable<NotebookCellLines.Interval> intervals) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(intervals, (String)"intervals");
        ArrayList markers = new ArrayList();
        Function2<Integer, NotebookCellLines.CellType, Unit> $fun$addMarker$1 = new Function2<Integer, NotebookCellLines.CellType, Unit>(document, markers){
            final /* synthetic */ Document $document;
            final /* synthetic */ ArrayList $markers;

            public final void invoke(int line, @NotNull NotebookCellLines.CellType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                int startOffset = this.$document.getLineStartOffset(line);
                int endOffset = line + 1 < this.$document.getLineCount() ? this.$document.getLineStartOffset(line + 1) : this.$document.getLineEndOffset(line);
                int length = endOffset - startOffset;
                this.$markers.add(new NotebookCellLines.Marker(this.$markers.size(), type, startOffset, length));
            }
            {
                this.$document = document;
                this.$markers = arrayList;
                super(2);
            }
        };
        for (NotebookCellLines.Interval interval : intervals) {
            if (interval.getMarkers().getHasTopLine()) {
                $fun$addMarker$1.invoke(interval.getLines().getFirst(), interval.getType());
            }
            if (!interval.getMarkers().getHasBottomLine()) continue;
            $fun$addMarker$1.invoke(interval.getLines().getLast(), interval.getType());
        }
        return markers;
    }

    @NotNull
    public static final List<List<NotebookCellLines.Interval>> groupNeighborCells(@NotNull List<NotebookCellLines.Interval> cells) {
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        SmartList groups = new SmartList();
        for (NotebookCellLines.Interval cell : cells) {
            block4: {
                block3: {
                    Object object = (SmartList)CollectionsKt.lastOrNull((List)((List)groups));
                    if (object == null || (object = (NotebookCellLines.Interval)CollectionsKt.last((List)((List)object))) == null) break block3;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    if (((NotebookCellLines.Interval)it).getOrdinal() + 1 == cell.getOrdinal()) break block4;
                }
                groups.add((Object)new SmartList());
            }
            ((SmartList)CollectionsKt.last((List)((List)groups))).add((Object)cell);
        }
        return (List)groups;
    }

    public static final void mergeAndJoinIntersections(@NotNull List<IntRange> $this$mergeAndJoinIntersections, @NotNull List<IntRange> other) {
        Intrinsics.checkNotNullParameter($this$mergeAndJoinIntersections, (String)"$this$mergeAndJoinIntersections");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        List list = ContainerUtil.mergeSortedLists($this$mergeAndJoinIntersections, other, (Comparator)mergeAndJoinIntersections.merged.1.INSTANCE, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.mergeSorte\u2026irst - o2.first }, false)");
        List merged2 = list;
        $this$mergeAndJoinIntersections.clear();
        for (IntRange current : merged2) {
            IntRange previous = (IntRange)CollectionsKt.removeLastOrNull($this$mergeAndJoinIntersections);
            if (previous == null) {
                IntRange intRange = current;
                Intrinsics.checkNotNullExpressionValue((Object)intRange, (String)"current");
                $this$mergeAndJoinIntersections.add(intRange);
                continue;
            }
            if (previous.getLast() + 1 >= current.getFirst()) {
                int n;
                int n2 = n = previous.getFirst();
                n = previous.getLast();
                int n3 = current.getLast();
                boolean bl = false;
                $this$mergeAndJoinIntersections.add(new IntRange(n2, Math.max(n, n3)));
                continue;
            }
            $this$mergeAndJoinIntersections.add(previous);
            IntRange intRange = current;
            Intrinsics.checkNotNullExpressionValue((Object)intRange, (String)"current");
            $this$mergeAndJoinIntersections.add(intRange);
        }
    }

    public static final boolean isLineVisible(@NotNull EditorImpl editor, int line) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int lineY = editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
        ScrollingModelEx scrollingModelEx = editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModelEx, (String)"editor.scrollingModel");
        Rectangle rectangle = scrollingModelEx.getVisibleAreaOnScrollingFinished();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"editor.scrollingModel.vi\u2026leAreaOnScrollingFinished");
        Rectangle viewArea = rectangle;
        return viewArea.y <= lineY && lineY <= viewArea.y + viewArea.height;
    }
}

