/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.ShortArrayList;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortDeque;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortArrayDeque
extends AbstractShortCollection
implements ShortDeque,
Preallocable,
Cloneable,
Accountable {
    public short[] buffer = ShortArrayList.EMPTY_ARRAY;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;

    public ShortArrayDeque() {
        this(4);
    }

    public ShortArrayDeque(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public ShortArrayDeque(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public ShortArrayDeque(ShortContainer container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(short e1) {
        int h = ShortArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = ShortArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    public final void addFirst(short ... elements) {
        this.ensureBufferSpace(elements.length);
        for (short k : elements) {
            this.addFirst(k);
        }
    }

    public int addFirst(ShortContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ShortCursor cursor : container) {
            this.addFirst(cursor.value);
        }
        return size;
    }

    public int addFirst(Iterable<? extends ShortCursor> iterable) {
        int size = 0;
        for (ShortCursor shortCursor : iterable) {
            this.addFirst(shortCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(short e1) {
        int t = ShortArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = ShortArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public final void addLast(short ... elements) {
        this.ensureBufferSpace(1);
        for (short k : elements) {
            this.addLast(k);
        }
    }

    public int addLast(ShortContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ShortCursor cursor : container) {
            this.addLast(cursor.value);
        }
        return size;
    }

    public int addLast(Iterable<? extends ShortCursor> iterable) {
        int size = 0;
        for (ShortCursor shortCursor : iterable) {
            this.addLast(shortCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public short removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        short result2 = this.buffer[this.head];
        this.buffer[this.head] = 0;
        this.head = ShortArrayDeque.oneRight(this.head, this.buffer.length);
        return result2;
    }

    @Override
    public short removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = ShortArrayDeque.oneLeft(this.tail, this.buffer.length);
        short result2 = this.buffer[this.tail];
        this.buffer[this.tail] = 0;
        return result2;
    }

    @Override
    public short getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public short getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[ShortArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirst(short e1) {
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int bufferIndexOf(short e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        int i2 = this.head;
        while (i2 != last) {
            if (this.buffer[i2] == e1) {
                return i2;
            }
            i2 = ShortArrayDeque.oneRight(i2, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLast(short e1) {
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int lastBufferIndexOf(short e1) {
        int bufLen = this.buffer.length;
        int last = ShortArrayDeque.oneLeft(this.head, bufLen);
        int i2 = ShortArrayDeque.oneLeft(this.tail, bufLen);
        while (i2 != last) {
            if (this.buffer[i2] == e1) {
                return i2;
            }
            i2 = ShortArrayDeque.oneLeft(i2, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAll(short e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        while (from != last) {
            if (this.buffer[from] == e1) {
                this.buffer[from] = 0;
                ++removed;
            } else {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                to = ShortArrayDeque.oneRight(to, bufLen);
            }
            from = ShortArrayDeque.oneRight(from, bufLen);
        }
        this.tail = to;
        return removed;
    }

    public void removeAtBufferIndex(int index) {
        int rightChunk;
        assert (this.head > this.tail ? index >= this.head || index < this.tail : index >= this.head && index < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index + ").";
        short[] buffer = this.buffer;
        int bufLen = buffer.length;
        int lastIndex = bufLen - 1;
        int head2 = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index - head2) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index) % bufLen)) {
            if (index >= head2) {
                System.arraycopy(buffer, head2, buffer, head2 + 1, leftChunk);
            } else {
                System.arraycopy(buffer, 0, buffer, 1, index);
                buffer[0] = buffer[lastIndex];
                System.arraycopy(buffer, head2, buffer, head2 + 1, lastIndex - head2);
            }
            buffer[head2] = 0;
            this.head = ShortArrayDeque.oneRight(head2, bufLen);
        } else {
            if (index < tail) {
                System.arraycopy(buffer, index + 1, buffer, index, rightChunk);
            } else {
                System.arraycopy(buffer, index + 1, buffer, index, lastIndex - index);
                buffer[lastIndex] = buffer[0];
                System.arraycopy(buffer, 1, buffer, 0, tail);
            }
            buffer[tail] = 0;
            this.tail = ShortArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, (short)0);
        } else {
            Arrays.fill(this.buffer, 0, this.tail, (short)0);
            Arrays.fill(this.buffer, this.head, this.buffer.length, (short)0);
        }
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = ShortArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.ensureBufferSpace(expectedElements - this.size());
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer.length;
        int elementsCount = this.size();
        if (elementsCount + expectedAdditions >= bufferLen) {
            boolean emptySlot = true;
            int newSize = this.resizer.grow(bufferLen, elementsCount + 1, expectedAdditions);
            assert (newSize >= elementsCount + expectedAdditions + 1) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            try {
                short[] newBuffer = new short[newSize];
                if (bufferLen > 0) {
                    this.toArray(newBuffer);
                    this.tail = elementsCount;
                    this.head = 0;
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public short[] toArray() {
        int size = this.size();
        return this.toArray(new short[size]);
    }

    public short[] toArray(short[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public ShortArrayDeque clone() {
        try {
            ShortArrayDeque cloned = (ShortArrayDeque)super.clone();
            cloned.buffer = (short[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static int oneLeft(int index, int modulus) {
        if (index >= 1) {
            return index - 1;
        }
        return modulus - 1;
    }

    protected static int oneRight(int index, int modulus) {
        if (index + 1 == modulus) {
            return 0;
        }
        return index + 1;
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowSizeOf(this.resizer) + RamUsageEstimator.shallowSizeOf(this.buffer);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowSizeOf(this.resizer) + RamUsageEstimator.shallowUsedSizeOfArray(this.buffer, this.size());
    }

    @Override
    public Iterator<ShortCursor> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<ShortCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    @Override
    public <T extends ShortProcedure> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(ShortProcedure procedure, int fromIndex, int toIndex) {
        short[] buffer = this.buffer;
        int i2 = fromIndex;
        while (i2 != toIndex) {
            procedure.apply(buffer[i2]);
            i2 = ShortArrayDeque.oneRight(i2, buffer.length);
        }
    }

    @Override
    public <T extends ShortPredicate> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        short[] buffer = this.buffer;
        int i2 = fromIndex;
        while (i2 != toIndex && predicate.apply(buffer[i2])) {
            i2 = ShortArrayDeque.oneRight(i2, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends ShortProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(ShortProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        short[] buffer = this.buffer;
        int i2 = toIndex;
        do {
            i2 = ShortArrayDeque.oneLeft(i2, buffer.length);
            procedure.apply(buffer[i2]);
        } while (i2 != fromIndex);
    }

    @Override
    public <T extends ShortPredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(ShortPredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        short[] buffer = this.buffer;
        int i2 = toIndex;
        while (predicate.apply(buffer[i2 = ShortArrayDeque.oneLeft(i2, buffer.length)]) && i2 != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ShortPredicate predicate) {
        int to;
        short[] buffer = this.buffer;
        int last = this.tail;
        int bufLen = buffer.length;
        int removed = 0;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(buffer[from])) {
                    buffer[from] = 0;
                    ++removed;
                } else {
                    if (to != from) {
                        buffer[to] = buffer[from];
                        buffer[from] = 0;
                    }
                    to = ShortArrayDeque.oneRight(to, bufLen);
                }
                from = ShortArrayDeque.oneRight(from, bufLen);
            }
        }
        finally {
            while (from != last) {
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = 0;
                }
                to = ShortArrayDeque.oneRight(to, bufLen);
                from = ShortArrayDeque.oneRight(from, bufLen);
            }
            this.tail = to;
        }
        return removed;
    }

    @Override
    public boolean contains(short e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        short[] buffer = this.buffer;
        int i2 = fromIndex;
        while (i2 != toIndex) {
            if (buffer[i2] == e) {
                return true;
            }
            i2 = ShortArrayDeque.oneRight(i2, buffer.length);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        short[] buffer = this.buffer;
        int i2 = fromIndex;
        while (i2 != toIndex) {
            h = 31 * h + BitMixer.mix(this.buffer[i2]);
            i2 = ShortArrayDeque.oneRight(i2, buffer.length);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ShortArrayDeque)this.getClass().cast(obj));
    }

    protected boolean equalElements(ShortArrayDeque other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        Iterator<ShortCursor> i1 = this.iterator();
        Iterator<ShortCursor> i2 = other.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i2.next().value == i1.next().value) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public static ShortArrayDeque from(short ... elements) {
        ShortArrayDeque coll = new ShortArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = ShortArrayDeque.this.tail;
            this.remaining = ShortArrayDeque.this.size();
        }

        @Override
        protected ShortCursor fetch() {
            if (this.remaining == 0) {
                return (ShortCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = ShortArrayDeque.oneLeft(this.cursor.index, ShortArrayDeque.this.buffer.length);
            this.cursor.value = ShortArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = ShortArrayDeque.oneLeft(ShortArrayDeque.this.head, ShortArrayDeque.this.buffer.length);
            this.remaining = ShortArrayDeque.this.size();
        }

        @Override
        protected ShortCursor fetch() {
            if (this.remaining == 0) {
                return (ShortCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = ShortArrayDeque.oneRight(this.cursor.index, ShortArrayDeque.this.buffer.length);
            this.cursor.value = ShortArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

