/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.detection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.config.DetectionContext;
import com.intellij.grazie.detection.ExtensionsKt;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.ide.inspection.detection.problem.LanguageDetectionProblemDescriptor;
import com.intellij.grazie.ide.inspection.grammar.GrazieInspection;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grazie/ide/inspection/detection/LanguageDetectionInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getDisplayName", "", "inspectionFinished", "", "inspectionStarted", "Companion", "intellij.grazie.core"})
public final class LanguageDetectionInspection
extends LocalInspectionTool {
    private static final KeyWithDefaultValue<DetectionContext.Local> key;
    @NotNull
    public static final Companion Companion;

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object object = session.getUserData((Key)key);
        Intrinsics.checkNotNull((Object)object);
        ((DetectionContext.Local)object).clear();
    }

    /*
     * WARNING - void declaration
     */
    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder holder) {
        Collection<Language> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        GrazieConfig.State state = GrazieConfig.Companion.get();
        Object object = session.getUserData((Key)key);
        Intrinsics.checkNotNull((Object)object);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"session.getUserData(key)!!");
        DetectionContext.Local context = (DetectionContext.Local)object;
        Iterable iterable = state.getAvailableLanguages();
        Set<Language> set = state.getDetectionContext().getDisabled();
        DetectionContext.Local local = context;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Lang lang = (Lang)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            Language language = ExtensionsKt.toLanguage((Lang)it);
            collection.add(language);
        }
        collection = (List)destination$iv$iv;
        Set<Language> languages2 = local.getToNotify(CollectionsKt.toSet((Iterable)SetsKt.plus(set, (Iterable)collection)));
        if (languages2.isEmpty()) {
            return;
        }
        ProblemDescriptor descriptor2 = (ProblemDescriptor)ReadAction.compute((ThrowableComputable)new ThrowableComputable(holder, session, languages2){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ LocalInspectionToolSession $session;
            final /* synthetic */ Set $languages;

            public final ProblemDescriptor compute() {
                InspectionManager inspectionManager = this.$holder.getManager();
                Intrinsics.checkNotNullExpressionValue((Object)inspectionManager, (String)"holder.manager");
                boolean bl = this.$holder.isOnTheFly();
                PsiFile psiFile = this.$session.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"session.file");
                return LanguageDetectionProblemDescriptor.INSTANCE.create(inspectionManager, bl, psiFile, this.$languages);
            }
            {
                this.$holder = problemsHolder;
                this.$session = localInspectionToolSession;
                this.$languages = set;
            }
        });
        holder.registerProblem(descriptor2);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"holder.file");
        PsiFile file2 = psiFile;
        if (!isOnTheFly || InjectedLanguageManager.getInstance((Project)holder.getProject()).isInjectedFragment(file2) || GrazieInspection.Companion.ignoreGrammarChecking(file2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Set<TextContent.TextDomain> domains = GrazieInspection.Companion.checkedDomains();
        Function1<PsiElement, Boolean> areChecksDisabled = GrazieInspection.Companion.getDisabledChecker(file2);
        return new PsiElementVisitor(areChecksDisabled, session, domains){
            final /* synthetic */ Function1 $areChecksDisabled;
            final /* synthetic */ LocalInspectionToolSession $session;
            final /* synthetic */ Set $domains;

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (((Boolean)this.$areChecksDisabled.invoke((Object)element)).booleanValue()) {
                    return;
                }
                Object object = this.$session.getUserData((Key)LanguageDetectionInspection.access$getKey$cp());
                Intrinsics.checkNotNull((Object)object);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"session.getUserData(key)!!");
                DetectionContext.Local context = (DetectionContext.Local)object;
                List<TextContent> list = TextExtractor.findUniqueTextsAt(element, this.$domains);
                Intrinsics.checkNotNullExpressionValue(list, (String)"TextExtractor.findUniqueTextsAt(element, domains)");
                List<TextContent> texts = list;
                Iterable $this$forEach$iv = texts;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TextContent it = (TextContent)element$iv;
                    boolean bl = false;
                    ProgressManager.checkCanceled();
                    TextContent textContent = it;
                    Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"it");
                    LangDetector.INSTANCE.updateContext(textContent, context);
                }
            }
            {
                this.$areChecksDisabled = $captured_local_variable$0;
                this.$session = $captured_local_variable$1;
                this.$domains = $captured_local_variable$2;
            }
        };
    }

    @NotNull
    public String getDisplayName() {
        return GrazieBundle.INSTANCE.message("grazie.detection.inspection.text", new String[0]);
    }

    static {
        Companion = new Companion(null);
        KeyWithDefaultValue keyWithDefaultValue = KeyWithDefaultValue.create((String)"language-detection-inspection-key", (Object)new DetectionContext.Local(null, 1, null));
        Intrinsics.checkNotNullExpressionValue((Object)keyWithDefaultValue, (String)"KeyWithDefaultValue.crea\u2026DetectionContext.Local())");
        key = keyWithDefaultValue;
    }

    public static final /* synthetic */ KeyWithDefaultValue access$getKey$cp() {
        return key;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/grazie/ide/inspection/detection/LanguageDetectionInspection$Companion;", "", "()V", "key", "Lcom/intellij/openapi/util/KeyWithDefaultValue;", "Lcom/intellij/grazie/config/DetectionContext$Local;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.grazie.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

