/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainText;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PlainTextExtractor
extends TextExtractor {
    private static final Pattern paragraphEnd = Pattern.compile("\\n\\s*?\\n\\s*");

    @Override
    @NotNull
    protected List<TextContent> buildTextContents(@NotNull PsiElement root, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (root == null) {
            PlainTextExtractor.$$$reportNull$$$0(0);
        }
        if (allowedDomains == null) {
            PlainTextExtractor.$$$reportNull$$$0(1);
        }
        if (root instanceof PsiPlainText && root.getContainingFile().getName().endsWith(".txt")) {
            String text2 = root.getText();
            ArrayList<TextContent> result2 = new ArrayList<TextContent>();
            int[] ends = StreamEx.of(Text.allOccurrences(paragraphEnd, text2)).mapToInt(TextRange::getStartOffset).append(new int[]{text2.length()}).toArray();
            for (int i2 = 0; i2 < ends.length; ++i2) {
                int start = i2 == 0 ? 0 : ends[i2 - 1];
                int end = ends[i2];
                ContainerUtil.addIfNotNull(result2, (Object)TextContent.builder().build(root, TextContent.TextDomain.PLAIN_TEXT, new TextRange(start, end)));
            }
            ArrayList<TextContent> arrayList = result2;
            if (arrayList == null) {
                PlainTextExtractor.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        List<TextContent> list = Collections.emptyList();
        if (list == null) {
            PlainTextExtractor.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedDomains";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/text/PlainTextExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/text/PlainTextExtractor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTextContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContents";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

