/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.interfaces.MetricStringDistance;
import net.jcip.annotations.Immutable;

@Immutable
public class Levenshtein
implements MetricStringDistance {
    @Override
    public final double distance(String s1, String s2) {
        return this.distance(s1, s2, Integer.MAX_VALUE);
    }

    public final double distance(String s1, String s2, int limit) {
        int i2;
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 0.0;
        }
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int[] v0 = new int[s2.length() + 1];
        int[] v1 = new int[s2.length() + 1];
        for (i2 = 0; i2 < v0.length; ++i2) {
            v0[i2] = i2;
        }
        for (i2 = 0; i2 < s1.length(); ++i2) {
            v1[0] = i2 + 1;
            int minv1 = v1[0];
            for (int j = 0; j < s2.length(); ++j) {
                int cost = 1;
                if (s1.charAt(i2) == s2.charAt(j)) {
                    cost = 0;
                }
                v1[j + 1] = Math.min(v1[j] + 1, Math.min(v0[j + 1] + 1, v0[j] + cost));
                minv1 = Math.min(minv1, v1[j + 1]);
            }
            if (minv1 >= limit) {
                return limit;
            }
            int[] vtemp = v0;
            v0 = v1;
            v1 = vtemp;
        }
        return v0[s2.length()];
    }
}

